/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import org.apache.commons.lang3.StringUtils;

public class FilterMask {
    public static final Codec<FilterMask> CODEC = INamable.fromEnum(a::values).dispatch(FilterMask::type, a::codec);
    public static final FilterMask FULLY_FILTERED = new FilterMask(new BitSet(0), a.FULLY_FILTERED);
    public static final FilterMask PASS_THROUGH = new FilterMask(new BitSet(0), a.PASS_THROUGH);
    public static final ChatModifier FILTERED_STYLE = ChatModifier.EMPTY.withColor(EnumChatFormat.DARK_GRAY).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.translatable("chat.filtered")));
    static final Codec<FilterMask> PASS_THROUGH_CODEC = Codec.unit((Object)PASS_THROUGH);
    static final Codec<FilterMask> FULLY_FILTERED_CODEC = Codec.unit((Object)FULLY_FILTERED);
    static final Codec<FilterMask> PARTIALLY_FILTERED_CODEC = ExtraCodecs.BIT_SET.xmap(FilterMask::new, FilterMask::mask);
    private static final char HASH = '#';
    private final BitSet mask;
    private final a type;

    private FilterMask(BitSet var0, a var1) {
        this.mask = var0;
        this.type = var1;
    }

    private FilterMask(BitSet var0) {
        this.mask = var0;
        this.type = a.PARTIALLY_FILTERED;
    }

    public FilterMask(int var0) {
        this(new BitSet(var0), a.PARTIALLY_FILTERED);
    }

    private a type() {
        return this.type;
    }

    private BitSet mask() {
        return this.mask;
    }

    public static FilterMask read(PacketDataSerializer var0) {
        a var1 = var0.readEnum(a.class);
        return switch (var1) {
            default -> throw new IncompatibleClassChangeError();
            case a.PASS_THROUGH -> PASS_THROUGH;
            case a.FULLY_FILTERED -> FULLY_FILTERED;
            case a.PARTIALLY_FILTERED -> new FilterMask(var0.readBitSet(), a.PARTIALLY_FILTERED);
        };
    }

    public static void write(PacketDataSerializer var0, FilterMask var1) {
        var0.writeEnum(var1.type);
        if (var1.type == a.PARTIALLY_FILTERED) {
            var0.writeBitSet(var1.mask);
        }
    }

    public void setFiltered(int var0) {
        this.mask.set(var0);
    }

    @Nullable
    public String apply(String var0) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case a.FULLY_FILTERED -> null;
            case a.PASS_THROUGH -> var0;
            case a.PARTIALLY_FILTERED -> {
                char[] var1 = var0.toCharArray();
                for (int var2 = 0; var2 < var1.length && var2 < this.mask.length(); ++var2) {
                    if (!this.mask.get(var2)) continue;
                    var1[var2] = 35;
                }
                yield new String(var1);
            }
        };
    }

    @Nullable
    public IChatBaseComponent applyWithFormatting(String var0) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case a.FULLY_FILTERED -> null;
            case a.PASS_THROUGH -> IChatBaseComponent.literal(var0);
            case a.PARTIALLY_FILTERED -> {
                IChatMutableComponent var1 = IChatBaseComponent.empty();
                int var2 = 0;
                boolean var3 = this.mask.get(0);
                while (true) {
                    int var4 = var3 ? this.mask.nextClearBit(var2) : this.mask.nextSetBit(var2);
                    int v1 = var4 = var4 < 0 ? var0.length() : var4;
                    if (var4 == var2) break;
                    if (var3) {
                        var1.append(IChatBaseComponent.literal(StringUtils.repeat((char)'#', (int)(var4 - var2))).withStyle(FILTERED_STYLE));
                    } else {
                        var1.append(var0.substring(var2, var4));
                    }
                    var3 = !var3;
                    var2 = var4;
                }
                yield var1;
            }
        };
    }

    public boolean isEmpty() {
        return this.type == a.PASS_THROUGH;
    }

    public boolean isFullyFiltered() {
        return this.type == a.FULLY_FILTERED;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        FilterMask var1 = (FilterMask)var0;
        return this.mask.equals(var1.mask) && this.type == var1.type;
    }

    public int hashCode() {
        int var0 = this.mask.hashCode();
        var0 = 31 * var0 + this.type.hashCode();
        return var0;
    }

    static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a PASS_THROUGH = new a("pass_through", () -> PASS_THROUGH_CODEC);
        public static final /* enum */ a FULLY_FILTERED = new a("fully_filtered", () -> FULLY_FILTERED_CODEC);
        public static final /* enum */ a PARTIALLY_FILTERED = new a("partially_filtered", () -> PARTIALLY_FILTERED_CODEC);
        private final String serializedName;
        private final Supplier<Codec<FilterMask>> codec;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2, Supplier var3) {
            this.serializedName = var2;
            this.codec = var3;
        }

        @Override
        public String getSerializedName() {
            return this.serializedName;
        }

        private Codec<FilterMask> codec() {
            return this.codec.get();
        }

        private static /* synthetic */ a[] f() {
            return new a[]{PASS_THROUGH, FULLY_FILTERED, PARTIALLY_FILTERED};
        }

        static {
            f = a.f();
        }
    }
}

