/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;

public class ChatModifier {
    public static final ChatModifier EMPTY = new ChatModifier(null, null, null, null, null, null, null, null, null, null);
    public static final Codec<ChatModifier> FORMATTING_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ChatHexColor.CODEC.optionalFieldOf("color").forGetter(var0 -> Optional.ofNullable(var0.color)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(var0 -> Optional.ofNullable(var0.bold)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(var0 -> Optional.ofNullable(var0.italic)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(var0 -> Optional.ofNullable(var0.underlined)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(var0 -> Optional.ofNullable(var0.strikethrough)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(var0 -> Optional.ofNullable(var0.obfuscated)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(var0 -> Optional.ofNullable(var0.insertion)), (App)MinecraftKey.CODEC.optionalFieldOf("font").forGetter(var0 -> Optional.ofNullable(var0.font))).apply((Applicative)var02, ChatModifier::create));
    public static final MinecraftKey DEFAULT_FONT = new MinecraftKey("minecraft", "default");
    @Nullable
    final ChatHexColor color;
    @Nullable
    final Boolean bold;
    @Nullable
    final Boolean italic;
    @Nullable
    final Boolean underlined;
    @Nullable
    final Boolean strikethrough;
    @Nullable
    final Boolean obfuscated;
    @Nullable
    final ChatClickable clickEvent;
    @Nullable
    final ChatHoverable hoverEvent;
    @Nullable
    final String insertion;
    @Nullable
    final MinecraftKey font;

    private static ChatModifier create(Optional<ChatHexColor> var0, Optional<Boolean> var1, Optional<Boolean> var2, Optional<Boolean> var3, Optional<Boolean> var4, Optional<Boolean> var5, Optional<String> var6, Optional<MinecraftKey> var7) {
        return new ChatModifier(var0.orElse(null), var1.orElse(null), var2.orElse(null), var3.orElse(null), var4.orElse(null), var5.orElse(null), null, null, var6.orElse(null), var7.orElse(null));
    }

    ChatModifier(@Nullable ChatHexColor var0, @Nullable Boolean var1, @Nullable Boolean var2, @Nullable Boolean var3, @Nullable Boolean var4, @Nullable Boolean var5, @Nullable ChatClickable var6, @Nullable ChatHoverable var7, @Nullable String var8, @Nullable MinecraftKey var9) {
        this.color = var0;
        this.bold = var1;
        this.italic = var2;
        this.underlined = var3;
        this.strikethrough = var4;
        this.obfuscated = var5;
        this.clickEvent = var6;
        this.hoverEvent = var7;
        this.insertion = var8;
        this.font = var9;
    }

    @Nullable
    public ChatHexColor getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold == Boolean.TRUE;
    }

    public boolean isItalic() {
        return this.italic == Boolean.TRUE;
    }

    public boolean isStrikethrough() {
        return this.strikethrough == Boolean.TRUE;
    }

    public boolean isUnderlined() {
        return this.underlined == Boolean.TRUE;
    }

    public boolean isObfuscated() {
        return this.obfuscated == Boolean.TRUE;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Nullable
    public ChatClickable getClickEvent() {
        return this.clickEvent;
    }

    @Nullable
    public ChatHoverable getHoverEvent() {
        return this.hoverEvent;
    }

    @Nullable
    public String getInsertion() {
        return this.insertion;
    }

    public MinecraftKey getFont() {
        return this.font != null ? this.font : DEFAULT_FONT;
    }

    public ChatModifier withColor(@Nullable ChatHexColor var0) {
        return new ChatModifier(var0, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withColor(@Nullable EnumChatFormat var0) {
        return this.withColor(var0 != null ? ChatHexColor.fromLegacyFormat(var0) : null);
    }

    public ChatModifier withColor(int var0) {
        return this.withColor(ChatHexColor.fromRgb(var0));
    }

    public ChatModifier withBold(@Nullable Boolean var0) {
        return new ChatModifier(this.color, var0, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withItalic(@Nullable Boolean var0) {
        return new ChatModifier(this.color, this.bold, var0, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withUnderlined(@Nullable Boolean var0) {
        return new ChatModifier(this.color, this.bold, this.italic, var0, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withStrikethrough(@Nullable Boolean var0) {
        return new ChatModifier(this.color, this.bold, this.italic, this.underlined, var0, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withObfuscated(@Nullable Boolean var0) {
        return new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, var0, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withClickEvent(@Nullable ChatClickable var0) {
        return new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, var0, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier withHoverEvent(@Nullable ChatHoverable var0) {
        return new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, var0, this.insertion, this.font);
    }

    public ChatModifier withInsertion(@Nullable String var0) {
        return new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, var0, this.font);
    }

    public ChatModifier withFont(@Nullable MinecraftKey var0) {
        return new ChatModifier(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, var0);
    }

    public ChatModifier applyFormat(EnumChatFormat var0) {
        ChatHexColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        switch (var0) {
            case OBFUSCATED: {
                var6 = true;
                break;
            }
            case BOLD: {
                var2 = true;
                break;
            }
            case STRIKETHROUGH: {
                var4 = true;
                break;
            }
            case UNDERLINE: {
                var5 = true;
                break;
            }
            case ITALIC: {
                var3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                var1 = ChatHexColor.fromLegacyFormat(var0);
            }
        }
        return new ChatModifier(var1, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier applyLegacyFormat(EnumChatFormat var0) {
        ChatHexColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        switch (var0) {
            case OBFUSCATED: {
                var6 = true;
                break;
            }
            case BOLD: {
                var2 = true;
                break;
            }
            case STRIKETHROUGH: {
                var4 = true;
                break;
            }
            case UNDERLINE: {
                var5 = true;
                break;
            }
            case ITALIC: {
                var3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                var6 = false;
                var2 = false;
                var4 = false;
                var5 = false;
                var3 = false;
                var1 = ChatHexColor.fromLegacyFormat(var0);
            }
        }
        return new ChatModifier(var1, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier applyFormats(EnumChatFormat ... var0) {
        ChatHexColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        block8: for (EnumChatFormat var10 : var0) {
            switch (var10) {
                case OBFUSCATED: {
                    var6 = true;
                    continue block8;
                }
                case BOLD: {
                    var2 = true;
                    continue block8;
                }
                case STRIKETHROUGH: {
                    var4 = true;
                    continue block8;
                }
                case UNDERLINE: {
                    var5 = true;
                    continue block8;
                }
                case ITALIC: {
                    var3 = true;
                    continue block8;
                }
                case RESET: {
                    return EMPTY;
                }
                default: {
                    var1 = ChatHexColor.fromLegacyFormat(var10);
                }
            }
        }
        return new ChatModifier(var1, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public ChatModifier applyTo(ChatModifier var0) {
        if (this == EMPTY) {
            return var0;
        }
        if (var0 == EMPTY) {
            return this;
        }
        return new ChatModifier(this.color != null ? this.color : var0.color, this.bold != null ? this.bold : var0.bold, this.italic != null ? this.italic : var0.italic, this.underlined != null ? this.underlined : var0.underlined, this.strikethrough != null ? this.strikethrough : var0.strikethrough, this.obfuscated != null ? this.obfuscated : var0.obfuscated, this.clickEvent != null ? this.clickEvent : var0.clickEvent, this.hoverEvent != null ? this.hoverEvent : var0.hoverEvent, this.insertion != null ? this.insertion : var0.insertion, this.font != null ? this.font : var0.font);
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder("{");
        class A {
            private boolean isNotFirst;
            final /* synthetic */ StringBuilder a;

            A(StringBuilder stringBuilder) {
                this.a = stringBuilder;
            }

            private void prependSeparator() {
                if (this.isNotFirst) {
                    this.a.append(',');
                }
                this.isNotFirst = true;
            }

            void addFlagString(String var0, @Nullable Boolean var1) {
                if (var1 != null) {
                    this.prependSeparator();
                    if (!var1.booleanValue()) {
                        this.a.append('!');
                    }
                    this.a.append(var0);
                }
            }

            void addValueString(String var0, @Nullable Object var1) {
                if (var1 != null) {
                    this.prependSeparator();
                    this.a.append(var0);
                    this.a.append('=');
                    this.a.append(var1);
                }
            }
        }
        A var1 = new A(var0);
        var1.addValueString("color", this.color);
        var1.addFlagString("bold", this.bold);
        var1.addFlagString("italic", this.italic);
        var1.addFlagString("underlined", this.underlined);
        var1.addFlagString("strikethrough", this.strikethrough);
        var1.addFlagString("obfuscated", this.obfuscated);
        var1.addValueString("clickEvent", this.clickEvent);
        var1.addValueString("hoverEvent", this.hoverEvent);
        var1.addValueString("insertion", this.insertion);
        var1.addValueString("font", this.font);
        var0.append("}");
        return var0.toString();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatModifier) {
            ChatModifier var1 = (ChatModifier)var0;
            return this.isBold() == var1.isBold() && Objects.equals(this.getColor(), var1.getColor()) && this.isItalic() == var1.isItalic() && this.isObfuscated() == var1.isObfuscated() && this.isStrikethrough() == var1.isStrikethrough() && this.isUnderlined() == var1.isUnderlined() && Objects.equals(this.getClickEvent(), var1.getClickEvent()) && Objects.equals(this.getHoverEvent(), var1.getHoverEvent()) && Objects.equals(this.getInsertion(), var1.getInsertion()) && Objects.equals(this.getFont(), var1.getFont());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public static class ChatModifierSerializer
    implements JsonDeserializer<ChatModifier>,
    JsonSerializer<ChatModifier> {
        @Nullable
        public ChatModifier deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            if (var0.isJsonObject()) {
                JsonObject var3 = var0.getAsJsonObject();
                if (var3 == null) {
                    return null;
                }
                Boolean var4 = ChatModifierSerializer.getOptionalFlag(var3, "bold");
                Boolean var5 = ChatModifierSerializer.getOptionalFlag(var3, "italic");
                Boolean var6 = ChatModifierSerializer.getOptionalFlag(var3, "underlined");
                Boolean var7 = ChatModifierSerializer.getOptionalFlag(var3, "strikethrough");
                Boolean var8 = ChatModifierSerializer.getOptionalFlag(var3, "obfuscated");
                ChatHexColor var9 = ChatModifierSerializer.getTextColor(var3);
                String var10 = ChatModifierSerializer.getInsertion(var3);
                ChatClickable var11 = ChatModifierSerializer.getClickEvent(var3);
                ChatHoverable var12 = ChatModifierSerializer.getHoverEvent(var3);
                MinecraftKey var13 = ChatModifierSerializer.getFont(var3);
                return new ChatModifier(var9, var4, var5, var6, var7, var8, var11, var12, var10, var13);
            }
            return null;
        }

        @Nullable
        private static MinecraftKey getFont(JsonObject var0) {
            if (var0.has("font")) {
                String var1 = ChatDeserializer.getAsString(var0, "font");
                try {
                    return new MinecraftKey(var1);
                }
                catch (ResourceKeyInvalidException var2) {
                    throw new JsonSyntaxException("Invalid font name: " + var1);
                }
            }
            return null;
        }

        @Nullable
        private static ChatHoverable getHoverEvent(JsonObject var0) {
            JsonObject var1;
            ChatHoverable var2;
            if (var0.has("hoverEvent") && (var2 = ChatHoverable.deserialize(var1 = ChatDeserializer.getAsJsonObject(var0, "hoverEvent"))) != null && var2.getAction().isAllowedFromServer()) {
                return var2;
            }
            return null;
        }

        @Nullable
        private static ChatClickable getClickEvent(JsonObject var0) {
            if (var0.has("clickEvent")) {
                JsonObject var1 = ChatDeserializer.getAsJsonObject(var0, "clickEvent");
                String var2 = ChatDeserializer.getAsString(var1, "action", null);
                ChatClickable.EnumClickAction var3 = var2 == null ? null : ChatClickable.EnumClickAction.getByName(var2);
                String var4 = ChatDeserializer.getAsString(var1, "value", null);
                if (var3 != null && var4 != null && var3.isAllowedFromServer()) {
                    return new ChatClickable(var3, var4);
                }
            }
            return null;
        }

        @Nullable
        private static String getInsertion(JsonObject var0) {
            return ChatDeserializer.getAsString(var0, "insertion", null);
        }

        @Nullable
        private static ChatHexColor getTextColor(JsonObject var0) {
            if (var0.has("color")) {
                String var1 = ChatDeserializer.getAsString(var0, "color");
                return ChatHexColor.parseColor(var1);
            }
            return null;
        }

        @Nullable
        private static Boolean getOptionalFlag(JsonObject var0, String var1) {
            if (var0.has(var1)) {
                return var0.get(var1).getAsBoolean();
            }
            return null;
        }

        @Nullable
        public JsonElement serialize(ChatModifier var0, Type var1, JsonSerializationContext var2) {
            if (var0.isEmpty()) {
                return null;
            }
            JsonObject var3 = new JsonObject();
            if (var0.bold != null) {
                var3.addProperty("bold", var0.bold);
            }
            if (var0.italic != null) {
                var3.addProperty("italic", var0.italic);
            }
            if (var0.underlined != null) {
                var3.addProperty("underlined", var0.underlined);
            }
            if (var0.strikethrough != null) {
                var3.addProperty("strikethrough", var0.strikethrough);
            }
            if (var0.obfuscated != null) {
                var3.addProperty("obfuscated", var0.obfuscated);
            }
            if (var0.color != null) {
                var3.addProperty("color", var0.color.serialize());
            }
            if (var0.insertion != null) {
                var3.add("insertion", var2.serialize((Object)var0.insertion));
            }
            if (var0.clickEvent != null) {
                JsonObject var4 = new JsonObject();
                var4.addProperty("action", var0.clickEvent.getAction().getName());
                var4.addProperty("value", var0.clickEvent.getValue());
                var3.add("clickEvent", (JsonElement)var4);
            }
            if (var0.hoverEvent != null) {
                var3.add("hoverEvent", (JsonElement)var0.hoverEvent.serialize());
            }
            if (var0.font != null) {
                var3.addProperty("font", var0.font.toString());
            }
            return var3;
        }

        @Nullable
        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ChatModifier)object, type, jsonSerializationContext);
        }

        @Nullable
        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

