/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;

public class ChatComponentUtils {
    public static final String DEFAULT_SEPARATOR_TEXT = ", ";
    public static final IChatBaseComponent DEFAULT_SEPARATOR = IChatBaseComponent.literal(", ").withStyle(EnumChatFormat.GRAY);
    public static final IChatBaseComponent DEFAULT_NO_STYLE_SEPARATOR = IChatBaseComponent.literal(", ");

    public static IChatMutableComponent mergeStyles(IChatMutableComponent var0, ChatModifier var1) {
        if (var1.isEmpty()) {
            return var0;
        }
        ChatModifier var2 = var0.getStyle();
        if (var2.isEmpty()) {
            return var0.setStyle(var1);
        }
        if (var2.equals(var1)) {
            return var0;
        }
        return var0.setStyle(var2.applyTo(var1));
    }

    public static Optional<IChatMutableComponent> updateForEntity(@Nullable CommandListenerWrapper var0, Optional<IChatBaseComponent> var1, @Nullable Entity var2, int var3) throws CommandSyntaxException {
        return var1.isPresent() ? Optional.of(ChatComponentUtils.updateForEntity(var0, var1.get(), var2, var3)) : Optional.empty();
    }

    public static IChatMutableComponent updateForEntity(@Nullable CommandListenerWrapper var0, IChatBaseComponent var1, @Nullable Entity var2, int var3) throws CommandSyntaxException {
        if (var3 > 100) {
            return var1.copy();
        }
        IChatMutableComponent var4 = var1.getContents().resolve(var0, var2, var3 + 1);
        for (IChatBaseComponent var6 : var1.getSiblings()) {
            var4.append(ChatComponentUtils.updateForEntity(var0, var6, var2, var3 + 1));
        }
        return var4.withStyle(ChatComponentUtils.resolveStyle(var0, var1.getStyle(), var2, var3));
    }

    private static ChatModifier resolveStyle(@Nullable CommandListenerWrapper var0, ChatModifier var1, @Nullable Entity var2, int var3) throws CommandSyntaxException {
        IChatBaseComponent var5;
        ChatHoverable var4 = var1.getHoverEvent();
        if (var4 != null && (var5 = var4.getValue(ChatHoverable.EnumHoverAction.SHOW_TEXT)) != null) {
            ChatHoverable var6 = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, ChatComponentUtils.updateForEntity(var0, var5, var2, var3 + 1));
            return var1.withHoverEvent(var6);
        }
        return var1;
    }

    public static IChatBaseComponent getDisplayName(GameProfile var0) {
        if (var0.getName() != null) {
            return IChatBaseComponent.literal(var0.getName());
        }
        if (var0.getId() != null) {
            return IChatBaseComponent.literal(var0.getId().toString());
        }
        return IChatBaseComponent.literal("(unknown)");
    }

    public static IChatBaseComponent formatList(Collection<String> var02) {
        return ChatComponentUtils.formatAndSortList(var02, var0 -> IChatBaseComponent.literal(var0).withStyle(EnumChatFormat.GREEN));
    }

    public static <T extends Comparable<T>> IChatBaseComponent formatAndSortList(Collection<T> var0, Function<T, IChatBaseComponent> var1) {
        if (var0.isEmpty()) {
            return CommonComponents.EMPTY;
        }
        if (var0.size() == 1) {
            return var1.apply((Comparable)var0.iterator().next());
        }
        ArrayList var2 = Lists.newArrayList(var0);
        var2.sort(Comparable::compareTo);
        return ChatComponentUtils.formatList(var2, var1);
    }

    public static <T> IChatBaseComponent formatList(Collection<? extends T> var0, Function<T, IChatBaseComponent> var1) {
        return ChatComponentUtils.formatList(var0, DEFAULT_SEPARATOR, var1);
    }

    public static <T> IChatMutableComponent formatList(Collection<? extends T> var0, Optional<? extends IChatBaseComponent> var1, Function<T, IChatBaseComponent> var2) {
        return ChatComponentUtils.formatList(var0, (IChatBaseComponent)DataFixUtils.orElse(var1, (Object)DEFAULT_SEPARATOR), var2);
    }

    public static IChatBaseComponent formatList(Collection<? extends IChatBaseComponent> var0, IChatBaseComponent var1) {
        return ChatComponentUtils.formatList(var0, var1, Function.identity());
    }

    public static <T> IChatMutableComponent formatList(Collection<? extends T> var0, IChatBaseComponent var1, Function<T, IChatBaseComponent> var2) {
        if (var0.isEmpty()) {
            return IChatBaseComponent.empty();
        }
        if (var0.size() == 1) {
            return var2.apply(var0.iterator().next()).copy();
        }
        IChatMutableComponent var3 = IChatBaseComponent.empty();
        boolean var4 = true;
        for (T var6 : var0) {
            if (!var4) {
                var3.append(var1);
            }
            var3.append(var2.apply(var6));
            var4 = false;
        }
        return var3;
    }

    public static IChatMutableComponent wrapInSquareBrackets(IChatBaseComponent var0) {
        return IChatBaseComponent.translatable("chat.square_brackets", var0);
    }

    public static IChatBaseComponent fromMessage(Message var0) {
        if (var0 instanceof IChatBaseComponent) {
            IChatBaseComponent var1 = (IChatBaseComponent)var0;
            return var1;
        }
        return IChatBaseComponent.literal(var0.getString());
    }

    public static boolean isTranslationResolvable(@Nullable IChatBaseComponent var0) {
        ComponentContents componentContents;
        if (var0 != null && (componentContents = var0.getContents()) instanceof TranslatableContents) {
            TranslatableContents var1 = (TranslatableContents)componentContents;
            String var2 = var1.getKey();
            String var3 = var1.getFallback();
            return var3 != null || LocaleLanguage.getInstance().has(var2);
        }
        return true;
    }

    public static IChatMutableComponent copyOnClickText(String var0) {
        return ChatComponentUtils.wrapInSquareBrackets(IChatBaseComponent.literal(var0).withStyle(var1 -> var1.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.COPY_TO_CLIPBOARD, var0)).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.translatable("chat.copy.click"))).withInsertion(var0)));
    }
}

