/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class ParticleParamBlock
implements ParticleParam {
    public static final ParticleParam.a<ParticleParamBlock> DESERIALIZER = new ParticleParam.a<ParticleParamBlock>(){

        @Override
        public ParticleParamBlock fromCommand(Particle<ParticleParamBlock> var0, StringReader var1) throws CommandSyntaxException {
            var1.expect(' ');
            return new ParticleParamBlock(var0, ArgumentBlock.parseForBlock(BuiltInRegistries.BLOCK.asLookup(), var1, false).blockState());
        }

        @Override
        public ParticleParamBlock fromNetwork(Particle<ParticleParamBlock> var0, PacketDataSerializer var1) {
            return new ParticleParamBlock(var0, var1.readById(Block.BLOCK_STATE_REGISTRY));
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };
    private final Particle<ParticleParamBlock> type;
    private final IBlockData state;

    public static Codec<ParticleParamBlock> codec(Particle<ParticleParamBlock> var02) {
        return IBlockData.CODEC.xmap(var1 -> new ParticleParamBlock(var02, (IBlockData)var1), var0 -> var0.state);
    }

    public ParticleParamBlock(Particle<ParticleParamBlock> var0, IBlockData var1) {
        this.type = var0;
        this.state = var1;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        var0.writeId(Block.BLOCK_STATE_REGISTRY, this.state);
    }

    @Override
    public String writeToString() {
        return BuiltInRegistries.PARTICLE_TYPE.getKey(this.getType()) + " " + ArgumentBlock.serialize(this.state);
    }

    public Particle<ParticleParamBlock> getType() {
        return this.type;
    }

    public IBlockData getState() {
        return this.state;
    }
}

