/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockDispenser;

public class DispenseBehaviorBoat
extends DispenseBehaviorItem {
    private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();
    private final EntityBoat.EnumBoatType type;
    private final boolean isChestBoat;

    public DispenseBehaviorBoat(EntityBoat.EnumBoatType var0) {
        this(var0, false);
    }

    public DispenseBehaviorBoat(EntityBoat.EnumBoatType var0, boolean var1) {
        this.type = var0;
        this.isChestBoat = var1;
    }

    @Override
    public ItemStack execute(ISourceBlock var0, ItemStack var1) {
        double var11;
        EnumDirection var2 = var0.getBlockState().getValue(BlockDispenser.FACING);
        WorldServer var3 = var0.getLevel();
        double var4 = var0.x() + (double)((float)var2.getStepX() * 1.125f);
        double var6 = var0.y() + (double)((float)var2.getStepY() * 1.125f);
        double var8 = var0.z() + (double)((float)var2.getStepZ() * 1.125f);
        BlockPosition var10 = var0.getPos().relative(var2);
        if (var3.getFluidState(var10).is(TagsFluid.WATER)) {
            var11 = 1.0;
        } else if (var3.getBlockState(var10).isAir() && var3.getFluidState(var10.below()).is(TagsFluid.WATER)) {
            var11 = 0.0;
        } else {
            return this.defaultDispenseItemBehavior.dispense(var0, var1);
        }
        EntityBoat var13 = this.isChestBoat ? new ChestBoat(var3, var4, var6 + var11, var8) : new EntityBoat(var3, var4, var6 + var11, var8);
        var13.setVariant(this.type);
        var13.setYRot(var2.toYRot());
        var3.addFreshEntity(var13);
        var1.shrink(1);
        return var1;
    }

    @Override
    protected void playSound(ISourceBlock var0) {
        var0.getLevel().levelEvent(1000, var0.getPos(), 0);
    }
}

