/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class RegistrySetBuilder {
    private final List<g<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.c<T> var0) {
        return new c<T>(var0){

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                return var0.get(var02);
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, e<T> var2) {
        this.entries.add(new g<T>(var0, var1, var2));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends IRegistry<T>> var0, e<T> var1) {
        return this.add(var0, Lifecycle.stable(), var1);
    }

    private a createState(IRegistryCustom var0) {
        a var12 = a.create(var0, this.entries.stream().map(g::key));
        this.entries.forEach(var1 -> var1.apply(var12));
        return var12;
    }

    public HolderLookup.b build(IRegistryCustom var02) {
        a var12 = this.createState(var02);
        Stream<HolderLookup.c> var2 = var02.registries().map(var0 -> var0.value().asLookup());
        Stream<HolderLookup.c> var3 = this.entries.stream().map(var1 -> var1.collectChanges(var12).buildAsLookup());
        HolderLookup.b var4 = HolderLookup.b.create(Stream.concat(var2, var3.peek(var12::addOwner)));
        var12.reportRemainingUnreferencedValues();
        var12.throwOnError();
        return var4;
    }

    public HolderLookup.b buildPatch(IRegistryCustom var02, HolderLookup.b var12) {
        a var2 = this.createState(var02);
        HashMap var3 = new HashMap();
        var2.collectReferencedRegistries().forEach(var1 -> var3.put(var1.key, var1));
        this.entries.stream().map(var1 -> var1.collectChanges(var2)).forEach(var1 -> var3.put(var1.key, var1));
        Stream<HolderLookup.c> var4 = var02.registries().map(var0 -> var0.value().asLookup());
        HolderLookup.b var5 = HolderLookup.b.create(Stream.concat(var4, var3.values().stream().map(f::buildAsLookup).peek(var2::addOwner)));
        var2.fillMissingHolders(var12);
        var2.reportRemainingUnreferencedValues();
        var2.throwOnError();
        return var5;
    }

    record g<T>(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, e<T> bootstrap) {
        void apply(a var0) {
            this.bootstrap.run(var0.bootstapContext());
        }

        public f<T> collectChanges(a var0) {
            HashMap var1 = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, d<?>>> var2 = var0.registeredValues.entrySet().iterator();
            while (var2.hasNext()) {
                Map.Entry<ResourceKey<?>, d<?>> var3 = var2.next();
                ResourceKey<?> var4 = var3.getKey();
                if (!var4.isFor(this.key)) continue;
                ResourceKey<?> var5 = var4;
                d<?> var6 = var3.getValue();
                Holder.c<Object> var7 = var0.lookup.holders.remove(var4);
                var1.put(var5, new i(var6, Optional.ofNullable(var7)));
                var2.remove();
            }
            return new f(this.key, this.lifecycle, var1);
        }
    }

    @FunctionalInterface
    public static interface e<T> {
        public void run(BootstapContext<T> var1);
    }

    static final class a
    extends Record {
        private final b owner;
        final h lookup;
        final Map<MinecraftKey, HolderGetter<?>> registries;
        final Map<ResourceKey<?>, d<?>> registeredValues;
        final List<RuntimeException> errors;

        private a(b var0, h var1, Map<MinecraftKey, HolderGetter<?>> var2, Map<ResourceKey<?>, d<?>> var3, List<RuntimeException> var4) {
            this.owner = var0;
            this.lookup = var1;
            this.registries = var2;
            this.registeredValues = var3;
            this.errors = var4;
        }

        public static a create(IRegistryCustom var0, Stream<ResourceKey<? extends IRegistry<?>>> var12) {
            b var22 = new b();
            ArrayList<RuntimeException> var3 = new ArrayList<RuntimeException>();
            h var4 = new h(var22);
            ImmutableMap.Builder var5 = ImmutableMap.builder();
            var0.registries().forEach(var1 -> var5.put((Object)var1.key().location(), RegistrySetBuilder.wrapContextLookup(var1.value().asLookup())));
            var12.forEach(var2 -> var5.put((Object)var2.location(), (Object)var4));
            return new a(var22, var4, (Map<MinecraftKey, HolderGetter<?>>)var5.build(), new HashMap(), (List<RuntimeException>)var3);
        }

        public <T> BootstapContext<T> bootstapContext() {
            return new BootstapContext<T>(){

                @Override
                public Holder.c<T> register(ResourceKey<T> var0, T var1, Lifecycle var2) {
                    d var3 = registeredValues.put(var0, new d(var1, var2));
                    if (var3 != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + var0 + ", new=" + var1 + ", old=" + var3.value));
                    }
                    return lookup.getOrCreate(var0);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends IRegistry<? extends S>> var0) {
                    return registries.getOrDefault(var0.location(), lookup);
                }
            };
        }

        public void reportRemainingUnreferencedValues() {
            for (ResourceKey<Object> var12 : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + var12));
            }
            this.registeredValues.forEach((var0, var1) -> this.errors.add(new IllegalStateException("Orpaned value " + var1.value + " for key " + var0)));
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException var0 = new IllegalStateException("Errors during registry creation");
                for (RuntimeException var2 : this.errors) {
                    var0.addSuppressed(var2);
                }
                throw var0;
            }
        }

        public void addOwner(HolderOwner<?> var0) {
            this.owner.add(var0);
        }

        public void fillMissingHolders(HolderLookup.b var0) {
            HashMap<MinecraftKey, Optional> var12 = new HashMap<MinecraftKey, Optional>();
            Iterator<Map.Entry<ResourceKey<Object>, Holder.c<Object>>> var22 = this.lookup.holders.entrySet().iterator();
            while (var22.hasNext()) {
                Map.Entry<ResourceKey<Object>, Holder.c<Object>> var3 = var22.next();
                ResourceKey<Object> var4 = var3.getKey();
                Holder.c<Object> var5 = var3.getValue();
                var12.computeIfAbsent(var4.registry(), var1 -> var0.lookup(ResourceKey.createRegistryKey(var1))).flatMap(var1 -> var1.get(var4)).ifPresent(var2 -> {
                    var5.bindValue(var2.value());
                    var22.remove();
                });
            }
        }

        public Stream<f<?>> collectReferencedRegistries() {
            return this.lookup.holders.keySet().stream().map(ResourceKey::registry).distinct().map(var0 -> new f(ResourceKey.createRegistryKey(var0), Lifecycle.stable(), Map.of()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this, var0);
        }

        public b owner() {
            return this.owner;
        }

        public h lookup() {
            return this.lookup;
        }

        public Map<MinecraftKey, HolderGetter<?>> registries() {
            return this.registries;
        }

        public Map<ResourceKey<?>, d<?>> registeredValues() {
            return this.registeredValues;
        }

        public List<RuntimeException> errors() {
            return this.errors;
        }
    }

    static final class f<T>
    extends Record {
        final ResourceKey<? extends IRegistry<? extends T>> key;
        final Lifecycle lifecycle;
        final Map<ResourceKey<T>, i<T>> values;

        f(ResourceKey<? extends IRegistry<? extends T>> var0, Lifecycle var1, Map<ResourceKey<T>, i<T>> var2) {
            this.key = var0;
            this.lifecycle = var1;
            this.values = var2;
        }

        public HolderLookup.c<T> buildAsLookup() {
            return new HolderLookup.c<T>(){
                private final Map<ResourceKey<T>, Holder.c<T>> entries;
                {
                    this.entries = values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, var0 -> {
                        i var1 = (i)var0.getValue();
                        Holder.c var2 = var1.holder().orElseGet(() -> Holder.c.createStandAlone(this, (ResourceKey)var0.getKey()));
                        var2.bindValue(var1.value().value());
                        return var2;
                    }));
                }

                @Override
                public ResourceKey<? extends IRegistry<? extends T>> key() {
                    return key;
                }

                @Override
                public Lifecycle registryLifecycle() {
                    return lifecycle;
                }

                @Override
                public Optional<Holder.c<T>> get(ResourceKey<T> var0) {
                    return Optional.ofNullable(this.entries.get(var0));
                }

                @Override
                public Stream<Holder.c<T>> listElements() {
                    return this.entries.values().stream();
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                    return Optional.empty();
                }

                @Override
                public Stream<HolderSet.Named<T>> listTags() {
                    return Stream.empty();
                }
            };
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<? extends T>> key() {
            return this.key;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }

        public Map<ResourceKey<T>, i<T>> values() {
            return this.values;
        }
    }

    record i<T>(d<T> value, Optional<Holder.c<T>> holder) {
    }

    static final class d<T>
    extends Record {
        final T value;
        private final Lifecycle lifecycle;

        d(T var0, Lifecycle var1) {
            this.value = var0;
            this.lifecycle = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "value;lifecycle", "value", "lifecycle"}, this, var0);
        }

        public T value() {
            return this.value;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }
    }

    static class h
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> holders = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public h(HolderOwner<Object> var0) {
            super(var0);
        }

        @Override
        public Optional<Holder.c<Object>> get(ResourceKey<Object> var0) {
            return Optional.of(this.getOrCreate(var0));
        }

        <T> Holder.c<T> getOrCreate(ResourceKey<T> var02) {
            return this.holders.computeIfAbsent(var02, var0 -> Holder.c.createStandAlone(this.owner, var0));
        }
    }

    static class b
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> owners = Sets.newIdentityHashSet();

        b() {
        }

        @Override
        public boolean canSerializeIn(HolderOwner<Object> var0) {
            return this.owners.contains(var0);
        }

        public void add(HolderOwner<?> var0) {
            this.owners.add(var0);
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected c(HolderOwner<T> var0) {
            this.owner = var0;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
            return Optional.of(HolderSet.emptyNamed(this.owner, var0));
        }
    }
}

