/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionRange;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeamBase;

public class PlayerSelector {
    private static final Map<String, b> OPTIONS = Maps.newHashMap();
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.entity.options.unknown", var0));
    public static final DynamicCommandExceptionType ERROR_INAPPLICABLE_OPTION = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.entity.options.inapplicable", var0));
    public static final SimpleCommandExceptionType ERROR_RANGE_NEGATIVE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType ERROR_LEVEL_NEGATIVE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType ERROR_LIMIT_TOO_SMALL = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType ERROR_SORT_UNKNOWN = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.entity.options.sort.irreversible", var0));
    public static final DynamicCommandExceptionType ERROR_GAME_MODE_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.entity.options.mode.invalid", var0));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TYPE_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.entity.options.type.invalid", var0));

    private static void register(String var0, a var1, Predicate<ArgumentParserSelector> var2, IChatBaseComponent var3) {
        OPTIONS.put(var0, new b(var1, var2, var3));
    }

    public static void bootStrap() {
        if (!OPTIONS.isEmpty()) {
            return;
        }
        PlayerSelector.register("name", var0 -> {
            int var1 = var0.getReader().getCursor();
            boolean var22 = var0.shouldInvertValue();
            String var3 = var0.getReader().readString();
            if (var0.hasNameNotEquals() && !var22) {
                var0.getReader().setCursor(var1);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)"name");
            }
            if (var22) {
                var0.setHasNameNotEquals(true);
            } else {
                var0.setHasNameEquals(true);
            }
            var0.addPredicate(var2 -> var2.getName().getString().equals(var3) != var22);
        }, var0 -> !var0.hasNameEquals(), IChatBaseComponent.translatable("argument.entity.options.name.description"));
        PlayerSelector.register("distance", var0 -> {
            int var1 = var0.getReader().getCursor();
            CriterionConditionValue.DoubleRange var2 = CriterionConditionValue.DoubleRange.fromReader(var0.getReader());
            if (var2.getMin() != null && (Double)var2.getMin() < 0.0 || var2.getMax() != null && (Double)var2.getMax() < 0.0) {
                var0.getReader().setCursor(var1);
                throw ERROR_RANGE_NEGATIVE.createWithContext((ImmutableStringReader)var0.getReader());
            }
            var0.setDistance(var2);
            var0.setWorldLimited();
        }, var0 -> var0.getDistance().isAny(), IChatBaseComponent.translatable("argument.entity.options.distance.description"));
        PlayerSelector.register("level", var0 -> {
            int var1 = var0.getReader().getCursor();
            CriterionConditionValue.IntegerRange var2 = CriterionConditionValue.IntegerRange.fromReader(var0.getReader());
            if (var2.getMin() != null && (Integer)var2.getMin() < 0 || var2.getMax() != null && (Integer)var2.getMax() < 0) {
                var0.getReader().setCursor(var1);
                throw ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)var0.getReader());
            }
            var0.setLevel(var2);
            var0.setIncludesEntities(false);
        }, var0 -> var0.getLevel().isAny(), IChatBaseComponent.translatable("argument.entity.options.level.description"));
        PlayerSelector.register("x", var0 -> {
            var0.setWorldLimited();
            var0.setX(var0.getReader().readDouble());
        }, var0 -> var0.getX() == null, IChatBaseComponent.translatable("argument.entity.options.x.description"));
        PlayerSelector.register("y", var0 -> {
            var0.setWorldLimited();
            var0.setY(var0.getReader().readDouble());
        }, var0 -> var0.getY() == null, IChatBaseComponent.translatable("argument.entity.options.y.description"));
        PlayerSelector.register("z", var0 -> {
            var0.setWorldLimited();
            var0.setZ(var0.getReader().readDouble());
        }, var0 -> var0.getZ() == null, IChatBaseComponent.translatable("argument.entity.options.z.description"));
        PlayerSelector.register("dx", var0 -> {
            var0.setWorldLimited();
            var0.setDeltaX(var0.getReader().readDouble());
        }, var0 -> var0.getDeltaX() == null, IChatBaseComponent.translatable("argument.entity.options.dx.description"));
        PlayerSelector.register("dy", var0 -> {
            var0.setWorldLimited();
            var0.setDeltaY(var0.getReader().readDouble());
        }, var0 -> var0.getDeltaY() == null, IChatBaseComponent.translatable("argument.entity.options.dy.description"));
        PlayerSelector.register("dz", var0 -> {
            var0.setWorldLimited();
            var0.setDeltaZ(var0.getReader().readDouble());
        }, var0 -> var0.getDeltaZ() == null, IChatBaseComponent.translatable("argument.entity.options.dz.description"));
        PlayerSelector.register("x_rotation", var0 -> var0.setRotX(CriterionConditionRange.fromReader(var0.getReader(), true, MathHelper::wrapDegrees)), var0 -> var0.getRotX() == CriterionConditionRange.ANY, IChatBaseComponent.translatable("argument.entity.options.x_rotation.description"));
        PlayerSelector.register("y_rotation", var0 -> var0.setRotY(CriterionConditionRange.fromReader(var0.getReader(), true, MathHelper::wrapDegrees)), var0 -> var0.getRotY() == CriterionConditionRange.ANY, IChatBaseComponent.translatable("argument.entity.options.y_rotation.description"));
        PlayerSelector.register("limit", var0 -> {
            int var1 = var0.getReader().getCursor();
            int var2 = var0.getReader().readInt();
            if (var2 < 1) {
                var0.getReader().setCursor(var1);
                throw ERROR_LIMIT_TOO_SMALL.createWithContext((ImmutableStringReader)var0.getReader());
            }
            var0.setMaxResults(var2);
            var0.setLimited(true);
        }, var0 -> !var0.isCurrentEntity() && !var0.isLimited(), IChatBaseComponent.translatable("argument.entity.options.limit.description"));
        PlayerSelector.register("sort", var02 -> {
            int var12 = var02.getReader().getCursor();
            String var2 = var02.getReader().readUnquotedString();
            var02.setSuggestions((var0, var1) -> ICompletionProvider.suggest(Arrays.asList("nearest", "furthest", "random", "arbitrary"), var0));
            var02.setOrder(switch (var2) {
                case "nearest" -> ArgumentParserSelector.ORDER_NEAREST;
                case "furthest" -> ArgumentParserSelector.ORDER_FURTHEST;
                case "random" -> ArgumentParserSelector.ORDER_RANDOM;
                case "arbitrary" -> EntitySelector.ORDER_ARBITRARY;
                default -> {
                    var02.getReader().setCursor(var12);
                    throw ERROR_SORT_UNKNOWN.createWithContext((ImmutableStringReader)var02.getReader(), (Object)var2);
                }
            });
            var02.setSorted(true);
        }, var0 -> !var0.isCurrentEntity() && !var0.isSorted(), IChatBaseComponent.translatable("argument.entity.options.sort.description"));
        PlayerSelector.register("gamemode", var0 -> {
            var0.setSuggestions((var1, var2) -> {
                String var3 = var1.getRemaining().toLowerCase(Locale.ROOT);
                boolean var4 = !var0.hasGamemodeNotEquals();
                boolean var5 = true;
                if (!var3.isEmpty()) {
                    if (var3.charAt(0) == '!') {
                        var4 = false;
                        var3 = var3.substring(1);
                    } else {
                        var5 = false;
                    }
                }
                for (EnumGamemode var9 : EnumGamemode.values()) {
                    if (!var9.getName().toLowerCase(Locale.ROOT).startsWith(var3)) continue;
                    if (var5) {
                        var1.suggest("!" + var9.getName());
                    }
                    if (!var4) continue;
                    var1.suggest(var9.getName());
                }
                return var1.buildFuture();
            });
            int var12 = var0.getReader().getCursor();
            boolean var22 = var0.shouldInvertValue();
            if (var0.hasGamemodeNotEquals() && !var22) {
                var0.getReader().setCursor(var12);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)"gamemode");
            }
            String var3 = var0.getReader().readUnquotedString();
            EnumGamemode var4 = EnumGamemode.byName(var3, null);
            if (var4 == null) {
                var0.getReader().setCursor(var12);
                throw ERROR_GAME_MODE_INVALID.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var3);
            }
            var0.setIncludesEntities(false);
            var0.addPredicate(var2 -> {
                if (!(var2 instanceof EntityPlayer)) {
                    return false;
                }
                EnumGamemode var3 = ((EntityPlayer)var2).gameMode.getGameModeForPlayer();
                return var22 ? var3 != var4 : var3 == var4;
            });
            if (var22) {
                var0.setHasGamemodeNotEquals(true);
            } else {
                var0.setHasGamemodeEquals(true);
            }
        }, var0 -> !var0.hasGamemodeEquals(), IChatBaseComponent.translatable("argument.entity.options.gamemode.description"));
        PlayerSelector.register("team", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            String var22 = var0.getReader().readUnquotedString();
            var0.addPredicate(var2 -> {
                if (!(var2 instanceof EntityLiving)) {
                    return false;
                }
                ScoreboardTeamBase var3 = var2.getTeam();
                String var4 = var3 == null ? "" : var3.getName();
                return var4.equals(var22) != var1;
            });
            if (var1) {
                var0.setHasTeamNotEquals(true);
            } else {
                var0.setHasTeamEquals(true);
            }
        }, var0 -> !var0.hasTeamEquals(), IChatBaseComponent.translatable("argument.entity.options.team.description"));
        PlayerSelector.register("type", var0 -> {
            var0.setSuggestions((var1, var2) -> {
                ICompletionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), var1, String.valueOf('!'));
                ICompletionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTagNames().map(TagKey::location), var1, "!#");
                if (!var0.isTypeLimitedInversely()) {
                    ICompletionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), var1);
                    ICompletionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTagNames().map(TagKey::location), var1, String.valueOf('#'));
                }
                return var1.buildFuture();
            });
            int var12 = var0.getReader().getCursor();
            boolean var22 = var0.shouldInvertValue();
            if (var0.isTypeLimitedInversely() && !var22) {
                var0.getReader().setCursor(var12);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)"type");
            }
            if (var22) {
                var0.setTypeLimitedInversely();
            }
            if (var0.isTag()) {
                TagKey<EntityTypes<?>> var3 = TagKey.create(Registries.ENTITY_TYPE, MinecraftKey.read(var0.getReader()));
                var0.addPredicate(var2 -> var2.getType().is(var3) != var22);
            } else {
                MinecraftKey var3 = MinecraftKey.read(var0.getReader());
                EntityTypes var4 = (EntityTypes)BuiltInRegistries.ENTITY_TYPE.getOptional(var3).orElseThrow(() -> {
                    var0.getReader().setCursor(var12);
                    return ERROR_ENTITY_TYPE_INVALID.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var3.toString());
                });
                if (Objects.equals(EntityTypes.PLAYER, var4) && !var22) {
                    var0.setIncludesEntities(false);
                }
                var0.addPredicate(var2 -> Objects.equals(var4, var2.getType()) != var22);
                if (!var22) {
                    var0.limitToType(var4);
                }
            }
        }, var0 -> !var0.isTypeLimited(), IChatBaseComponent.translatable("argument.entity.options.type.description"));
        PlayerSelector.register("tag", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            String var22 = var0.getReader().readUnquotedString();
            var0.addPredicate(var2 -> {
                if ("".equals(var22)) {
                    return var2.getTags().isEmpty() != var1;
                }
                return var2.getTags().contains(var22) != var1;
            });
        }, var0 -> true, IChatBaseComponent.translatable("argument.entity.options.tag.description"));
        PlayerSelector.register("nbt", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            NBTTagCompound var22 = new MojangsonParser(var0.getReader()).readStruct();
            var0.addPredicate(var2 -> {
                ItemStack var4;
                NBTTagCompound var3 = var2.saveWithoutId(new NBTTagCompound());
                if (var2 instanceof EntityPlayer && !(var4 = ((EntityPlayer)var2).getInventory().getSelected()).isEmpty()) {
                    var3.put("SelectedItem", var4.save(new NBTTagCompound()));
                }
                return GameProfileSerializer.compareNbt(var22, var3, true) != var1;
            });
        }, var0 -> true, IChatBaseComponent.translatable("argument.entity.options.nbt.description"));
        PlayerSelector.register("scores", var0 -> {
            StringReader var12 = var0.getReader();
            HashMap var2 = Maps.newHashMap();
            var12.expect('{');
            var12.skipWhitespace();
            while (var12.canRead() && var12.peek() != '}') {
                var12.skipWhitespace();
                String var3 = var12.readUnquotedString();
                var12.skipWhitespace();
                var12.expect('=');
                var12.skipWhitespace();
                CriterionConditionValue.IntegerRange var4 = CriterionConditionValue.IntegerRange.fromReader(var12);
                var2.put(var3, var4);
                var12.skipWhitespace();
                if (!var12.canRead() || var12.peek() != ',') continue;
                var12.skip();
            }
            var12.expect('}');
            if (!var2.isEmpty()) {
                var0.addPredicate(var1 -> {
                    ScoreboardServer var2 = var1.getServer().getScoreboard();
                    String var3 = var1.getScoreboardName();
                    for (Map.Entry var5 : var2.entrySet()) {
                        ScoreboardObjective var6 = var2.getObjective((String)var5.getKey());
                        if (var6 == null) {
                            return false;
                        }
                        if (!var2.hasPlayerScore(var3, var6)) {
                            return false;
                        }
                        ScoreboardScore var7 = var2.getOrCreatePlayerScore(var3, var6);
                        int var8 = var7.getScore();
                        if (((CriterionConditionValue.IntegerRange)var5.getValue()).matches(var8)) continue;
                        return false;
                    }
                    return true;
                });
            }
            var0.setHasScores(true);
        }, var0 -> !var0.hasScores(), IChatBaseComponent.translatable("argument.entity.options.scores.description"));
        PlayerSelector.register("advancements", var0 -> {
            StringReader var12 = var0.getReader();
            HashMap var2 = Maps.newHashMap();
            var12.expect('{');
            var12.skipWhitespace();
            while (var12.canRead() && var12.peek() != '}') {
                var12.skipWhitespace();
                MinecraftKey var3 = MinecraftKey.read(var12);
                var12.skipWhitespace();
                var12.expect('=');
                var12.skipWhitespace();
                if (var12.canRead() && var12.peek() == '{') {
                    HashMap var4 = Maps.newHashMap();
                    var12.skipWhitespace();
                    var12.expect('{');
                    var12.skipWhitespace();
                    while (var12.canRead() && var12.peek() != '}') {
                        var12.skipWhitespace();
                        String var5 = var12.readUnquotedString();
                        var12.skipWhitespace();
                        var12.expect('=');
                        var12.skipWhitespace();
                        boolean var6 = var12.readBoolean();
                        var4.put(var5, var1 -> var1.isDone() == var6);
                        var12.skipWhitespace();
                        if (!var12.canRead() || var12.peek() != ',') continue;
                        var12.skip();
                    }
                    var12.skipWhitespace();
                    var12.expect('}');
                    var12.skipWhitespace();
                    var2.put(var3, var1 -> {
                        for (Map.Entry var3 : var4.entrySet()) {
                            CriterionProgress var4 = var1.getCriterion((String)var3.getKey());
                            if (var4 != null && ((Predicate)var3.getValue()).test(var4)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean var4 = var12.readBoolean();
                    var2.put(var3, var1 -> var1.isDone() == var4);
                }
                var12.skipWhitespace();
                if (!var12.canRead() || var12.peek() != ',') continue;
                var12.skip();
            }
            var12.expect('}');
            if (!var2.isEmpty()) {
                var0.addPredicate(var1 -> {
                    if (!(var1 instanceof EntityPlayer)) {
                        return false;
                    }
                    EntityPlayer var2 = (EntityPlayer)var1;
                    AdvancementDataPlayer var3 = var2.getAdvancements();
                    AdvancementDataWorld var4 = var2.getServer().getAdvancements();
                    for (Map.Entry var6 : var2.entrySet()) {
                        Advancement var7 = var4.getAdvancement((MinecraftKey)var6.getKey());
                        if (var7 != null && ((Predicate)var6.getValue()).test(var3.getOrStartProgress(var7))) continue;
                        return false;
                    }
                    return true;
                });
                var0.setIncludesEntities(false);
            }
            var0.setHasAdvancements(true);
        }, var0 -> !var0.hasAdvancements(), IChatBaseComponent.translatable("argument.entity.options.advancements.description"));
        PlayerSelector.register("predicate", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            MinecraftKey var22 = MinecraftKey.read(var0.getReader());
            var0.addPredicate(var2 -> {
                if (!(var2.level instanceof WorldServer)) {
                    return false;
                }
                WorldServer var3 = (WorldServer)var2.level;
                LootItemCondition var4 = var3.getServer().getPredicateManager().get(var22);
                if (var4 == null) {
                    return false;
                }
                LootTableInfo var5 = new LootTableInfo.Builder(var3).withParameter(LootContextParameters.THIS_ENTITY, var2).withParameter(LootContextParameters.ORIGIN, var2.position()).create(LootContextParameterSets.SELECTOR);
                return var1 ^ var4.test(var5);
            });
        }, var0 -> true, IChatBaseComponent.translatable("argument.entity.options.predicate.description"));
    }

    public static a get(ArgumentParserSelector var0, String var1, int var2) throws CommandSyntaxException {
        b var3 = OPTIONS.get(var1);
        if (var3 != null) {
            if (var3.canUse.test(var0)) {
                return var3.modifier;
            }
            throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var1);
        }
        var0.getReader().setCursor(var2);
        throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var1);
    }

    public static void suggestNames(ArgumentParserSelector var0, SuggestionsBuilder var1) {
        String var2 = var1.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, b> var4 : OPTIONS.entrySet()) {
            if (!var4.getValue().canUse.test(var0) || !var4.getKey().toLowerCase(Locale.ROOT).startsWith(var2)) continue;
            var1.suggest(var4.getKey() + "=", (Message)var4.getValue().description);
        }
    }

    static final class b
    extends Record {
        final a modifier;
        final Predicate<ArgumentParserSelector> canUse;
        final IChatBaseComponent description;

        b(a var0, Predicate<ArgumentParserSelector> var1, IChatBaseComponent var2) {
            this.modifier = var0;
            this.canUse = var1;
            this.description = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "modifier;canUse;description", "modifier", "canUse", "description"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "modifier;canUse;description", "modifier", "canUse", "description"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "modifier;canUse;description", "modifier", "canUse", "description"}, this, var0);
        }

        public a modifier() {
            return this.modifier;
        }

        public Predicate<ArgumentParserSelector> canUse() {
            return this.canUse;
        }

        public IChatBaseComponent description() {
            return this.description;
        }
    }

    public static interface a {
        public void handle(ArgumentParserSelector var1) throws CommandSyntaxException;
    }
}

