/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.item.ArgumentParserItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;

public class ArgumentItemStack
implements ArgumentType<ArgumentPredicateItemStack> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "stick{foo=bar}");
    private final HolderLookup<Item> items;

    public ArgumentItemStack(CommandBuildContext var0) {
        this.items = var0.holderLookup(Registries.ITEM);
    }

    public static ArgumentItemStack item(CommandBuildContext var0) {
        return new ArgumentItemStack(var0);
    }

    public ArgumentPredicateItemStack parse(StringReader var0) throws CommandSyntaxException {
        ArgumentParserItemStack.a var1 = ArgumentParserItemStack.parseForItem(this.items, var0);
        return new ArgumentPredicateItemStack(var1.item(), var1.nbt());
    }

    public static <S> ArgumentPredicateItemStack getItem(CommandContext<S> var0, String var1) {
        return (ArgumentPredicateItemStack)var0.getArgument(var1, ArgumentPredicateItemStack.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ArgumentParserItemStack.fillSuggestions(this.items, var1, false);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

