/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ChatDeserializer;

public abstract class CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.range.swapped"));
    @Nullable
    protected final T min;
    @Nullable
    protected final T max;

    protected CriterionConditionValue(@Nullable T var0, @Nullable T var1) {
        this.min = var0;
        this.max = var1;
    }

    @Nullable
    public T getMin() {
        return this.min;
    }

    @Nullable
    public T getMax() {
        return this.max;
    }

    public boolean isAny() {
        return this.min == null && this.max == null;
    }

    public JsonElement serializeToJson() {
        if (this.isAny()) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.min.equals(this.max)) {
            return new JsonPrimitive(this.min);
        }
        JsonObject var0 = new JsonObject();
        if (this.min != null) {
            var0.addProperty("min", this.min);
        }
        if (this.max != null) {
            var0.addProperty("max", this.max);
        }
        return var0;
    }

    protected static <T extends Number, R extends CriterionConditionValue<T>> R fromJson(@Nullable JsonElement var0, R var1, BiFunction<JsonElement, String, T> var2, a<T, R> var3) {
        if (var0 == null || var0.isJsonNull()) {
            return var1;
        }
        if (ChatDeserializer.isNumberValue(var0)) {
            Number var4 = (Number)var2.apply(var0, "value");
            return var3.create(var4, var4);
        }
        JsonObject var4 = ChatDeserializer.convertToJsonObject(var0, "value");
        Number var5 = var4.has("min") ? (Number)((Number)var2.apply(var4.get("min"), "min")) : (Number)null;
        Number var6 = var4.has("max") ? (Number)((Number)var2.apply(var4.get("max"), "max")) : (Number)null;
        return var3.create(var5, var6);
    }

    protected static <T extends Number, R extends CriterionConditionValue<T>> R fromReader(StringReader var0, b<T, R> var1, Function<String, T> var2, Supplier<DynamicCommandExceptionType> var3, Function<T, T> var4) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
        }
        int var5 = var0.getCursor();
        try {
            Number var7;
            Number var6 = (Number)CriterionConditionValue.optionallyFormat(CriterionConditionValue.readNumber(var0, var2, var3), var4);
            if (var0.canRead(2) && var0.peek() == '.' && var0.peek(1) == '.') {
                var0.skip();
                var0.skip();
                var7 = (Number)CriterionConditionValue.optionallyFormat(CriterionConditionValue.readNumber(var0, var2, var3), var4);
                if (var6 == null && var7 == null) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
                }
            } else {
                var7 = var6;
            }
            if (var6 == null && var7 == null) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
            }
            return var1.create(var0, var6, var7);
        }
        catch (CommandSyntaxException var6) {
            var0.setCursor(var5);
            throw new CommandSyntaxException(var6.getType(), var6.getRawMessage(), var6.getInput(), var5);
        }
    }

    @Nullable
    private static <T extends Number> T readNumber(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
        int var3 = var0.getCursor();
        while (var0.canRead() && CriterionConditionValue.isAllowedInputChat(var0)) {
            var0.skip();
        }
        String var4 = var0.getString().substring(var3, var0.getCursor());
        if (var4.isEmpty()) {
            return null;
        }
        try {
            return (T)((Number)var1.apply(var4));
        }
        catch (NumberFormatException var5) {
            throw var2.get().createWithContext((ImmutableStringReader)var0, (Object)var4);
        }
    }

    private static boolean isAllowedInputChat(StringReader var0) {
        char var1 = var0.peek();
        if (var1 >= '0' && var1 <= '9' || var1 == '-') {
            return true;
        }
        if (var1 == '.') {
            return !var0.canRead(2) || var0.peek(1) != '.';
        }
        return false;
    }

    @Nullable
    private static <T> T optionallyFormat(@Nullable T var0, Function<T, T> var1) {
        return var0 == null ? null : (T)var1.apply(var0);
    }

    @FunctionalInterface
    protected static interface a<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(@Nullable T var1, @Nullable T var2);
    }

    @FunctionalInterface
    protected static interface b<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(StringReader var1, @Nullable T var2, @Nullable T var3) throws CommandSyntaxException;
    }

    public static class DoubleRange
    extends CriterionConditionValue<Double> {
        public static final DoubleRange ANY = new DoubleRange(null, null);
        @Nullable
        private final Double minSq;
        @Nullable
        private final Double maxSq;

        private static DoubleRange create(StringReader var0, @Nullable Double var1, @Nullable Double var2) throws CommandSyntaxException {
            if (var1 != null && var2 != null && var1 > var2) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new DoubleRange(var1, var2);
        }

        @Nullable
        private static Double squareOpt(@Nullable Double var0) {
            return var0 == null ? null : Double.valueOf(var0 * var0);
        }

        private DoubleRange(@Nullable Double var0, @Nullable Double var1) {
            super(var0, var1);
            this.minSq = DoubleRange.squareOpt(var0);
            this.maxSq = DoubleRange.squareOpt(var1);
        }

        public static DoubleRange exactly(double var0) {
            return new DoubleRange(var0, var0);
        }

        public static DoubleRange between(double var0, double var2) {
            return new DoubleRange(var0, var2);
        }

        public static DoubleRange atLeast(double var0) {
            return new DoubleRange(var0, null);
        }

        public static DoubleRange atMost(double var0) {
            return new DoubleRange(null, var0);
        }

        public boolean matches(double var0) {
            if (this.min != null && (Double)this.min > var0) {
                return false;
            }
            return this.max == null || !((Double)this.max < var0);
        }

        public boolean matchesSqr(double var0) {
            if (this.minSq != null && this.minSq > var0) {
                return false;
            }
            return this.maxSq == null || !(this.maxSq < var0);
        }

        public static DoubleRange fromJson(@Nullable JsonElement var0) {
            return DoubleRange.fromJson(var0, ANY, ChatDeserializer::convertToDouble, DoubleRange::new);
        }

        public static DoubleRange fromReader(StringReader var02) throws CommandSyntaxException {
            return DoubleRange.fromReader(var02, var0 -> var0);
        }

        public static DoubleRange fromReader(StringReader var0, Function<Double, Double> var1) throws CommandSyntaxException {
            return DoubleRange.fromReader(var0, DoubleRange::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), var1);
        }
    }

    public static class IntegerRange
    extends CriterionConditionValue<Integer> {
        public static final IntegerRange ANY = new IntegerRange(null, null);
        @Nullable
        private final Long minSq;
        @Nullable
        private final Long maxSq;

        private static IntegerRange create(StringReader var0, @Nullable Integer var1, @Nullable Integer var2) throws CommandSyntaxException {
            if (var1 != null && var2 != null && var1 > var2) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new IntegerRange(var1, var2);
        }

        @Nullable
        private static Long squareOpt(@Nullable Integer var0) {
            return var0 == null ? null : Long.valueOf(var0.longValue() * var0.longValue());
        }

        private IntegerRange(@Nullable Integer var0, @Nullable Integer var1) {
            super(var0, var1);
            this.minSq = IntegerRange.squareOpt(var0);
            this.maxSq = IntegerRange.squareOpt(var1);
        }

        public static IntegerRange exactly(int var0) {
            return new IntegerRange(var0, var0);
        }

        public static IntegerRange between(int var0, int var1) {
            return new IntegerRange(var0, var1);
        }

        public static IntegerRange atLeast(int var0) {
            return new IntegerRange(var0, null);
        }

        public static IntegerRange atMost(int var0) {
            return new IntegerRange(null, var0);
        }

        public boolean matches(int var0) {
            if (this.min != null && (Integer)this.min > var0) {
                return false;
            }
            return this.max == null || (Integer)this.max >= var0;
        }

        public boolean matchesSqr(long var0) {
            if (this.minSq != null && this.minSq > var0) {
                return false;
            }
            return this.maxSq == null || this.maxSq >= var0;
        }

        public static IntegerRange fromJson(@Nullable JsonElement var0) {
            return IntegerRange.fromJson(var0, ANY, ChatDeserializer::convertToInt, IntegerRange::new);
        }

        public static IntegerRange fromReader(StringReader var02) throws CommandSyntaxException {
            return IntegerRange.fromReader(var02, var0 -> var0);
        }

        public static IntegerRange fromReader(StringReader var0, Function<Integer, Integer> var1) throws CommandSyntaxException {
            return IntegerRange.fromReader(var0, IntegerRange::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), var1);
        }
    }
}

