/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionFluid;
import net.minecraft.advancements.critereon.CriterionConditionLight;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class CriterionConditionLocation {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CriterionConditionLocation ANY = new CriterionConditionLocation(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, null, null, null, null, CriterionConditionLight.ANY, CriterionConditionBlock.ANY, CriterionConditionFluid.ANY);
    private final CriterionConditionValue.DoubleRange x;
    private final CriterionConditionValue.DoubleRange y;
    private final CriterionConditionValue.DoubleRange z;
    @Nullable
    private final ResourceKey<BiomeBase> biome;
    @Nullable
    private final ResourceKey<Structure> structure;
    @Nullable
    private final ResourceKey<World> dimension;
    @Nullable
    private final Boolean smokey;
    private final CriterionConditionLight light;
    private final CriterionConditionBlock block;
    private final CriterionConditionFluid fluid;

    public CriterionConditionLocation(CriterionConditionValue.DoubleRange var0, CriterionConditionValue.DoubleRange var1, CriterionConditionValue.DoubleRange var2, @Nullable ResourceKey<BiomeBase> var3, @Nullable ResourceKey<Structure> var4, @Nullable ResourceKey<World> var5, @Nullable Boolean var6, CriterionConditionLight var7, CriterionConditionBlock var8, CriterionConditionFluid var9) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
        this.biome = var3;
        this.structure = var4;
        this.dimension = var5;
        this.smokey = var6;
        this.light = var7;
        this.block = var8;
        this.fluid = var9;
    }

    public static CriterionConditionLocation inBiome(ResourceKey<BiomeBase> var0) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, var0, null, null, null, CriterionConditionLight.ANY, CriterionConditionBlock.ANY, CriterionConditionFluid.ANY);
    }

    public static CriterionConditionLocation inDimension(ResourceKey<World> var0) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, null, null, var0, null, CriterionConditionLight.ANY, CriterionConditionBlock.ANY, CriterionConditionFluid.ANY);
    }

    public static CriterionConditionLocation inStructure(ResourceKey<Structure> var0) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, CriterionConditionValue.DoubleRange.ANY, null, var0, null, null, CriterionConditionLight.ANY, CriterionConditionBlock.ANY, CriterionConditionFluid.ANY);
    }

    public static CriterionConditionLocation atYLocation(CriterionConditionValue.DoubleRange var0) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.ANY, var0, CriterionConditionValue.DoubleRange.ANY, null, null, null, null, CriterionConditionLight.ANY, CriterionConditionBlock.ANY, CriterionConditionFluid.ANY);
    }

    public boolean matches(WorldServer var0, double var1, double var3, double var5) {
        if (!this.x.matches(var1)) {
            return false;
        }
        if (!this.y.matches(var3)) {
            return false;
        }
        if (!this.z.matches(var5)) {
            return false;
        }
        if (this.dimension != null && this.dimension != var0.dimension()) {
            return false;
        }
        BlockPosition var7 = BlockPosition.containing(var1, var3, var5);
        boolean var8 = var0.isLoaded(var7);
        if (!(this.biome == null || var8 && var0.getBiome(var7).is(this.biome))) {
            return false;
        }
        if (!(this.structure == null || var8 && var0.structureManager().getStructureWithPieceAt(var7, this.structure).isValid())) {
            return false;
        }
        if (!(this.smokey == null || var8 && this.smokey == BlockCampfire.isSmokeyPos(var0, var7))) {
            return false;
        }
        if (!this.light.matches(var0, var7)) {
            return false;
        }
        if (!this.block.matches(var0, var7)) {
            return false;
        }
        return this.fluid.matches(var0, var7);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (!(this.x.isAny() && this.y.isAny() && this.z.isAny())) {
            JsonObject var12 = new JsonObject();
            var12.add("x", this.x.serializeToJson());
            var12.add("y", this.y.serializeToJson());
            var12.add("z", this.z.serializeToJson());
            var0.add("position", (JsonElement)var12);
        }
        if (this.dimension != null) {
            World.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.dimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.add("dimension", var1));
        }
        if (this.structure != null) {
            var0.addProperty("structure", this.structure.location().toString());
        }
        if (this.biome != null) {
            var0.addProperty("biome", this.biome.location().toString());
        }
        if (this.smokey != null) {
            var0.addProperty("smokey", this.smokey);
        }
        var0.add("light", this.light.serializeToJson());
        var0.add("block", this.block.serializeToJson());
        var0.add("fluid", this.fluid.serializeToJson());
        return var0;
    }

    public static CriterionConditionLocation fromJson(@Nullable JsonElement var02) {
        MinecraftKey var9;
        ResourceKey var6;
        if (var02 == null || var02.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var02, "location");
        JsonObject var2 = ChatDeserializer.getAsJsonObject(var1, "position", new JsonObject());
        CriterionConditionValue.DoubleRange var3 = CriterionConditionValue.DoubleRange.fromJson(var2.get("x"));
        CriterionConditionValue.DoubleRange var4 = CriterionConditionValue.DoubleRange.fromJson(var2.get("y"));
        CriterionConditionValue.DoubleRange var5 = CriterionConditionValue.DoubleRange.fromJson(var2.get("z"));
        ResourceKey resourceKey = var1.has("dimension") ? (ResourceKey)MinecraftKey.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)var1.get("dimension")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(var0 -> ResourceKey.create(Registries.DIMENSION, var0)).orElse(null) : (var6 = null);
        ResourceKey var7 = var1.has("structure") ? (ResourceKey)MinecraftKey.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)var1.get("structure")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(var0 -> ResourceKey.create(Registries.STRUCTURE, var0)).orElse(null) : null;
        ResourceKey<BiomeBase> var8 = null;
        if (var1.has("biome")) {
            var9 = new MinecraftKey(ChatDeserializer.getAsString(var1, "biome"));
            var8 = ResourceKey.create(Registries.BIOME, var9);
        }
        var9 = var1.has("smokey") ? Boolean.valueOf(var1.get("smokey").getAsBoolean()) : null;
        CriterionConditionLight var10 = CriterionConditionLight.fromJson(var1.get("light"));
        CriterionConditionBlock var11 = CriterionConditionBlock.fromJson(var1.get("block"));
        CriterionConditionFluid var12 = CriterionConditionFluid.fromJson(var1.get("fluid"));
        return new CriterionConditionLocation(var3, var4, var5, var8, var7, var6, (Boolean)((Object)var9), var10, var11, var12);
    }

    public static class a {
        private CriterionConditionValue.DoubleRange x = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange y = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange z = CriterionConditionValue.DoubleRange.ANY;
        @Nullable
        private ResourceKey<BiomeBase> biome;
        @Nullable
        private ResourceKey<Structure> structure;
        @Nullable
        private ResourceKey<World> dimension;
        @Nullable
        private Boolean smokey;
        private CriterionConditionLight light = CriterionConditionLight.ANY;
        private CriterionConditionBlock block = CriterionConditionBlock.ANY;
        private CriterionConditionFluid fluid = CriterionConditionFluid.ANY;

        public static a location() {
            return new a();
        }

        public a setX(CriterionConditionValue.DoubleRange var0) {
            this.x = var0;
            return this;
        }

        public a setY(CriterionConditionValue.DoubleRange var0) {
            this.y = var0;
            return this;
        }

        public a setZ(CriterionConditionValue.DoubleRange var0) {
            this.z = var0;
            return this;
        }

        public a setBiome(@Nullable ResourceKey<BiomeBase> var0) {
            this.biome = var0;
            return this;
        }

        public a setStructure(@Nullable ResourceKey<Structure> var0) {
            this.structure = var0;
            return this;
        }

        public a setDimension(@Nullable ResourceKey<World> var0) {
            this.dimension = var0;
            return this;
        }

        public a setLight(CriterionConditionLight var0) {
            this.light = var0;
            return this;
        }

        public a setBlock(CriterionConditionBlock var0) {
            this.block = var0;
            return this;
        }

        public a setFluid(CriterionConditionFluid var0) {
            this.fluid = var0;
            return this;
        }

        public a setSmokey(Boolean var0) {
            this.smokey = var0;
            return this;
        }

        public CriterionConditionLocation build() {
            return new CriterionConditionLocation(this.x, this.y, this.z, this.biome, this.structure, this.dimension, this.smokey, this.light, this.block, this.fluid);
        }
    }
}

