/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.damagesource.DamageSource;

public class CriterionConditionDamage {
    public static final CriterionConditionDamage ANY = a.damageInstance().build();
    private final CriterionConditionValue.DoubleRange dealtDamage;
    private final CriterionConditionValue.DoubleRange takenDamage;
    private final CriterionConditionEntity sourceEntity;
    @Nullable
    private final Boolean blocked;
    private final CriterionConditionDamageSource type;

    public CriterionConditionDamage() {
        this.dealtDamage = CriterionConditionValue.DoubleRange.ANY;
        this.takenDamage = CriterionConditionValue.DoubleRange.ANY;
        this.sourceEntity = CriterionConditionEntity.ANY;
        this.blocked = null;
        this.type = CriterionConditionDamageSource.ANY;
    }

    public CriterionConditionDamage(CriterionConditionValue.DoubleRange var0, CriterionConditionValue.DoubleRange var1, CriterionConditionEntity var2, @Nullable Boolean var3, CriterionConditionDamageSource var4) {
        this.dealtDamage = var0;
        this.takenDamage = var1;
        this.sourceEntity = var2;
        this.blocked = var3;
        this.type = var4;
    }

    public boolean matches(EntityPlayer var0, DamageSource var1, float var2, float var3, boolean var4) {
        if (this == ANY) {
            return true;
        }
        if (!this.dealtDamage.matches(var2)) {
            return false;
        }
        if (!this.takenDamage.matches(var3)) {
            return false;
        }
        if (!this.sourceEntity.matches(var0, var1.getEntity())) {
            return false;
        }
        if (this.blocked != null && this.blocked != var4) {
            return false;
        }
        return this.type.matches(var0, var1);
    }

    public static CriterionConditionDamage fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "damage");
        CriterionConditionValue.DoubleRange var2 = CriterionConditionValue.DoubleRange.fromJson(var1.get("dealt"));
        CriterionConditionValue.DoubleRange var3 = CriterionConditionValue.DoubleRange.fromJson(var1.get("taken"));
        Boolean var4 = var1.has("blocked") ? Boolean.valueOf(ChatDeserializer.getAsBoolean(var1, "blocked")) : null;
        CriterionConditionEntity var5 = CriterionConditionEntity.fromJson(var1.get("source_entity"));
        CriterionConditionDamageSource var6 = CriterionConditionDamageSource.fromJson(var1.get("type"));
        return new CriterionConditionDamage(var2, var3, var5, var4, var6);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add("dealt", this.dealtDamage.serializeToJson());
        var0.add("taken", this.takenDamage.serializeToJson());
        var0.add("source_entity", this.sourceEntity.serializeToJson());
        var0.add("type", this.type.serializeToJson());
        if (this.blocked != null) {
            var0.addProperty("blocked", this.blocked);
        }
        return var0;
    }

    public static class a {
        private CriterionConditionValue.DoubleRange dealtDamage = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange takenDamage = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionEntity sourceEntity = CriterionConditionEntity.ANY;
        @Nullable
        private Boolean blocked;
        private CriterionConditionDamageSource type = CriterionConditionDamageSource.ANY;

        public static a damageInstance() {
            return new a();
        }

        public a dealtDamage(CriterionConditionValue.DoubleRange var0) {
            this.dealtDamage = var0;
            return this;
        }

        public a takenDamage(CriterionConditionValue.DoubleRange var0) {
            this.takenDamage = var0;
            return this;
        }

        public a sourceEntity(CriterionConditionEntity var0) {
            this.sourceEntity = var0;
            return this;
        }

        public a blocked(Boolean var0) {
            this.blocked = var0;
            return this;
        }

        public a type(CriterionConditionDamageSource var0) {
            this.type = var0;
            return this;
        }

        public a type(CriterionConditionDamageSource.a var0) {
            this.type = var0.build();
            return this;
        }

        public CriterionConditionDamage build() {
            return new CriterionConditionDamage(this.dealtDamage, this.takenDamage, this.sourceEntity, this.blocked, this.type);
        }
    }
}

