/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CustomFunction;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class AdvancementRewards {
    public static final AdvancementRewards EMPTY = new AdvancementRewards(0, new MinecraftKey[0], new MinecraftKey[0], CustomFunction.a.NONE);
    private final int experience;
    private final MinecraftKey[] loot;
    private final MinecraftKey[] recipes;
    private final CustomFunction.a function;

    public AdvancementRewards(int var0, MinecraftKey[] var1, MinecraftKey[] var2, CustomFunction.a var3) {
        this.experience = var0;
        this.loot = var1;
        this.recipes = var2;
        this.function = var3;
    }

    public MinecraftKey[] getRecipes() {
        return this.recipes;
    }

    public void grant(EntityPlayer var0) {
        var0.giveExperiencePoints(this.experience);
        LootTableInfo var1 = new LootTableInfo.Builder(var0.getLevel()).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.ORIGIN, var0.position()).withRandom(var0.getRandom()).create(LootContextParameterSets.ADVANCEMENT_REWARD);
        boolean var22 = false;
        for (MinecraftKey var6 : this.loot) {
            for (ItemStack var8 : var0.server.getLootTables().get(var6).getRandomItems(var1)) {
                if (var0.addItem(var8)) {
                    var0.level.playSound(null, var0.getX(), var0.getY(), var0.getZ(), SoundEffects.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((var0.getRandom().nextFloat() - var0.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    var22 = true;
                    continue;
                }
                EntityItem var9 = var0.drop(var8, false);
                if (var9 == null) continue;
                var9.setNoPickUpDelay();
                var9.setTarget(var0.getUUID());
            }
        }
        if (var22) {
            var0.containerMenu.broadcastChanges();
        }
        if (this.recipes.length > 0) {
            var0.awardRecipesByKey(this.recipes);
        }
        MinecraftServer var3 = var0.server;
        this.function.get(var3.getFunctions()).ifPresent(var2 -> var3.getFunctions().execute((CustomFunction)var2, var0.createCommandSourceStack().withSuppressedOutput().withPermission(2)));
    }

    public String toString() {
        return "AdvancementRewards{experience=" + this.experience + ", loot=" + Arrays.toString(this.loot) + ", recipes=" + Arrays.toString(this.recipes) + ", function=" + this.function + "}";
    }

    public JsonElement serializeToJson() {
        JsonArray var1;
        if (this == EMPTY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (this.experience != 0) {
            var0.addProperty("experience", (Number)this.experience);
        }
        if (this.loot.length > 0) {
            var1 = new JsonArray();
            for (MinecraftKey var5 : this.loot) {
                var1.add(var5.toString());
            }
            var0.add("loot", (JsonElement)var1);
        }
        if (this.recipes.length > 0) {
            var1 = new JsonArray();
            for (MinecraftKey var5 : this.recipes) {
                var1.add(var5.toString());
            }
            var0.add("recipes", (JsonElement)var1);
        }
        if (this.function.getId() != null) {
            var0.addProperty("function", this.function.getId().toString());
        }
        return var0;
    }

    public static AdvancementRewards deserialize(JsonObject var0) throws JsonParseException {
        int var1 = ChatDeserializer.getAsInt(var0, "experience", 0);
        JsonArray var2 = ChatDeserializer.getAsJsonArray(var0, "loot", new JsonArray());
        MinecraftKey[] var3 = new MinecraftKey[var2.size()];
        for (int var4 = 0; var4 < var3.length; ++var4) {
            var3[var4] = new MinecraftKey(ChatDeserializer.convertToString(var2.get(var4), "loot[" + var4 + "]"));
        }
        JsonArray var4 = ChatDeserializer.getAsJsonArray(var0, "recipes", new JsonArray());
        MinecraftKey[] var5 = new MinecraftKey[var4.size()];
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = new MinecraftKey(ChatDeserializer.convertToString(var4.get(var6), "recipes[" + var6 + "]"));
        }
        CustomFunction.a var6 = var0.has("function") ? new CustomFunction.a(new MinecraftKey(ChatDeserializer.getAsString(var0, "function"))) : CustomFunction.a.NONE;
        return new AdvancementRewards(var1, var3, var5, var6);
    }

    public static class a {
        private int experience;
        private final List<MinecraftKey> loot = Lists.newArrayList();
        private final List<MinecraftKey> recipes = Lists.newArrayList();
        @Nullable
        private MinecraftKey function;

        public static a experience(int var0) {
            return new a().addExperience(var0);
        }

        public a addExperience(int var0) {
            this.experience += var0;
            return this;
        }

        public static a loot(MinecraftKey var0) {
            return new a().addLootTable(var0);
        }

        public a addLootTable(MinecraftKey var0) {
            this.loot.add(var0);
            return this;
        }

        public static a recipe(MinecraftKey var0) {
            return new a().addRecipe(var0);
        }

        public a addRecipe(MinecraftKey var0) {
            this.recipes.add(var0);
            return this;
        }

        public static a function(MinecraftKey var0) {
            return new a().runs(var0);
        }

        public a runs(MinecraftKey var0) {
            this.function = var0;
            return this;
        }

        public AdvancementRewards build() {
            return new AdvancementRewards(this.experience, this.loot.toArray(new MinecraftKey[0]), this.recipes.toArray(new MinecraftKey[0]), this.function == null ? CustomFunction.a.NONE : new CustomFunction.a(this.function));
        }
    }
}

