/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import org.apache.commons.lang3.ArrayUtils;

public class Advancement {
    @Nullable
    private final Advancement parent;
    @Nullable
    private final AdvancementDisplay display;
    private final AdvancementRewards rewards;
    private final MinecraftKey id;
    private final Map<String, Criterion> criteria;
    private final String[][] requirements;
    private final Set<Advancement> children = Sets.newLinkedHashSet();
    private final IChatBaseComponent chatComponent;

    public Advancement(MinecraftKey var0, @Nullable Advancement var12, @Nullable AdvancementDisplay var2, AdvancementRewards var3, Map<String, Criterion> var4, String[][] var5) {
        this.id = var0;
        this.display = var2;
        this.criteria = ImmutableMap.copyOf(var4);
        this.parent = var12;
        this.rewards = var3;
        this.requirements = var5;
        if (var12 != null) {
            var12.addChild(this);
        }
        if (var2 == null) {
            this.chatComponent = IChatBaseComponent.literal(var0.toString());
        } else {
            IChatBaseComponent var6 = var2.getTitle();
            EnumChatFormat var7 = var2.getFrame().getChatColor();
            IChatMutableComponent var8 = ChatComponentUtils.mergeStyles(var6.copy(), ChatModifier.EMPTY.withColor(var7)).append("\n").append(var2.getDescription());
            IChatMutableComponent var9 = var6.copy().withStyle(var1 -> var1.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, var8)));
            this.chatComponent = ChatComponentUtils.wrapInSquareBrackets(var9).withStyle(var7);
        }
    }

    public SerializedAdvancement deconstruct() {
        return new SerializedAdvancement(this.parent == null ? null : this.parent.getId(), this.display, this.rewards, this.criteria, this.requirements);
    }

    @Nullable
    public Advancement getParent() {
        return this.parent;
    }

    public Advancement getRoot() {
        return Advancement.getRoot(this);
    }

    public static Advancement getRoot(Advancement var0) {
        Advancement var1 = var0;
        Advancement var2;
        while ((var2 = var1.getParent()) != null) {
            var1 = var2;
        }
        return var1;
    }

    @Nullable
    public AdvancementDisplay getDisplay() {
        return this.display;
    }

    public AdvancementRewards getRewards() {
        return this.rewards;
    }

    public String toString() {
        return "SimpleAdvancement{id=" + this.getId() + ", parent=" + (Comparable)(this.parent == null ? "null" : this.parent.getId()) + ", display=" + this.display + ", rewards=" + this.rewards + ", criteria=" + this.criteria + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
    }

    public Iterable<Advancement> getChildren() {
        return this.children;
    }

    public Map<String, Criterion> getCriteria() {
        return this.criteria;
    }

    public int getMaxCriteraRequired() {
        return this.requirements.length;
    }

    public void addChild(Advancement var0) {
        this.children.add(var0);
    }

    public MinecraftKey getId() {
        return this.id;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Advancement)) {
            return false;
        }
        Advancement var1 = (Advancement)var0;
        return this.id.equals(var1.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String[][] getRequirements() {
        return this.requirements;
    }

    public IChatBaseComponent getChatComponent() {
        return this.chatComponent;
    }

    public static class SerializedAdvancement {
        @Nullable
        private MinecraftKey parentId;
        @Nullable
        private Advancement parent;
        @Nullable
        private AdvancementDisplay display;
        private AdvancementRewards rewards = AdvancementRewards.EMPTY;
        private Map<String, Criterion> criteria = Maps.newLinkedHashMap();
        @Nullable
        private String[][] requirements;
        private AdvancementRequirements requirementsStrategy = AdvancementRequirements.AND;

        SerializedAdvancement(@Nullable MinecraftKey var0, @Nullable AdvancementDisplay var1, AdvancementRewards var2, Map<String, Criterion> var3, String[][] var4) {
            this.parentId = var0;
            this.display = var1;
            this.rewards = var2;
            this.criteria = var3;
            this.requirements = var4;
        }

        private SerializedAdvancement() {
        }

        public static SerializedAdvancement advancement() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement parent(Advancement var0) {
            this.parent = var0;
            return this;
        }

        public SerializedAdvancement parent(MinecraftKey var0) {
            this.parentId = var0;
            return this;
        }

        public SerializedAdvancement display(ItemStack var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new AdvancementDisplay(var0, var1, var2, var3, var4, var5, var6, var7));
        }

        public SerializedAdvancement display(IMaterial var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new AdvancementDisplay(new ItemStack(var0.asItem()), var1, var2, var3, var4, var5, var6, var7));
        }

        public SerializedAdvancement display(AdvancementDisplay var0) {
            this.display = var0;
            return this;
        }

        public SerializedAdvancement rewards(AdvancementRewards.a var0) {
            return this.rewards(var0.build());
        }

        public SerializedAdvancement rewards(AdvancementRewards var0) {
            this.rewards = var0;
            return this;
        }

        public SerializedAdvancement addCriterion(String var0, CriterionInstance var1) {
            return this.addCriterion(var0, new Criterion(var1));
        }

        public SerializedAdvancement addCriterion(String var0, Criterion var1) {
            if (this.criteria.containsKey(var0)) {
                throw new IllegalArgumentException("Duplicate criterion " + var0);
            }
            this.criteria.put(var0, var1);
            return this;
        }

        public SerializedAdvancement requirements(AdvancementRequirements var0) {
            this.requirementsStrategy = var0;
            return this;
        }

        public SerializedAdvancement requirements(String[][] var0) {
            this.requirements = var0;
            return this;
        }

        public boolean canBuild(Function<MinecraftKey, Advancement> var0) {
            if (this.parentId == null) {
                return true;
            }
            if (this.parent == null) {
                this.parent = var0.apply(this.parentId);
            }
            return this.parent != null;
        }

        public Advancement build(MinecraftKey var02) {
            if (!this.canBuild(var0 -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            return new Advancement(var02, this.parent, this.display, this.rewards, this.criteria, this.requirements);
        }

        public Advancement save(Consumer<Advancement> var0, String var1) {
            Advancement var2 = this.build(new MinecraftKey(var1));
            var0.accept(var2);
            return var2;
        }

        public JsonObject serializeToJson() {
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            JsonObject var0 = new JsonObject();
            if (this.parent != null) {
                var0.addProperty("parent", this.parent.getId().toString());
            } else if (this.parentId != null) {
                var0.addProperty("parent", this.parentId.toString());
            }
            if (this.display != null) {
                var0.add("display", this.display.serializeToJson());
            }
            var0.add("rewards", this.rewards.serializeToJson());
            JsonObject var1 = new JsonObject();
            for (Map.Entry<String, Criterion> var3 : this.criteria.entrySet()) {
                var1.add(var3.getKey(), var3.getValue().serializeToJson());
            }
            var0.add("criteria", (JsonElement)var1);
            JsonArray var2 = new JsonArray();
            for (String[] var6 : this.requirements) {
                JsonArray var7 = new JsonArray();
                for (String var11 : var6) {
                    var7.add(var11);
                }
                var2.add((JsonElement)var7);
            }
            var0.add("requirements", (JsonElement)var2);
            return var0;
        }

        public void serializeToNetwork(PacketDataSerializer var02) {
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            var02.writeNullable(this.parentId, PacketDataSerializer::writeResourceLocation);
            var02.writeNullable(this.display, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
            Criterion.serializeToNetwork(this.criteria, var02);
            var02.writeVarInt(this.requirements.length);
            for (String[] var4 : this.requirements) {
                var02.writeVarInt(var4.length);
                for (String var8 : var4) {
                    var02.writeUtf(var8);
                }
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.parentId + ", display=" + this.display + ", rewards=" + this.rewards + ", criteria=" + this.criteria + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
        }

        public static SerializedAdvancement fromJson(JsonObject var0, LootDeserializationContext var1) {
            int var8;
            MinecraftKey var2 = var0.has("parent") ? new MinecraftKey(ChatDeserializer.getAsString(var0, "parent")) : null;
            AdvancementDisplay var3 = var0.has("display") ? AdvancementDisplay.fromJson(ChatDeserializer.getAsJsonObject(var0, "display")) : null;
            AdvancementRewards var4 = var0.has("rewards") ? AdvancementRewards.deserialize(ChatDeserializer.getAsJsonObject(var0, "rewards")) : AdvancementRewards.EMPTY;
            Map<String, Criterion> var5 = Criterion.criteriaFromJson(ChatDeserializer.getAsJsonObject(var0, "criteria"), var1);
            if (var5.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray var6 = ChatDeserializer.getAsJsonArray(var0, "requirements", new JsonArray());
            String[][] var7 = new String[var6.size()][];
            for (var8 = 0; var8 < var6.size(); ++var8) {
                JsonArray var9 = ChatDeserializer.convertToJsonArray(var6.get(var8), "requirements[" + var8 + "]");
                var7[var8] = new String[var9.size()];
                for (int var10 = 0; var10 < var9.size(); ++var10) {
                    var7[var8][var10] = ChatDeserializer.convertToString(var9.get(var10), "requirements[" + var8 + "][" + var10 + "]");
                }
            }
            if (var7.length == 0) {
                var7 = new String[var5.size()][];
                var8 = 0;
                for (String var10 : var5.keySet()) {
                    var7[var8++] = new String[]{var10};
                }
            }
            for (String[] var11 : var7) {
                if (var11.length == 0 && var5.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray = var11;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String var15 = stringArray[i2];
                    if (var5.containsKey(var15)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + var15 + "'");
                }
            }
            for (String var9 : var5.keySet()) {
                int var10 = 0;
                for (Object[] objectArray : var7) {
                    if (!ArrayUtils.contains((Object[])objectArray, (Object)var9)) continue;
                    var10 = 1;
                    break;
                }
                if (var10 != 0) continue;
                throw new JsonSyntaxException("Criterion '" + var9 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new SerializedAdvancement(var2, var3, var4, var5, var7);
        }

        public static SerializedAdvancement fromNetwork(PacketDataSerializer var0) {
            MinecraftKey var1 = (MinecraftKey)var0.readNullable(PacketDataSerializer::readResourceLocation);
            AdvancementDisplay var2 = (AdvancementDisplay)var0.readNullable(AdvancementDisplay::fromNetwork);
            Map<String, Criterion> var3 = Criterion.criteriaFromNetwork(var0);
            String[][] var4 = new String[var0.readVarInt()][];
            for (int var5 = 0; var5 < var4.length; ++var5) {
                var4[var5] = new String[var0.readVarInt()];
                for (int var6 = 0; var6 < var4[var5].length; ++var6) {
                    var4[var5][var6] = var0.readUtf();
                }
            }
            return new SerializedAdvancement(var1, var2, AdvancementRewards.EMPTY, var3, var4);
        }

        public Map<String, Criterion> getCriteria() {
            return this.criteria;
        }
    }
}

