/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.ContextScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;
import net.minecraft.world.scores.ScoreboardObjective;

public class ScoreboardValue
implements NumberProvider {
    final ScoreboardNameProvider target;
    final String score;
    final float scale;

    ScoreboardValue(ScoreboardNameProvider var0, String var1, float var2) {
        this.target = var0;
        this.score = var1;
        this.scale = var2;
    }

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.SCORE;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.target.getReferencedContextParams();
    }

    public static ScoreboardValue fromScoreboard(LootTableInfo.EntityTarget var0, String var1) {
        return ScoreboardValue.fromScoreboard(var0, var1, 1.0f);
    }

    public static ScoreboardValue fromScoreboard(LootTableInfo.EntityTarget var0, String var1, float var2) {
        return new ScoreboardValue(ContextScoreboardNameProvider.forTarget(var0), var1, var2);
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        String var1 = this.target.getScoreboardName(var0);
        if (var1 == null) {
            return 0.0f;
        }
        ScoreboardServer var2 = var0.getLevel().getScoreboard();
        ScoreboardObjective var3 = var2.getObjective(this.score);
        if (var3 == null) {
            return 0.0f;
        }
        if (!var2.hasPlayerScore(var1, var3)) {
            return 0.0f;
        }
        return (float)var2.getOrCreatePlayerScore(var1, var3).getScore() * this.scale;
    }

    public static class a
    implements LootSerializer<ScoreboardValue> {
        @Override
        public ScoreboardValue deserialize(JsonObject var0, JsonDeserializationContext var1) {
            String var2 = ChatDeserializer.getAsString(var0, "score");
            float var3 = ChatDeserializer.getAsFloat(var0, "scale", 1.0f);
            ScoreboardNameProvider var4 = ChatDeserializer.getAsObject(var0, "target", var1, ScoreboardNameProvider.class);
            return new ScoreboardValue(var4, var2, var3);
        }

        @Override
        public void serialize(JsonObject var0, ScoreboardValue var1, JsonSerializationContext var2) {
            var0.addProperty("score", var1.score);
            var0.add("target", var2.serialize((Object)var1.target));
            var0.addProperty("scale", (Number)Float.valueOf(var1.scale));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

