/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import java.util.function.Predicate;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionAlternative;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityScore;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionInverted;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionKilledByPlayer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChanceWithLooting;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionSurvivesExplosion;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTableBonus;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTimeCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionWeatherCheck;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;

public class LootItemConditions {
    public static final LootItemConditionType INVERTED = LootItemConditions.register("inverted", new LootItemConditionInverted.a());
    public static final LootItemConditionType ALTERNATIVE = LootItemConditions.register("alternative", new LootItemConditionAlternative.b());
    public static final LootItemConditionType RANDOM_CHANCE = LootItemConditions.register("random_chance", new LootItemConditionRandomChance.a());
    public static final LootItemConditionType RANDOM_CHANCE_WITH_LOOTING = LootItemConditions.register("random_chance_with_looting", new LootItemConditionRandomChanceWithLooting.a());
    public static final LootItemConditionType ENTITY_PROPERTIES = LootItemConditions.register("entity_properties", new LootItemConditionEntityProperty.a());
    public static final LootItemConditionType KILLED_BY_PLAYER = LootItemConditions.register("killed_by_player", new LootItemConditionKilledByPlayer.a());
    public static final LootItemConditionType ENTITY_SCORES = LootItemConditions.register("entity_scores", new LootItemConditionEntityScore.b());
    public static final LootItemConditionType BLOCK_STATE_PROPERTY = LootItemConditions.register("block_state_property", new LootItemConditionBlockStateProperty.b());
    public static final LootItemConditionType MATCH_TOOL = LootItemConditions.register("match_tool", new LootItemConditionMatchTool.a());
    public static final LootItemConditionType TABLE_BONUS = LootItemConditions.register("table_bonus", new LootItemConditionTableBonus.a());
    public static final LootItemConditionType SURVIVES_EXPLOSION = LootItemConditions.register("survives_explosion", new LootItemConditionSurvivesExplosion.a());
    public static final LootItemConditionType DAMAGE_SOURCE_PROPERTIES = LootItemConditions.register("damage_source_properties", new LootItemConditionDamageSourceProperties.a());
    public static final LootItemConditionType LOCATION_CHECK = LootItemConditions.register("location_check", new LootItemConditionLocationCheck.a());
    public static final LootItemConditionType WEATHER_CHECK = LootItemConditions.register("weather_check", new LootItemConditionWeatherCheck.b());
    public static final LootItemConditionType REFERENCE = LootItemConditions.register("reference", new LootItemConditionReference.a());
    public static final LootItemConditionType TIME_CHECK = LootItemConditions.register("time_check", new LootItemConditionTimeCheck.b());
    public static final LootItemConditionType VALUE_CHECK = LootItemConditions.register("value_check", new ValueCheckCondition.a());

    private static LootItemConditionType register(String var0, LootSerializer<? extends LootItemCondition> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_CONDITION_TYPE, new MinecraftKey(var0), new LootItemConditionType(var1));
    }

    public static Object createGsonAdapter() {
        return JsonRegistry.builder(BuiltInRegistries.LOOT_CONDITION_TYPE, "condition", "condition", LootItemCondition::getType).build();
    }

    public static <T> Predicate<T> andConditions(Predicate<T>[] var02) {
        switch (var02.length) {
            case 0: {
                return var0 -> true;
            }
            case 1: {
                return var02[0];
            }
            case 2: {
                return var02[0].and(var02[1]);
            }
        }
        return var1 -> {
            for (Predicate var5 : var02) {
                if (var5.test(var1)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> orConditions(Predicate<T>[] var02) {
        switch (var02.length) {
            case 0: {
                return var0 -> false;
            }
            case 1: {
                return var02[0];
            }
            case 2: {
                return var02[0].or(var02[1]);
            }
        }
        return var1 -> {
            for (Predicate var5 : var02) {
                if (!var5.test(var1)) continue;
                return true;
            }
            return false;
        };
    }
}

