/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;

public class LootItemConditionEntityScore
implements LootItemCondition {
    final Map<String, IntRange> scores;
    final LootTableInfo.EntityTarget entityTarget;

    LootItemConditionEntityScore(Map<String, IntRange> var0, LootTableInfo.EntityTarget var1) {
        this.scores = ImmutableMap.copyOf(var0);
        this.entityTarget = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ENTITY_SCORES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)Stream.concat(Stream.of(this.entityTarget.getParam()), this.scores.values().stream().flatMap(var0 -> var0.getReferencedContextParams().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(this.entityTarget.getParam());
        if (var1 == null) {
            return false;
        }
        Scoreboard var2 = var1.level.getScoreboard();
        for (Map.Entry<String, IntRange> var4 : this.scores.entrySet()) {
            if (this.hasScore(var0, var1, var2, var4.getKey(), var4.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasScore(LootTableInfo var0, Entity var1, Scoreboard var2, String var3, IntRange var4) {
        ScoreboardObjective var5 = var2.getObjective(var3);
        if (var5 == null) {
            return false;
        }
        String var6 = var1.getScoreboardName();
        if (!var2.hasPlayerScore(var6, var5)) {
            return false;
        }
        return var4.test(var0, var2.getOrCreatePlayerScore(var6, var5).getScore());
    }

    public static a hasScores(LootTableInfo.EntityTarget var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final Map<String, IntRange> scores = Maps.newHashMap();
        private final LootTableInfo.EntityTarget entityTarget;

        public a(LootTableInfo.EntityTarget var0) {
            this.entityTarget = var0;
        }

        public a withScore(String var0, IntRange var1) {
            this.scores.put(var0, var1);
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new LootItemConditionEntityScore(this.scores, this.entityTarget);
        }
    }

    public static class b
    implements LootSerializer<LootItemConditionEntityScore> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionEntityScore var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            for (Map.Entry<String, IntRange> var5 : var1.scores.entrySet()) {
                var3.add(var5.getKey(), var2.serialize((Object)var5.getValue()));
            }
            var0.add("scores", (JsonElement)var3);
            var0.add("entity", var2.serialize((Object)var1.entityTarget));
        }

        @Override
        public LootItemConditionEntityScore deserialize(JsonObject var0, JsonDeserializationContext var1) {
            Set var2 = ChatDeserializer.getAsJsonObject(var0, "scores").entrySet();
            LinkedHashMap var3 = Maps.newLinkedHashMap();
            for (Map.Entry var5 : var2) {
                var3.put((String)var5.getKey(), ChatDeserializer.convertToObject((JsonElement)var5.getValue(), "score", var1, IntRange.class));
            }
            return new LootItemConditionEntityScore(var3, ChatDeserializer.getAsObject(var0, "entity", var1, LootTableInfo.EntityTarget.class));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

