/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetPotionFunction
extends LootItemFunctionConditional {
    final PotionRegistry potion;

    SetPotionFunction(LootItemCondition[] var0, PotionRegistry var1) {
        super(var0);
        this.potion = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_POTION;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        PotionUtil.setPotion(var0, this.potion);
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setPotion(PotionRegistry var0) {
        return SetPotionFunction.simpleBuilder(var1 -> new SetPotionFunction((LootItemCondition[])var1, var0));
    }

    public static class a
    extends LootItemFunctionConditional.c<SetPotionFunction> {
        @Override
        public void serialize(JsonObject var0, SetPotionFunction var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("id", BuiltInRegistries.POTION.getKey(var1.potion).toString());
        }

        @Override
        public SetPotionFunction deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            String var3 = ChatDeserializer.getAsString(var0, "id");
            PotionRegistry var4 = (PotionRegistry)BuiltInRegistries.POTION.getOptional(MinecraftKey.tryParse(var3)).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + var3 + "'"));
            return new SetPotionFunction(var2, var4);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

