/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootItemFunctionSetStewEffect
extends LootItemFunctionConditional {
    final Map<MobEffectList, NumberProvider> effectDurationMap;

    LootItemFunctionSetStewEffect(LootItemCondition[] var0, Map<MobEffectList, NumberProvider> var1) {
        super(var0);
        this.effectDurationMap = ImmutableMap.copyOf(var1);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_STEW_EFFECT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)this.effectDurationMap.values().stream().flatMap(var0 -> var0.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (!var0.is(Items.SUSPICIOUS_STEW) || this.effectDurationMap.isEmpty()) {
            return var0;
        }
        RandomSource var2 = var1.getRandom();
        int var3 = var2.nextInt(this.effectDurationMap.size());
        Map.Entry var4 = (Map.Entry)Iterables.get(this.effectDurationMap.entrySet(), (int)var3);
        MobEffectList var5 = (MobEffectList)var4.getKey();
        int var6 = ((NumberProvider)var4.getValue()).getInt(var1);
        if (!var5.isInstantenous()) {
            var6 *= 20;
        }
        ItemSuspiciousStew.saveMobEffect(var0, var5, var6);
        return var0;
    }

    public static a stewEffect() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Map<MobEffectList, NumberProvider> effectDurationMap = Maps.newLinkedHashMap();

        @Override
        protected a getThis() {
            return this;
        }

        public a withEffect(MobEffectList var0, NumberProvider var1) {
            this.effectDurationMap.put(var0, var1);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetStewEffect(this.getConditions(), this.effectDurationMap);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionSetStewEffect> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetStewEffect var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            if (!var1.effectDurationMap.isEmpty()) {
                JsonArray var3 = new JsonArray();
                for (MobEffectList var5 : var1.effectDurationMap.keySet()) {
                    JsonObject var6 = new JsonObject();
                    MinecraftKey var7 = BuiltInRegistries.MOB_EFFECT.getKey(var5);
                    if (var7 == null) {
                        throw new IllegalArgumentException("Don't know how to serialize mob effect " + var5);
                    }
                    var6.add("type", (JsonElement)new JsonPrimitive(var7.toString()));
                    var6.add("duration", var2.serialize((Object)var1.effectDurationMap.get(var5)));
                    var3.add((JsonElement)var6);
                }
                var0.add("effects", (JsonElement)var3);
            }
        }

        @Override
        public LootItemFunctionSetStewEffect deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            LinkedHashMap var3 = Maps.newLinkedHashMap();
            if (var0.has("effects")) {
                JsonArray var4 = ChatDeserializer.getAsJsonArray(var0, "effects");
                for (JsonElement var6 : var4) {
                    String var7 = ChatDeserializer.getAsString(var6.getAsJsonObject(), "type");
                    MobEffectList var8 = BuiltInRegistries.MOB_EFFECT.getOptional(new MinecraftKey(var7)).orElseThrow(() -> new JsonSyntaxException("Unknown mob effect '" + var7 + "'"));
                    NumberProvider var9 = ChatDeserializer.getAsObject(var6.getAsJsonObject(), "duration", var1, NumberProvider.class);
                    var3.put(var8, var9);
                }
            }
            return new LootItemFunctionSetStewEffect(var2, var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

