/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootEntryChildrenAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootEntrySequence;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootSelectorDynamic;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEmpty;
import net.minecraft.world.level.storage.loot.entries.LootSelectorLootTable;
import net.minecraft.world.level.storage.loot.entries.LootSelectorTag;

public class LootEntries {
    public static final LootEntryType EMPTY = LootEntries.register("empty", new LootSelectorEmpty.a());
    public static final LootEntryType ITEM = LootEntries.register("item", new LootItem.a());
    public static final LootEntryType REFERENCE = LootEntries.register("loot_table", new LootSelectorLootTable.a());
    public static final LootEntryType DYNAMIC = LootEntries.register("dynamic", new LootSelectorDynamic.a());
    public static final LootEntryType TAG = LootEntries.register("tag", new LootSelectorTag.a());
    public static final LootEntryType ALTERNATIVES = LootEntries.register("alternatives", LootEntryChildrenAbstract.createSerializer(LootEntryAlternatives::new));
    public static final LootEntryType SEQUENCE = LootEntries.register("sequence", LootEntryChildrenAbstract.createSerializer(LootEntrySequence::new));
    public static final LootEntryType GROUP = LootEntries.register("group", LootEntryChildrenAbstract.createSerializer(LootEntryGroup::new));

    private static LootEntryType register(String var0, LootSerializer<? extends LootEntryAbstract> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_POOL_ENTRY_TYPE, new MinecraftKey(var0), new LootEntryType(var1));
    }

    public static Object createGsonAdapter() {
        return JsonRegistry.builder(BuiltInRegistries.LOOT_POOL_ENTRY_TYPE, "entry", "type", LootEntryAbstract::getType).build();
    }
}

