/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String PLAYER = "Player";
    protected static final String WORLD_GEN_SETTINGS = "WorldGenSettings";
    public WorldSettings settings;
    private final WorldOptions worldOptions;
    private final a specialWorldProperty;
    private final Lifecycle worldGenSettingsLifecycle;
    private int xSpawn;
    private int ySpawn;
    private int zSpawn;
    private float spawnAngle;
    private long gameTime;
    private long dayTime;
    @Nullable
    private final DataFixer fixerUpper;
    private final int playerDataVersion;
    private boolean upgradedPlayerTag;
    @Nullable
    private NBTTagCompound loadedPlayerTag;
    private final int version;
    private int clearWeatherTime;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private boolean initialized;
    private boolean difficultyLocked;
    private WorldBorder.c worldBorder;
    private NBTTagCompound endDragonFightData;
    @Nullable
    private NBTTagCompound customBossEvents;
    private int wanderingTraderSpawnDelay;
    private int wanderingTraderSpawnChance;
    @Nullable
    private UUID wanderingTraderId;
    private final Set<String> knownServerBrands;
    private boolean wasModded;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents;

    private WorldDataServer(@Nullable DataFixer var0, int var1, @Nullable NBTTagCompound var2, boolean var3, int var4, int var5, int var6, float var7, long var8, long var10, int var12, int var13, int var14, boolean var15, int var16, boolean var17, boolean var18, boolean var19, WorldBorder.c var20, int var21, int var22, @Nullable UUID var23, Set<String> var24, CustomFunctionCallbackTimerQueue<MinecraftServer> var25, @Nullable NBTTagCompound var26, NBTTagCompound var27, WorldSettings var28, WorldOptions var29, a var30, Lifecycle var31) {
        this.fixerUpper = var0;
        this.wasModded = var3;
        this.xSpawn = var4;
        this.ySpawn = var5;
        this.zSpawn = var6;
        this.spawnAngle = var7;
        this.gameTime = var8;
        this.dayTime = var10;
        this.version = var12;
        this.clearWeatherTime = var13;
        this.rainTime = var14;
        this.raining = var15;
        this.thunderTime = var16;
        this.thundering = var17;
        this.initialized = var18;
        this.difficultyLocked = var19;
        this.worldBorder = var20;
        this.wanderingTraderSpawnDelay = var21;
        this.wanderingTraderSpawnChance = var22;
        this.wanderingTraderId = var23;
        this.knownServerBrands = var24;
        this.loadedPlayerTag = var2;
        this.playerDataVersion = var1;
        this.scheduledEvents = var25;
        this.customBossEvents = var26;
        this.endDragonFightData = var27;
        this.settings = var28;
        this.worldOptions = var29;
        this.specialWorldProperty = var30;
        this.worldGenSettingsLifecycle = var31;
    }

    public WorldDataServer(WorldSettings var0, WorldOptions var1, a var2, Lifecycle var3) {
        this(null, SharedConstants.getCurrentVersion().getWorldVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.DEFAULT_SETTINGS, 0, 0, null, Sets.newLinkedHashSet(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.SERVER_CALLBACKS), null, new NBTTagCompound(), var0.copy(), var1, var2, var3);
    }

    public static WorldDataServer parse(Dynamic<NBTBase> var02, DataFixer var1, int var2, @Nullable NBTTagCompound var3, WorldSettings var4, LevelVersion var5, a var6, WorldOptions var7, Lifecycle var8) {
        long var9 = var02.get("Time").asLong(0L);
        NBTTagCompound var11 = (NBTTagCompound)var02.get("DragonFight").result().map(Dynamic::getValue).orElseGet(() -> (NBTBase)var02.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap().getValue());
        return new WorldDataServer(var1, var2, var3, var02.get("WasModded").asBoolean(false), var02.get("SpawnX").asInt(0), var02.get("SpawnY").asInt(0), var02.get("SpawnZ").asInt(0), var02.get("SpawnAngle").asFloat(0.0f), var9, var02.get("DayTime").asLong(var9), var5.levelDataVersion(), var02.get("clearWeatherTime").asInt(0), var02.get("rainTime").asInt(0), var02.get("raining").asBoolean(false), var02.get("thunderTime").asInt(0), var02.get("thundering").asBoolean(false), var02.get("initialized").asBoolean(true), var02.get("DifficultyLocked").asBoolean(false), WorldBorder.c.read(var02, WorldBorder.DEFAULT_SETTINGS), var02.get("WanderingTraderSpawnDelay").asInt(0), var02.get("WanderingTraderSpawnChance").asInt(0), var02.get("WanderingTraderId").read(UUIDUtil.CODEC).result().orElse(null), var02.get("ServerBrands").asStream().flatMap(var0 -> var0.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.SERVER_CALLBACKS, var02.get("ScheduledEvents").asStream()), (NBTTagCompound)var02.get("CustomBossEvents").orElseEmptyMap().getValue(), var11, var4, var7, var6, var8);
    }

    @Override
    public NBTTagCompound createTag(IRegistryCustom var0, @Nullable NBTTagCompound var1) {
        this.updatePlayerTag();
        if (var1 == null) {
            var1 = this.loadedPlayerTag;
        }
        NBTTagCompound var2 = new NBTTagCompound();
        this.setTagData(var0, var2, var1);
        return var2;
    }

    private void setTagData(IRegistryCustom var02, NBTTagCompound var12, @Nullable NBTTagCompound var2) {
        NBTTagList var3 = new NBTTagList();
        this.knownServerBrands.stream().map(NBTTagString::valueOf).forEach(var3::add);
        var12.put("ServerBrands", var3);
        var12.putBoolean("WasModded", this.wasModded);
        NBTTagCompound var4 = new NBTTagCompound();
        var4.putString("Name", SharedConstants.getCurrentVersion().getName());
        var4.putInt("Id", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        var4.putBoolean("Snapshot", !SharedConstants.getCurrentVersion().isStable());
        var4.putString("Series", SharedConstants.getCurrentVersion().getDataVersion().getSeries());
        var12.put("Version", var4);
        var12.putInt("DataVersion", SharedConstants.getCurrentVersion().getWorldVersion());
        RegistryOps<NBTBase> var5 = RegistryOps.create(DynamicOpsNBT.INSTANCE, var02);
        GeneratorSettings.encode(var5, this.worldOptions, var02).resultOrPartial(SystemUtils.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var1 -> var12.put(WORLD_GEN_SETTINGS, (NBTBase)var1));
        var12.putInt("GameType", this.settings.gameType().getId());
        var12.putInt("SpawnX", this.xSpawn);
        var12.putInt("SpawnY", this.ySpawn);
        var12.putInt("SpawnZ", this.zSpawn);
        var12.putFloat("SpawnAngle", this.spawnAngle);
        var12.putLong("Time", this.gameTime);
        var12.putLong("DayTime", this.dayTime);
        var12.putLong("LastPlayed", SystemUtils.getEpochMillis());
        var12.putString("LevelName", this.settings.levelName());
        var12.putInt("version", 19133);
        var12.putInt("clearWeatherTime", this.clearWeatherTime);
        var12.putInt("rainTime", this.rainTime);
        var12.putBoolean("raining", this.raining);
        var12.putInt("thunderTime", this.thunderTime);
        var12.putBoolean("thundering", this.thundering);
        var12.putBoolean("hardcore", this.settings.hardcore());
        var12.putBoolean("allowCommands", this.settings.allowCommands());
        var12.putBoolean("initialized", this.initialized);
        this.worldBorder.write(var12);
        var12.putByte("Difficulty", (byte)this.settings.difficulty().getId());
        var12.putBoolean("DifficultyLocked", this.difficultyLocked);
        var12.put("GameRules", this.settings.gameRules().createTag());
        var12.put("DragonFight", this.endDragonFightData);
        if (var2 != null) {
            var12.put(PLAYER, var2);
        }
        DataResult var6 = WorldDataConfiguration.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.settings.getDataConfiguration());
        var6.get().ifLeft(var1 -> var12.merge((NBTTagCompound)var1)).ifRight(var0 -> LOGGER.warn("Failed to encode configuration {}", (Object)var0.message()));
        if (this.customBossEvents != null) {
            var12.put("CustomBossEvents", this.customBossEvents);
        }
        var12.put("ScheduledEvents", this.scheduledEvents.store());
        var12.putInt("WanderingTraderSpawnDelay", this.wanderingTraderSpawnDelay);
        var12.putInt("WanderingTraderSpawnChance", this.wanderingTraderSpawnChance);
        if (this.wanderingTraderId != null) {
            var12.putUUID("WanderingTraderId", this.wanderingTraderId);
        }
    }

    @Override
    public int getXSpawn() {
        return this.xSpawn;
    }

    @Override
    public int getYSpawn() {
        return this.ySpawn;
    }

    @Override
    public int getZSpawn() {
        return this.zSpawn;
    }

    @Override
    public float getSpawnAngle() {
        return this.spawnAngle;
    }

    @Override
    public long getGameTime() {
        return this.gameTime;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    private void updatePlayerTag() {
        if (this.upgradedPlayerTag || this.loadedPlayerTag == null) {
            return;
        }
        if (this.playerDataVersion < SharedConstants.getCurrentVersion().getWorldVersion()) {
            if (this.fixerUpper == null) {
                throw SystemUtils.pauseInIde(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
            }
            this.loadedPlayerTag = GameProfileSerializer.update(this.fixerUpper, DataFixTypes.PLAYER, this.loadedPlayerTag, this.playerDataVersion);
        }
        this.upgradedPlayerTag = true;
    }

    @Override
    public NBTTagCompound getLoadedPlayerTag() {
        this.updatePlayerTag();
        return this.loadedPlayerTag;
    }

    @Override
    public void setXSpawn(int var0) {
        this.xSpawn = var0;
    }

    @Override
    public void setYSpawn(int var0) {
        this.ySpawn = var0;
    }

    @Override
    public void setZSpawn(int var0) {
        this.zSpawn = var0;
    }

    @Override
    public void setSpawnAngle(float var0) {
        this.spawnAngle = var0;
    }

    @Override
    public void setGameTime(long var0) {
        this.gameTime = var0;
    }

    @Override
    public void setDayTime(long var0) {
        this.dayTime = var0;
    }

    @Override
    public void setSpawn(BlockPosition var0, float var1) {
        this.xSpawn = var0.getX();
        this.ySpawn = var0.getY();
        this.zSpawn = var0.getZ();
        this.spawnAngle = var1;
    }

    @Override
    public String getLevelName() {
        return this.settings.levelName();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    @Override
    public void setClearWeatherTime(int var0) {
        this.clearWeatherTime = var0;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean var0) {
        this.thundering = var0;
    }

    @Override
    public int getThunderTime() {
        return this.thunderTime;
    }

    @Override
    public void setThunderTime(int var0) {
        this.thunderTime = var0;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean var0) {
        this.raining = var0;
    }

    @Override
    public int getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(int var0) {
        this.rainTime = var0;
    }

    @Override
    public EnumGamemode getGameType() {
        return this.settings.gameType();
    }

    @Override
    public void setGameType(EnumGamemode var0) {
        this.settings = this.settings.withGameType(var0);
    }

    @Override
    public boolean isHardcore() {
        return this.settings.hardcore();
    }

    @Override
    public boolean getAllowCommands() {
        return this.settings.allowCommands();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean var0) {
        this.initialized = var0;
    }

    @Override
    public GameRules getGameRules() {
        return this.settings.gameRules();
    }

    @Override
    public WorldBorder.c getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public void setWorldBorder(WorldBorder.c var0) {
        this.worldBorder = var0;
    }

    @Override
    public EnumDifficulty getDifficulty() {
        return this.settings.difficulty();
    }

    @Override
    public void setDifficulty(EnumDifficulty var0) {
        this.settings = this.settings.withDifficulty(var0);
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    @Override
    public void setDifficultyLocked(boolean var0) {
        this.difficultyLocked = var0;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> getScheduledEvents() {
        return this.scheduledEvents;
    }

    @Override
    public void fillCrashReportCategory(CrashReportSystemDetails var0, LevelHeightAccessor var1) {
        IWorldDataServer.super.fillCrashReportCategory(var0, var1);
        SaveData.super.fillCrashReportCategory(var0);
    }

    @Override
    public WorldOptions worldGenOptions() {
        return this.worldOptions;
    }

    @Override
    public boolean isFlatWorld() {
        return this.specialWorldProperty == a.FLAT;
    }

    @Override
    public boolean isDebugWorld() {
        return this.specialWorldProperty == a.DEBUG;
    }

    @Override
    public Lifecycle worldGenSettingsLifecycle() {
        return this.worldGenSettingsLifecycle;
    }

    @Override
    public NBTTagCompound endDragonFightData() {
        return this.endDragonFightData;
    }

    @Override
    public void setEndDragonFightData(NBTTagCompound var0) {
        this.endDragonFightData = var0;
    }

    @Override
    public WorldDataConfiguration getDataConfiguration() {
        return this.settings.getDataConfiguration();
    }

    @Override
    public void setDataConfiguration(WorldDataConfiguration var0) {
        this.settings = this.settings.withDataConfiguration(var0);
    }

    @Override
    @Nullable
    public NBTTagCompound getCustomBossEvents() {
        return this.customBossEvents;
    }

    @Override
    public void setCustomBossEvents(@Nullable NBTTagCompound var0) {
        this.customBossEvents = var0;
    }

    @Override
    public int getWanderingTraderSpawnDelay() {
        return this.wanderingTraderSpawnDelay;
    }

    @Override
    public void setWanderingTraderSpawnDelay(int var0) {
        this.wanderingTraderSpawnDelay = var0;
    }

    @Override
    public int getWanderingTraderSpawnChance() {
        return this.wanderingTraderSpawnChance;
    }

    @Override
    public void setWanderingTraderSpawnChance(int var0) {
        this.wanderingTraderSpawnChance = var0;
    }

    @Override
    @Nullable
    public UUID getWanderingTraderId() {
        return this.wanderingTraderId;
    }

    @Override
    public void setWanderingTraderId(UUID var0) {
        this.wanderingTraderId = var0;
    }

    @Override
    public void setModdedInfo(String var0, boolean var1) {
        this.knownServerBrands.add(var0);
        this.wasModded |= var1;
    }

    @Override
    public boolean wasModded() {
        return this.wasModded;
    }

    @Override
    public Set<String> getKnownServerBrands() {
        return ImmutableSet.copyOf(this.knownServerBrands);
    }

    @Override
    public IWorldDataServer overworldData() {
        return this;
    }

    @Override
    public WorldSettings getLevelSettings() {
        return this.settings.copy();
    }

    @Deprecated
    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NONE = new a();
        public static final /* enum */ a FLAT = new a();
        public static final /* enum */ a DEBUG = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{NONE, FLAT, DEBUG};
        }

        static {
            d = a.a();
        }
    }
}

