/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;

public class AmphibiousNodeEvaluator
extends PathfinderNormal {
    private final boolean prefersShallowSwimming;
    private float oldWalkableCost;
    private float oldWaterBorderCost;

    public AmphibiousNodeEvaluator(boolean var0) {
        this.prefersShallowSwimming = var0;
    }

    @Override
    public void prepare(ChunkCache var0, EntityInsentient var1) {
        super.prepare(var0, var1);
        var1.setPathfindingMalus(PathType.WATER, 0.0f);
        this.oldWalkableCost = var1.getPathfindingMalus(PathType.WALKABLE);
        var1.setPathfindingMalus(PathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = var1.getPathfindingMalus(PathType.WATER_BORDER);
        var1.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    @Override
    public void done() {
        this.mob.setPathfindingMalus(PathType.WALKABLE, this.oldWalkableCost);
        this.mob.setPathfindingMalus(PathType.WATER_BORDER, this.oldWaterBorderCost);
        super.done();
    }

    @Override
    public PathPoint getStart() {
        if (!this.mob.isInWater()) {
            return super.getStart();
        }
        return this.getStartNode(new BlockPosition(MathHelper.floor(this.mob.getBoundingBox().minX), MathHelper.floor(this.mob.getBoundingBox().minY + 0.5), MathHelper.floor(this.mob.getBoundingBox().minZ)));
    }

    @Override
    public PathDestination getGoal(double var0, double var2, double var4) {
        return this.getTargetFromNode(this.getNode(MathHelper.floor(var0), MathHelper.floor(var2 + 0.5), MathHelper.floor(var4)));
    }

    @Override
    public int getNeighbors(PathPoint[] var0, PathPoint var1) {
        int var2 = super.getNeighbors(var0, var1);
        PathType var4 = this.getCachedBlockType(this.mob, var1.x, var1.y + 1, var1.z);
        PathType var5 = this.getCachedBlockType(this.mob, var1.x, var1.y, var1.z);
        int var3 = this.mob.getPathfindingMalus(var4) >= 0.0f && var5 != PathType.STICKY_HONEY ? MathHelper.floor(Math.max(1.0f, this.mob.maxUpStep)) : 0;
        double var6 = this.getFloorLevel(new BlockPosition(var1.x, var1.y, var1.z));
        PathPoint var8 = this.findAcceptedNode(var1.x, var1.y + 1, var1.z, Math.max(0, var3 - 1), var6, EnumDirection.UP, var5);
        PathPoint var9 = this.findAcceptedNode(var1.x, var1.y - 1, var1.z, var3, var6, EnumDirection.DOWN, var5);
        if (this.isVerticalNeighborValid(var8, var1)) {
            var0[var2++] = var8;
        }
        if (this.isVerticalNeighborValid(var9, var1) && var5 != PathType.TRAPDOOR) {
            var0[var2++] = var9;
        }
        for (int var10 = 0; var10 < var2; ++var10) {
            PathPoint var11 = var0[var10];
            if (var11.type != PathType.WATER || !this.prefersShallowSwimming || var11.y >= this.mob.level.getSeaLevel() - 10) continue;
            var11.costMalus += 1.0f;
        }
        return var2;
    }

    private boolean isVerticalNeighborValid(@Nullable PathPoint var0, PathPoint var1) {
        return this.isNeighborValid(var0, var1) && var0.type == PathType.WATER;
    }

    @Override
    protected boolean isAmphibious() {
        return true;
    }

    @Override
    public PathType getBlockPathType(IBlockAccess var0, int var1, int var2, int var3) {
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        PathType var5 = AmphibiousNodeEvaluator.getBlockPathTypeRaw(var0, var4.set(var1, var2, var3));
        if (var5 == PathType.WATER) {
            for (EnumDirection var9 : EnumDirection.values()) {
                PathType var10 = AmphibiousNodeEvaluator.getBlockPathTypeRaw(var0, var4.set(var1, var2, var3).move(var9));
                if (var10 != PathType.BLOCKED) continue;
                return PathType.WATER_BORDER;
            }
            return PathType.WATER;
        }
        return AmphibiousNodeEvaluator.getBlockPathTypeStatic(var0, var4);
    }
}

