/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;

public class LightEngineStorageSky
extends LightEngineStorage<a> {
    private static final EnumDirection[] HORIZONTALS = new EnumDirection[]{EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.WEST, EnumDirection.EAST};
    private final LongSet sectionsWithSources = new LongOpenHashSet();
    private final LongSet sectionsToAddSourcesTo = new LongOpenHashSet();
    private final LongSet sectionsToRemoveSourcesFrom = new LongOpenHashSet();
    private final LongSet columnsWithSkySources = new LongOpenHashSet();
    private volatile boolean hasSourceInconsistencies;

    protected LightEngineStorageSky(ILightAccess var0) {
        super(EnumSkyBlock.SKY, var0, new a((Long2ObjectOpenHashMap<NibbleArray>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    protected int getLightValue(long var0) {
        return this.getLightValue(var0, false);
    }

    protected int getLightValue(long var0, boolean var2) {
        long var3 = SectionPosition.blockToSection(var0);
        int var5 = SectionPosition.y(var3);
        a var6 = var2 ? (a)this.updatingSectionData : (a)this.visibleSectionData;
        int var7 = var6.topSections.get(SectionPosition.getZeroNode(var3));
        if (var7 == var6.currentLowestY || var5 >= var7) {
            if (var2 && !this.lightOnInSection(var3)) {
                return 0;
            }
            return 15;
        }
        NibbleArray var8 = this.getDataLayer(var6, var3);
        if (var8 == null) {
            var0 = BlockPosition.getFlatIndex(var0);
            while (var8 == null) {
                if (++var5 >= var7) {
                    return 15;
                }
                var0 = BlockPosition.offset(var0, 0, 16, 0);
                var3 = SectionPosition.offset(var3, EnumDirection.UP);
                var8 = this.getDataLayer(var6, var3);
            }
        }
        return var8.get(SectionPosition.sectionRelative(BlockPosition.getX(var0)), SectionPosition.sectionRelative(BlockPosition.getY(var0)), SectionPosition.sectionRelative(BlockPosition.getZ(var0)));
    }

    @Override
    protected void onNodeAdded(long var0) {
        long var3;
        int var5;
        int var2 = SectionPosition.y(var0);
        if (((a)this.updatingSectionData).currentLowestY > var2) {
            ((a)this.updatingSectionData).currentLowestY = var2;
            ((a)this.updatingSectionData).topSections.defaultReturnValue(((a)this.updatingSectionData).currentLowestY);
        }
        if ((var5 = ((a)this.updatingSectionData).topSections.get(var3 = SectionPosition.getZeroNode(var0))) < var2 + 1) {
            ((a)this.updatingSectionData).topSections.put(var3, var2 + 1);
            if (this.columnsWithSkySources.contains(var3)) {
                this.queueAddSource(var0);
                if (var5 > ((a)this.updatingSectionData).currentLowestY) {
                    long var6 = SectionPosition.asLong(SectionPosition.x(var0), var5 - 1, SectionPosition.z(var0));
                    this.queueRemoveSource(var6);
                }
                this.recheckInconsistencyFlag();
            }
        }
    }

    private void queueRemoveSource(long var0) {
        this.sectionsToRemoveSourcesFrom.add(var0);
        this.sectionsToAddSourcesTo.remove(var0);
    }

    private void queueAddSource(long var0) {
        this.sectionsToAddSourcesTo.add(var0);
        this.sectionsToRemoveSourcesFrom.remove(var0);
    }

    private void recheckInconsistencyFlag() {
        this.hasSourceInconsistencies = !this.sectionsToAddSourcesTo.isEmpty() || !this.sectionsToRemoveSourcesFrom.isEmpty();
    }

    @Override
    protected void onNodeRemoved(long var0) {
        long var2 = SectionPosition.getZeroNode(var0);
        boolean var4 = this.columnsWithSkySources.contains(var2);
        if (var4) {
            this.queueRemoveSource(var0);
        }
        int var5 = SectionPosition.y(var0);
        if (((a)this.updatingSectionData).topSections.get(var2) == var5 + 1) {
            long var6 = var0;
            while (!this.storingLightForSection(var6) && this.hasSectionsBelow(var5)) {
                --var5;
                var6 = SectionPosition.offset(var6, EnumDirection.DOWN);
            }
            if (this.storingLightForSection(var6)) {
                ((a)this.updatingSectionData).topSections.put(var2, var5 + 1);
                if (var4) {
                    this.queueAddSource(var6);
                }
            } else {
                ((a)this.updatingSectionData).topSections.remove(var2);
            }
        }
        if (var4) {
            this.recheckInconsistencyFlag();
        }
    }

    @Override
    protected void enableLightSources(long var0, boolean var2) {
        this.runAllUpdates();
        if (var2 && this.columnsWithSkySources.add(var0)) {
            int var3 = ((a)this.updatingSectionData).topSections.get(var0);
            if (var3 != ((a)this.updatingSectionData).currentLowestY) {
                long var4 = SectionPosition.asLong(SectionPosition.x(var0), var3 - 1, SectionPosition.z(var0));
                this.queueAddSource(var4);
                this.recheckInconsistencyFlag();
            }
        } else if (!var2) {
            this.columnsWithSkySources.remove(var0);
        }
    }

    @Override
    protected boolean hasInconsistencies() {
        return super.hasInconsistencies() || this.hasSourceInconsistencies;
    }

    @Override
    protected NibbleArray createDataLayer(long var0) {
        NibbleArray var6;
        NibbleArray var2 = (NibbleArray)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        long var3 = SectionPosition.offset(var0, EnumDirection.UP);
        int var5 = ((a)this.updatingSectionData).topSections.get(SectionPosition.getZeroNode(var0));
        if (var5 == ((a)this.updatingSectionData).currentLowestY || SectionPosition.y(var3) >= var5) {
            return new NibbleArray();
        }
        while ((var6 = this.getDataLayer(var3, true)) == null) {
            var3 = SectionPosition.offset(var3, EnumDirection.UP);
        }
        return LightEngineStorageSky.repeatFirstLayer(var6);
    }

    private static NibbleArray repeatFirstLayer(NibbleArray var0) {
        if (var0.isEmpty()) {
            return new NibbleArray();
        }
        byte[] var1 = var0.getData();
        byte[] var2 = new byte[2048];
        for (int var3 = 0; var3 < 16; ++var3) {
            System.arraycopy(var1, 0, var2, var3 * 128, 128);
        }
        return new NibbleArray(var2);
    }

    @Override
    protected void markNewInconsistencies(LightEngineLayer<a, ?> var0, boolean var1, boolean var2) {
        int var7;
        int var6;
        long var4;
        LongIterator longIterator;
        super.markNewInconsistencies(var0, var1, var2);
        if (!var1) {
            return;
        }
        if (!this.sectionsToAddSourcesTo.isEmpty()) {
            longIterator = this.sectionsToAddSourcesTo.iterator();
            while (longIterator.hasNext()) {
                int var8;
                var4 = (Long)longIterator.next();
                var6 = this.getLevel(var4);
                if (var6 == 2 || this.sectionsToRemoveSourcesFrom.contains(var4) || !this.sectionsWithSources.add(var4)) continue;
                if (var6 == 1) {
                    long var14;
                    this.clearQueuedSectionBlocks(var0, var4);
                    if (this.changedSections.add(var4)) {
                        ((a)this.updatingSectionData).copyDataLayer(var4);
                    }
                    Arrays.fill(this.getDataLayer(var4, true).getData(), (byte)-1);
                    var7 = SectionPosition.sectionToBlockCoord(SectionPosition.x(var4));
                    var8 = SectionPosition.sectionToBlockCoord(SectionPosition.y(var4));
                    int var9 = SectionPosition.sectionToBlockCoord(SectionPosition.z(var4));
                    for (EnumDirection var13 : HORIZONTALS) {
                        var14 = SectionPosition.offset(var4, var13);
                        if (!this.sectionsToRemoveSourcesFrom.contains(var14) && (this.sectionsWithSources.contains(var14) || this.sectionsToAddSourcesTo.contains(var14)) || !this.storingLightForSection(var14)) continue;
                        for (int var16 = 0; var16 < 16; ++var16) {
                            for (int var17 = 0; var17 < 16; ++var17) {
                                long var18;
                                long var20 = switch (var13) {
                                    case EnumDirection.NORTH -> {
                                        var18 = BlockPosition.asLong(var7 + var16, var8 + var17, var9);
                                        yield BlockPosition.asLong(var7 + var16, var8 + var17, var9 - 1);
                                    }
                                    case EnumDirection.SOUTH -> {
                                        var18 = BlockPosition.asLong(var7 + var16, var8 + var17, var9 + 16 - 1);
                                        yield BlockPosition.asLong(var7 + var16, var8 + var17, var9 + 16);
                                    }
                                    case EnumDirection.WEST -> {
                                        var18 = BlockPosition.asLong(var7, var8 + var16, var9 + var17);
                                        yield BlockPosition.asLong(var7 - 1, var8 + var16, var9 + var17);
                                    }
                                    default -> {
                                        var18 = BlockPosition.asLong(var7 + 16 - 1, var8 + var16, var9 + var17);
                                        yield BlockPosition.asLong(var7 + 16, var8 + var16, var9 + var17);
                                    }
                                };
                                var0.checkEdge(var18, var20, var0.computeLevelFromNeighbor(var18, var20, 0), true);
                            }
                        }
                    }
                    for (int var10 = 0; var10 < 16; ++var10) {
                        for (int var11 = 0; var11 < 16; ++var11) {
                            long var12 = BlockPosition.asLong(SectionPosition.sectionToBlockCoord(SectionPosition.x(var4), var10), SectionPosition.sectionToBlockCoord(SectionPosition.y(var4)), SectionPosition.sectionToBlockCoord(SectionPosition.z(var4), var11));
                            var14 = BlockPosition.asLong(SectionPosition.sectionToBlockCoord(SectionPosition.x(var4), var10), SectionPosition.sectionToBlockCoord(SectionPosition.y(var4)) - 1, SectionPosition.sectionToBlockCoord(SectionPosition.z(var4), var11));
                            var0.checkEdge(var12, var14, var0.computeLevelFromNeighbor(var12, var14, 0), true);
                        }
                    }
                    continue;
                }
                for (var7 = 0; var7 < 16; ++var7) {
                    for (var8 = 0; var8 < 16; ++var8) {
                        long var9 = BlockPosition.asLong(SectionPosition.sectionToBlockCoord(SectionPosition.x(var4), var7), SectionPosition.sectionToBlockCoord(SectionPosition.y(var4), 15), SectionPosition.sectionToBlockCoord(SectionPosition.z(var4), var8));
                        var0.checkEdge(Long.MAX_VALUE, var9, 0, true);
                    }
                }
            }
        }
        this.sectionsToAddSourcesTo.clear();
        if (!this.sectionsToRemoveSourcesFrom.isEmpty()) {
            longIterator = this.sectionsToRemoveSourcesFrom.iterator();
            while (longIterator.hasNext()) {
                var4 = (Long)longIterator.next();
                if (!this.sectionsWithSources.remove(var4) || !this.storingLightForSection(var4)) continue;
                for (var6 = 0; var6 < 16; ++var6) {
                    for (var7 = 0; var7 < 16; ++var7) {
                        long var8 = BlockPosition.asLong(SectionPosition.sectionToBlockCoord(SectionPosition.x(var4), var6), SectionPosition.sectionToBlockCoord(SectionPosition.y(var4), 15), SectionPosition.sectionToBlockCoord(SectionPosition.z(var4), var7));
                        var0.checkEdge(Long.MAX_VALUE, var8, 15, false);
                    }
                }
            }
        }
        this.sectionsToRemoveSourcesFrom.clear();
        this.hasSourceInconsistencies = false;
    }

    protected boolean hasSectionsBelow(int var0) {
        return var0 >= ((a)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long var0) {
        long var2 = SectionPosition.getZeroNode(var0);
        int var4 = ((a)this.updatingSectionData).topSections.get(var2);
        return var4 == ((a)this.updatingSectionData).currentLowestY || SectionPosition.y(var0) >= var4;
    }

    protected boolean lightOnInSection(long var0) {
        long var2 = SectionPosition.getZeroNode(var0);
        return this.columnsWithSkySources.contains(var2);
    }

    protected static final class a
    extends LightEngineStorageArray<a> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public a(Long2ObjectOpenHashMap<NibbleArray> var0, Long2IntOpenHashMap var1, int var2) {
            super(var0);
            this.topSections = var1;
            var1.defaultReturnValue(var2);
            this.currentLowestY = var2;
        }

        @Override
        public a copy() {
            return new a((Long2ObjectOpenHashMap<NibbleArray>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }

        @Override
        public /* synthetic */ LightEngineStorageArray copy() {
            return this.copy();
        }
    }
}

