/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class DefinedStructureProcessorBlockAge
extends DefinedStructureProcessor {
    public static final Codec<DefinedStructureProcessorBlockAge> CODEC = Codec.FLOAT.fieldOf("mossiness").xmap(DefinedStructureProcessorBlockAge::new, var0 -> Float.valueOf(var0.mossiness)).codec();
    private static final float PROBABILITY_OF_REPLACING_FULL_BLOCK = 0.5f;
    private static final float PROBABILITY_OF_REPLACING_STAIRS = 0.5f;
    private static final float PROBABILITY_OF_REPLACING_OBSIDIAN = 0.15f;
    private static final IBlockData[] NON_MOSSY_REPLACEMENTS = new IBlockData[]{Blocks.STONE_SLAB.defaultBlockState(), Blocks.STONE_BRICK_SLAB.defaultBlockState()};
    private final float mossiness;

    public DefinedStructureProcessorBlockAge(float var0) {
        this.mossiness = var0;
    }

    @Override
    @Nullable
    public DefinedStructure.BlockInfo processBlock(IWorldReader var0, BlockPosition var1, BlockPosition var2, DefinedStructure.BlockInfo var3, DefinedStructure.BlockInfo var4, DefinedStructureInfo var5) {
        RandomSource var6 = var5.getRandom(var4.pos);
        IBlockData var7 = var4.state;
        BlockPosition var8 = var4.pos;
        IBlockData var9 = null;
        if (var7.is(Blocks.STONE_BRICKS) || var7.is(Blocks.STONE) || var7.is(Blocks.CHISELED_STONE_BRICKS)) {
            var9 = this.maybeReplaceFullStoneBlock(var6);
        } else if (var7.is(TagsBlock.STAIRS)) {
            var9 = this.maybeReplaceStairs(var6, var4.state);
        } else if (var7.is(TagsBlock.SLABS)) {
            var9 = this.maybeReplaceSlab(var6);
        } else if (var7.is(TagsBlock.WALLS)) {
            var9 = this.maybeReplaceWall(var6);
        } else if (var7.is(Blocks.OBSIDIAN)) {
            var9 = this.maybeReplaceObsidian(var6);
        }
        if (var9 != null) {
            return new DefinedStructure.BlockInfo(var8, var9, var4.nbt);
        }
        return var4;
    }

    @Nullable
    private IBlockData maybeReplaceFullStoneBlock(RandomSource var0) {
        if (var0.nextFloat() >= 0.5f) {
            return null;
        }
        IBlockData[] var1 = new IBlockData[]{Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), DefinedStructureProcessorBlockAge.getRandomFacingStairs(var0, Blocks.STONE_BRICK_STAIRS)};
        IBlockData[] var2 = new IBlockData[]{Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), DefinedStructureProcessorBlockAge.getRandomFacingStairs(var0, Blocks.MOSSY_STONE_BRICK_STAIRS)};
        return this.getRandomBlock(var0, var1, var2);
    }

    @Nullable
    private IBlockData maybeReplaceStairs(RandomSource var0, IBlockData var1) {
        EnumDirection var2 = var1.getValue(BlockStairs.FACING);
        BlockPropertyHalf var3 = var1.getValue(BlockStairs.HALF);
        if (var0.nextFloat() >= 0.5f) {
            return null;
        }
        IBlockData[] var4 = new IBlockData[]{(IBlockData)((IBlockData)Blocks.MOSSY_STONE_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, var2)).setValue(BlockStairs.HALF, var3), Blocks.MOSSY_STONE_BRICK_SLAB.defaultBlockState()};
        return this.getRandomBlock(var0, NON_MOSSY_REPLACEMENTS, var4);
    }

    @Nullable
    private IBlockData maybeReplaceSlab(RandomSource var0) {
        if (var0.nextFloat() < this.mossiness) {
            return Blocks.MOSSY_STONE_BRICK_SLAB.defaultBlockState();
        }
        return null;
    }

    @Nullable
    private IBlockData maybeReplaceWall(RandomSource var0) {
        if (var0.nextFloat() < this.mossiness) {
            return Blocks.MOSSY_STONE_BRICK_WALL.defaultBlockState();
        }
        return null;
    }

    @Nullable
    private IBlockData maybeReplaceObsidian(RandomSource var0) {
        if (var0.nextFloat() < 0.15f) {
            return Blocks.CRYING_OBSIDIAN.defaultBlockState();
        }
        return null;
    }

    private static IBlockData getRandomFacingStairs(RandomSource var0, Block var1) {
        return (IBlockData)((IBlockData)var1.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var0))).setValue(BlockStairs.HALF, SystemUtils.getRandom(BlockPropertyHalf.values(), var0));
    }

    private IBlockData getRandomBlock(RandomSource var0, IBlockData[] var1, IBlockData[] var2) {
        if (var0.nextFloat() < this.mossiness) {
            return DefinedStructureProcessorBlockAge.getRandomBlock(var0, var2);
        }
        return DefinedStructureProcessorBlockAge.getRandomBlock(var0, var1);
    }

    private static IBlockData getRandomBlock(RandomSource var0, IBlockData[] var1) {
        return var1[var0.nextInt(var1.length)];
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> getType() {
        return DefinedStructureStructureProcessorType.BLOCK_AGE;
    }
}

