/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public abstract class StructurePlacement {
    public static final Codec<StructurePlacement> CODEC = BuiltInRegistries.STRUCTURE_PLACEMENT.byNameCodec().dispatch(StructurePlacement::type, StructurePlacementType::codec);
    private static final int HIGHLY_ARBITRARY_RANDOM_SALT = 10387320;
    public final BaseBlockPosition locateOffset;
    public final c frequencyReductionMethod;
    public final float frequency;
    public final int salt;
    public final Optional<a> exclusionZone;

    protected static <S extends StructurePlacement> Products.P5<RecordCodecBuilder.Mu<S>, BaseBlockPosition, c, Float, Integer, Optional<a>> placementCodec(RecordCodecBuilder.Instance<S> var0) {
        return var0.group((App)BaseBlockPosition.offsetCodec(16).optionalFieldOf("locate_offset", (Object)BaseBlockPosition.ZERO).forGetter(StructurePlacement::locateOffset), (App)c.CODEC.optionalFieldOf("frequency_reduction_method", (Object)c.DEFAULT).forGetter(StructurePlacement::frequencyReductionMethod), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(StructurePlacement::frequency), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(StructurePlacement::salt), (App)a.CODEC.optionalFieldOf("exclusion_zone").forGetter(StructurePlacement::exclusionZone));
    }

    protected StructurePlacement(BaseBlockPosition var0, c var1, float var2, int var3, Optional<a> var4) {
        this.locateOffset = var0;
        this.frequencyReductionMethod = var1;
        this.frequency = var2;
        this.salt = var3;
        this.exclusionZone = var4;
    }

    protected BaseBlockPosition locateOffset() {
        return this.locateOffset;
    }

    protected c frequencyReductionMethod() {
        return this.frequencyReductionMethod;
    }

    protected float frequency() {
        return this.frequency;
    }

    protected int salt() {
        return this.salt;
    }

    protected Optional<a> exclusionZone() {
        return this.exclusionZone;
    }

    public boolean isStructureChunk(ChunkGeneratorStructureState var0, int var1, int var2) {
        if (!this.isPlacementChunk(var0, var1, var2)) {
            return false;
        }
        if (this.frequency < 1.0f && !this.frequencyReductionMethod.shouldGenerate(var0.getLevelSeed(), this.salt, var1, var2, this.frequency)) {
            return false;
        }
        return !this.exclusionZone.isPresent() || !this.exclusionZone.get().isPlacementForbidden(var0, var1, var2);
    }

    protected abstract boolean isPlacementChunk(ChunkGeneratorStructureState var1, int var2, int var3);

    public BlockPosition getLocatePos(ChunkCoordIntPair var0) {
        return new BlockPosition(var0.getMinBlockX(), 0, var0.getMinBlockZ()).offset(this.locateOffset());
    }

    public abstract StructurePlacementType<?> type();

    private static boolean probabilityReducer(long var0, int var2, int var3, int var4, float var5) {
        SeededRandom var6 = new SeededRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureWithSalt(var0, var2, var3, var4);
        return var6.nextFloat() < var5;
    }

    private static boolean legacyProbabilityReducerWithDouble(long var0, int var2, int var3, int var4, float var5) {
        SeededRandom var6 = new SeededRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureSeed(var0, var3, var4);
        return var6.nextDouble() < (double)var5;
    }

    private static boolean legacyArbitrarySaltProbabilityReducer(long var0, int var2, int var3, int var4, float var5) {
        SeededRandom var6 = new SeededRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureWithSalt(var0, var3, var4, 10387320);
        return var6.nextFloat() < var5;
    }

    private static boolean legacyPillagerOutpostReducer(long var0, int var2, int var3, int var4, float var5) {
        int var6 = var3 >> 4;
        int var7 = var4 >> 4;
        SeededRandom var8 = new SeededRandom(new LegacyRandomSource(0L));
        var8.setSeed((long)(var6 ^ var7 << 4) ^ var0);
        var8.nextInt();
        return var8.nextInt((int)(1.0f / var5)) == 0;
    }

    public static final class c
    extends Enum<c>
    implements INamable {
        public static final /* enum */ c DEFAULT = new c("default", StructurePlacement::probabilityReducer);
        public static final /* enum */ c LEGACY_TYPE_1 = new c("legacy_type_1", StructurePlacement::legacyPillagerOutpostReducer);
        public static final /* enum */ c LEGACY_TYPE_2 = new c("legacy_type_2", StructurePlacement::legacyArbitrarySaltProbabilityReducer);
        public static final /* enum */ c LEGACY_TYPE_3 = new c("legacy_type_3", StructurePlacement::legacyProbabilityReducerWithDouble);
        public static final Codec<c> CODEC;
        private final String name;
        private final b reducer;
        private static final /* synthetic */ c[] h;

        public static c[] values() {
            return (c[])h.clone();
        }

        public static c valueOf(String var0) {
            return Enum.valueOf(c.class, var0);
        }

        private c(String var2, b var3) {
            this.name = var2;
            this.reducer = var3;
        }

        public boolean shouldGenerate(long var0, int var2, int var3, int var4, float var5) {
            return this.reducer.shouldGenerate(var0, var2, var3, var4, var5);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{DEFAULT, LEGACY_TYPE_1, LEGACY_TYPE_2, LEGACY_TYPE_3};
        }

        static {
            h = c.a();
            CODEC = INamable.fromEnum(c::values);
        }
    }

    @Deprecated
    public record a(Holder<StructureSet> otherSet, int chunkCount) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryFileCodec.create(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC, false).fieldOf("other_set").forGetter(a::otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(a::chunkCount)).apply((Applicative)var0, a::new));

        boolean isPlacementForbidden(ChunkGeneratorStructureState var0, int var1, int var2) {
            return var0.hasStructureChunkInRange(this.otherSet, var1, var2, this.chunkCount);
        }
    }

    @FunctionalInterface
    public static interface b {
        public boolean shouldGenerate(long var1, int var3, int var4, int var5, float var6);
    }
}

