/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.presets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;

public class WorldPreset {
    public static final Codec<WorldPreset> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.unboundedMap(ResourceKey.codec(Registries.LEVEL_STEM), WorldDimension.CODEC).fieldOf("dimensions").forGetter(var0 -> var0.dimensions)).apply((Applicative)var02, WorldPreset::new)).flatXmap(WorldPreset::requireOverworld, WorldPreset::requireOverworld);
    public static final Codec<Holder<WorldPreset>> CODEC = RegistryFileCodec.create(Registries.WORLD_PRESET, DIRECT_CODEC);
    private final Map<ResourceKey<WorldDimension>, WorldDimension> dimensions;

    public WorldPreset(Map<ResourceKey<WorldDimension>, WorldDimension> var0) {
        this.dimensions = var0;
    }

    private IRegistry<WorldDimension> createRegistry() {
        RegistryMaterials<WorldDimension> var0 = new RegistryMaterials<WorldDimension>(Registries.LEVEL_STEM, Lifecycle.experimental());
        WorldDimensions.keysInOrder(this.dimensions.keySet().stream()).forEach(var1 -> {
            WorldDimension var2 = this.dimensions.get(var1);
            if (var2 != null) {
                var0.register((ResourceKey<WorldDimension>)var1, var2, Lifecycle.stable());
            }
        });
        return var0.freeze();
    }

    public WorldDimensions createWorldDimensions() {
        return new WorldDimensions(this.createRegistry());
    }

    public Optional<WorldDimension> overworld() {
        return Optional.ofNullable(this.dimensions.get(WorldDimension.OVERWORLD));
    }

    private static DataResult<WorldPreset> requireOverworld(WorldPreset var0) {
        if (var0.overworld().isEmpty()) {
            return DataResult.error((String)"Missing overworld dimension");
        }
        return DataResult.success((Object)var0, (Lifecycle)Lifecycle.stable());
    }
}

