/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class WorldGenFeatureTreeAlterGround
extends WorldGenFeatureTree {
    public static final Codec<WorldGenFeatureTreeAlterGround> CODEC = WorldGenFeatureStateProvider.CODEC.fieldOf("provider").xmap(WorldGenFeatureTreeAlterGround::new, var0 -> var0.provider).codec();
    private final WorldGenFeatureStateProvider provider;

    public WorldGenFeatureTreeAlterGround(WorldGenFeatureStateProvider var0) {
        this.provider = var0;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.ALTER_GROUND;
    }

    @Override
    public void place(WorldGenFeatureTree.a var0) {
        ArrayList var12 = Lists.newArrayList();
        ObjectArrayList<BlockPosition> var2 = var0.roots();
        ObjectArrayList<BlockPosition> var3 = var0.logs();
        if (var2.isEmpty()) {
            var12.addAll(var3);
        } else if (!var3.isEmpty() && ((BlockPosition)var2.get(0)).getY() == ((BlockPosition)var3.get(0)).getY()) {
            var12.addAll(var3);
            var12.addAll(var2);
        } else {
            var12.addAll(var2);
        }
        if (var12.isEmpty()) {
            return;
        }
        int var4 = ((BlockPosition)var12.get(0)).getY();
        var12.stream().filter(var1 -> var1.getY() == var4).forEach(var1 -> {
            this.placeCircle(var0, var1.west().north());
            this.placeCircle(var0, var1.east(2).north());
            this.placeCircle(var0, var1.west().south(2));
            this.placeCircle(var0, var1.east(2).south(2));
            for (int var2 = 0; var2 < 5; ++var2) {
                int var3 = var0.random().nextInt(64);
                int var4 = var3 % 8;
                int var5 = var3 / 8;
                if (var4 != 0 && var4 != 7 && var5 != 0 && var5 != 7) continue;
                this.placeCircle(var0, var1.offset(-3 + var4, 0, -3 + var5));
            }
        });
    }

    private void placeCircle(WorldGenFeatureTree.a var0, BlockPosition var1) {
        for (int var2 = -2; var2 <= 2; ++var2) {
            for (int var3 = -2; var3 <= 2; ++var3) {
                if (Math.abs(var2) == 2 && Math.abs(var3) == 2) continue;
                this.placeBlockAt(var0, var1.offset(var2, 0, var3));
            }
        }
    }

    private void placeBlockAt(WorldGenFeatureTree.a var0, BlockPosition var1) {
        for (int var2 = 2; var2 >= -3; --var2) {
            BlockPosition var3 = var1.above(var2);
            if (WorldGenerator.isGrassOrDirt(var0.level(), var3)) {
                var0.setBlock(var3, this.provider.getState(var0.random(), var1));
                break;
            }
            if (!var0.isAir(var3) && var2 < 0) break;
        }
    }
}

