/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class WorldGenFoilagePlacerPine
extends WorldGenFoilagePlacer {
    public static final Codec<WorldGenFoilagePlacerPine> CODEC = RecordCodecBuilder.create(var02 -> WorldGenFoilagePlacerPine.foliagePlacerParts(var02).and((App)IntProvider.codec(0, 24).fieldOf("height").forGetter(var0 -> var0.height)).apply((Applicative)var02, WorldGenFoilagePlacerPine::new));
    private final IntProvider height;

    public WorldGenFoilagePlacerPine(IntProvider var0, IntProvider var1, IntProvider var2) {
        super(var0, var1);
        this.height = var2;
    }

    @Override
    protected WorldGenFoilagePlacers<?> type() {
        return WorldGenFoilagePlacers.PINE_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, int var4, WorldGenFoilagePlacer.a var5, int var6, int var7, int var8) {
        int var9 = 0;
        for (int var10 = var8; var10 >= var8 - var6; --var10) {
            this.placeLeavesRow(var0, var1, var2, var3, var5.pos(), var9, var10, var5.doubleTrunk());
            if (var9 >= 1 && var10 == var8 - var6 + 1) {
                --var9;
                continue;
            }
            if (var9 >= var7 + var5.radiusOffset()) continue;
            ++var9;
        }
    }

    @Override
    public int foliageRadius(RandomSource var0, int var1) {
        return super.foliageRadius(var0, var1) + var0.nextInt(Math.max(var1 + 1, 1));
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, WorldGenFeatureTreeConfiguration var2) {
        return this.height.sample(var0);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        return var1 == var4 && var3 == var4 && var4 > 0;
    }
}

