/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public class LegacyRandomSource
implements BitRandomSource {
    private static final int MODULUS_BITS = 48;
    private static final long MODULUS_MASK = 0xFFFFFFFFFFFFL;
    private static final long MULTIPLIER = 25214903917L;
    private static final long INCREMENT = 11L;
    private final AtomicLong seed = new AtomicLong();
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian(this);

    public LegacyRandomSource(long var0) {
        this.setSeed(var0);
    }

    @Override
    public RandomSource fork() {
        return new LegacyRandomSource(this.nextLong());
    }

    @Override
    public PositionalRandomFactory forkPositional() {
        return new a(this.nextLong());
    }

    @Override
    public void setSeed(long var0) {
        if (!this.seed.compareAndSet(this.seed.get(), (var0 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.makeThreadingException("LegacyRandomSource", null);
        }
        this.gaussianSource.reset();
    }

    @Override
    public int next(int var0) {
        long var3;
        long var1 = this.seed.get();
        if (!this.seed.compareAndSet(var1, var3 = var1 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.makeThreadingException("LegacyRandomSource", null);
        }
        return (int)(var3 >> 48 - var0);
    }

    @Override
    public double nextGaussian() {
        return this.gaussianSource.nextGaussian();
    }

    public static class a
    implements PositionalRandomFactory {
        private final long seed;

        public a(long var0) {
            this.seed = var0;
        }

        @Override
        public RandomSource at(int var0, int var1, int var2) {
            long var3 = MathHelper.getSeed(var0, var1, var2);
            long var5 = var3 ^ this.seed;
            return new LegacyRandomSource(var5);
        }

        @Override
        public RandomSource fromHashOf(String var0) {
            int var1 = var0.hashCode();
            return new LegacyRandomSource((long)var1 ^ this.seed);
        }

        @Override
        @VisibleForTesting
        public void parityConfigString(StringBuilder var0) {
            var0.append("LegacyPositionalRandomFactory{").append(this.seed).append("}");
        }
    }
}

