/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final Codec<ChunkGeneratorAbstract> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)WorldChunkManager.CODEC.fieldOf("biome_source").forGetter(var0 -> var0.biomeSource), (App)GeneratorSettingBase.CODEC.fieldOf("settings").forGetter(var0 -> var0.settings)).apply((Applicative)var02, var02.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData AIR = Blocks.AIR.defaultBlockState();
    public final Holder<GeneratorSettingBase> settings;
    private final Supplier<Aquifer.a> globalFluidPicker;

    public ChunkGeneratorAbstract(WorldChunkManager var0, Holder<GeneratorSettingBase> var1) {
        super(var0);
        this.settings = var1;
        this.globalFluidPicker = Suppliers.memoize(() -> ChunkGeneratorAbstract.createFluidPicker((GeneratorSettingBase)var1.value()));
    }

    private static Aquifer.a createFluidPicker(GeneratorSettingBase var0) {
        Aquifer.b var1 = new Aquifer.b(-54, Blocks.LAVA.defaultBlockState());
        int var2 = var0.seaLevel();
        Aquifer.b var3 = new Aquifer.b(var2, var0.defaultFluid());
        Aquifer.b var42 = new Aquifer.b(DimensionManager.MIN_Y * 2, Blocks.AIR.defaultBlockState());
        return (var4, var5, var6) -> {
            if (var5 < Math.min(-54, var2)) {
                return var1;
            }
            return var3;
        };
    }

    @Override
    public CompletableFuture<IChunkAccess> createBiomes(Executor var0, RandomState var1, Blender var2, StructureManager var3, IChunkAccess var4) {
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("init_biomes", () -> {
            this.doCreateBiomes(var2, var1, var3, var4);
            return var4;
        }), SystemUtils.backgroundExecutor());
    }

    private void doCreateBiomes(Blender var0, RandomState var1, StructureManager var2, IChunkAccess var32) {
        NoiseChunk var4 = var32.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var2, var0, var1));
        BiomeResolver var5 = BelowZeroRetrogen.getBiomeResolver(var0.getBiomeResolver(this.biomeSource), var32);
        var32.fillBiomesFromNoise(var5, var4.cachedClimateSampler(var1.router(), this.settings.value().spawnTarget()));
    }

    private NoiseChunk createNoiseChunk(IChunkAccess var0, StructureManager var1, Blender var2, RandomState var3) {
        return NoiseChunk.forChunk(var0, var3, Beardifier.forStructuresInChunk(var1, var0.getPos()), this.settings.value(), this.globalFluidPicker.get(), var2);
    }

    @Override
    protected Codec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public Holder<GeneratorSettingBase> generatorSettings() {
        return this.settings;
    }

    public boolean stable(ResourceKey<GeneratorSettingBase> var0) {
        return this.settings.is(var0);
    }

    @Override
    public int getBaseHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3, RandomState var4) {
        return this.iterateNoiseColumn(var3, var4, var0, var1, null, var2.isOpaque()).orElse(var3.getMinBuildHeight());
    }

    @Override
    public BlockColumn getBaseColumn(int var0, int var1, LevelHeightAccessor var2, RandomState var3) {
        MutableObject var4 = new MutableObject();
        this.iterateNoiseColumn(var2, var3, var0, var1, (MutableObject<BlockColumn>)var4, null);
        return (BlockColumn)var4.getValue();
    }

    @Override
    public void addDebugScreenInfo(List<String> var0, RandomState var1, BlockPosition var2) {
        DecimalFormat var3 = new DecimalFormat("0.000");
        NoiseRouter var4 = var1.router();
        DensityFunction.e var5 = new DensityFunction.e(var2.getX(), var2.getY(), var2.getZ());
        double var6 = var4.ridges().compute(var5);
        var0.add("NoiseRouter T: " + var3.format(var4.temperature().compute(var5)) + " V: " + var3.format(var4.vegetation().compute(var5)) + " C: " + var3.format(var4.continents().compute(var5)) + " E: " + var3.format(var4.erosion().compute(var5)) + " D: " + var3.format(var4.depth().compute(var5)) + " W: " + var3.format(var6) + " PV: " + var3.format(NoiseRouterData.peaksAndValleys((float)var6)) + " AS: " + var3.format(var4.initialDensityWithoutJaggedness().compute(var5)) + " N: " + var3.format(var4.finalDensity().compute(var5)));
    }

    private OptionalInt iterateNoiseColumn(LevelHeightAccessor var0, RandomState var1, int var2, int var3, @Nullable MutableObject<BlockColumn> var4, @Nullable Predicate<IBlockData> var5) {
        IBlockData[] var11;
        NoiseSettings var6 = this.settings.value().noiseSettings().clampToHeightAccessor(var0);
        int var7 = var6.getCellHeight();
        int var8 = var6.minY();
        int var9 = MathHelper.intFloorDiv(var8, var7);
        int var10 = MathHelper.intFloorDiv(var6.height(), var7);
        if (var10 <= 0) {
            return OptionalInt.empty();
        }
        if (var4 == null) {
            var11 = null;
        } else {
            var11 = new IBlockData[var6.height()];
            var4.setValue((Object)new BlockColumn(var8, var11));
        }
        int var12 = var6.getCellWidth();
        int var13 = Math.floorDiv(var2, var12);
        int var14 = Math.floorDiv(var3, var12);
        int var15 = Math.floorMod(var2, var12);
        int var16 = Math.floorMod(var3, var12);
        int var17 = var13 * var12;
        int var18 = var14 * var12;
        double var19 = (double)var15 / (double)var12;
        double var21 = (double)var16 / (double)var12;
        NoiseChunk var23 = new NoiseChunk(1, var1, var17, var18, var6, DensityFunctions.b.INSTANCE, this.settings.value(), this.globalFluidPicker.get(), Blender.empty());
        var23.initializeForFirstCellX();
        var23.advanceCellX(0);
        for (int var24 = var10 - 1; var24 >= 0; --var24) {
            var23.selectCellYZ(var24, 0);
            for (int var25 = var7 - 1; var25 >= 0; --var25) {
                IBlockData var30;
                int var26 = (var9 + var24) * var7 + var25;
                double var27 = (double)var25 / (double)var7;
                var23.updateForY(var26, var27);
                var23.updateForX(var2, var19);
                var23.updateForZ(var3, var21);
                IBlockData var29 = var23.getInterpolatedState();
                IBlockData iBlockData = var30 = var29 == null ? this.settings.value().defaultBlock() : var29;
                if (var11 != null) {
                    int var31 = var24 * var7 + var25;
                    var11[var31] = var30;
                }
                if (var5 == null || !var5.test(var30)) continue;
                var23.stopInterpolation();
                return OptionalInt.of(var26 + 1);
            }
        }
        var23.stopInterpolation();
        return OptionalInt.empty();
    }

    @Override
    public void buildSurface(RegionLimitedWorldAccess var0, StructureManager var1, RandomState var2, IChunkAccess var3) {
        if (SharedConstants.debugVoidTerrain(var3.getPos())) {
            return;
        }
        WorldGenerationContext var4 = new WorldGenerationContext(this, var0);
        this.buildSurface(var3, var4, var2, var1, var0.getBiomeManager(), var0.registryAccess().registryOrThrow(Registries.BIOME), Blender.of(var0));
    }

    @VisibleForTesting
    public void buildSurface(IChunkAccess var0, WorldGenerationContext var1, RandomState var2, StructureManager var32, BiomeManager var4, IRegistry<BiomeBase> var5, Blender var6) {
        NoiseChunk var7 = var0.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var32, var6, var2));
        GeneratorSettingBase var8 = this.settings.value();
        var2.surfaceSystem().buildSurface(var2, var4, var5, var8.useLegacyRandomSource(), var1, var0, var7, var8.surfaceRule());
    }

    @Override
    public void applyCarvers(RegionLimitedWorldAccess var0, long var12, RandomState var32, BiomeManager var4, StructureManager var5, IChunkAccess var6, WorldGenStage.Features var7) {
        BiomeManager var8 = var4.withDifferentSource((var1, var2, var3) -> this.biomeSource.getNoiseBiome(var1, var2, var3, var32.sampler()));
        SeededRandom var9 = new SeededRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        int var10 = 8;
        ChunkCoordIntPair var11 = var6.getPos();
        NoiseChunk var122 = var6.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var5, Blender.of(var0), var32));
        Aquifer var13 = var122.aquifer();
        CarvingContext var14 = new CarvingContext(this, var0.registryAccess(), var6.getHeightAccessorForGeneration(), var122, var32, this.settings.value().surfaceRule());
        CarvingMask var15 = ((ProtoChunk)var6).getOrCreateCarvingMask(var7);
        for (int var16 = -8; var16 <= 8; ++var16) {
            for (int var17 = -8; var17 <= 8; ++var17) {
                ChunkCoordIntPair var18 = new ChunkCoordIntPair(var11.x + var16, var11.z + var17);
                IChunkAccess var19 = var0.getChunk(var18.x, var18.z);
                BiomeSettingsGeneration var20 = var19.carverBiome(() -> this.getBiomeGenerationSettings(this.biomeSource.getNoiseBiome(QuartPos.fromBlock(var18.getMinBlockX()), 0, QuartPos.fromBlock(var18.getMinBlockZ()), var32.sampler())));
                Iterable<Holder<WorldGenCarverWrapper<?>>> var21 = var20.getCarvers(var7);
                int var22 = 0;
                for (Holder<WorldGenCarverWrapper<?>> var24 : var21) {
                    WorldGenCarverWrapper<?> var25 = var24.value();
                    var9.setLargeFeatureSeed(var12 + (long)var22, var18.x, var18.z);
                    if (var25.isStartChunk(var9)) {
                        var25.carve(var14, var6, var8::getBiome, var9, var13, var18, var15);
                    }
                    ++var22;
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> fillFromNoise(Executor var0, Blender var12, RandomState var22, StructureManager var3, IChunkAccess var4) {
        NoiseSettings var5 = this.settings.value().noiseSettings().clampToHeightAccessor(var4.getHeightAccessorForGeneration());
        int var6 = var5.minY();
        int var7 = MathHelper.intFloorDiv(var6, var5.getCellHeight());
        int var8 = MathHelper.intFloorDiv(var5.height(), var5.getCellHeight());
        if (var8 <= 0) {
            return CompletableFuture.completedFuture(var4);
        }
        int var9 = var4.getSectionIndex(var8 * var5.getCellHeight() - 1 + var6);
        int var10 = var4.getSectionIndex(var6);
        HashSet var11 = Sets.newHashSet();
        for (int var122 = var9; var122 >= var10; --var122) {
            ChunkSection var13 = var4.getSection(var122);
            var13.acquire();
            var11.add(var13);
        }
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("wgen_fill_noise", () -> this.doFill(var12, var3, var22, var4, var7, var8)), SystemUtils.backgroundExecutor()).whenCompleteAsync((var1, var2) -> {
            for (ChunkSection var4 : var11) {
                var4.release();
            }
        }, var0);
    }

    private IChunkAccess doFill(Blender var0, StructureManager var1, RandomState var2, IChunkAccess var32, int var4, int var5) {
        NoiseChunk var6 = var32.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var1, var0, var2));
        HeightMap var7 = var32.getOrCreateHeightmapUnprimed(HeightMap.Type.OCEAN_FLOOR_WG);
        HeightMap var8 = var32.getOrCreateHeightmapUnprimed(HeightMap.Type.WORLD_SURFACE_WG);
        ChunkCoordIntPair var9 = var32.getPos();
        int var10 = var9.getMinBlockX();
        int var11 = var9.getMinBlockZ();
        Aquifer var12 = var6.aquifer();
        var6.initializeForFirstCellX();
        BlockPosition.MutableBlockPosition var13 = new BlockPosition.MutableBlockPosition();
        int var14 = var6.cellWidth();
        int var15 = var6.cellHeight();
        int var16 = 16 / var14;
        int var17 = 16 / var14;
        for (int var18 = 0; var18 < var16; ++var18) {
            var6.advanceCellX(var18);
            for (int var19 = 0; var19 < var17; ++var19) {
                ChunkSection var20 = var32.getSection(var32.getSectionsCount() - 1);
                for (int var21 = var5 - 1; var21 >= 0; --var21) {
                    var6.selectCellYZ(var21, var19);
                    for (int var22 = var15 - 1; var22 >= 0; --var22) {
                        int var23 = (var4 + var21) * var15 + var22;
                        int var24 = var23 & 0xF;
                        int var25 = var32.getSectionIndex(var23);
                        if (var32.getSectionIndex(var20.bottomBlockY()) != var25) {
                            var20 = var32.getSection(var25);
                        }
                        double var26 = (double)var22 / (double)var15;
                        var6.updateForY(var23, var26);
                        for (int var28 = 0; var28 < var14; ++var28) {
                            int var29 = var10 + var18 * var14 + var28;
                            int var30 = var29 & 0xF;
                            double var31 = (double)var28 / (double)var14;
                            var6.updateForX(var29, var31);
                            for (int var33 = 0; var33 < var14; ++var33) {
                                int var34 = var11 + var19 * var14 + var33;
                                int var35 = var34 & 0xF;
                                double var36 = (double)var33 / (double)var14;
                                var6.updateForZ(var34, var36);
                                IBlockData var38 = var6.getInterpolatedState();
                                if (var38 == null) {
                                    var38 = this.settings.value().defaultBlock();
                                }
                                if ((var38 = this.debugPreliminarySurfaceLevel(var6, var29, var23, var34, var38)) == AIR || SharedConstants.debugVoidTerrain(var32.getPos())) continue;
                                if (var38.getLightEmission() != 0 && var32 instanceof ProtoChunk) {
                                    var13.set(var29, var23, var34);
                                    ((ProtoChunk)var32).addLight(var13);
                                }
                                var20.setBlockState(var30, var24, var35, var38, false);
                                var7.update(var30, var23, var35, var38);
                                var8.update(var30, var23, var35, var38);
                                if (!var12.shouldScheduleFluidUpdate() || var38.getFluidState().isEmpty()) continue;
                                var13.set(var29, var23, var34);
                                var32.markPosForPostprocessing(var13);
                            }
                        }
                    }
                }
            }
            var6.swapSlices();
        }
        var6.stopInterpolation();
        return var32;
    }

    private IBlockData debugPreliminarySurfaceLevel(NoiseChunk var0, int var1, int var2, int var3, IBlockData var4) {
        return var4;
    }

    @Override
    public int getGenDepth() {
        return this.settings.value().noiseSettings().height();
    }

    @Override
    public int getSeaLevel() {
        return this.settings.value().seaLevel();
    }

    @Override
    public int getMinY() {
        return this.settings.value().noiseSettings().minY();
    }

    @Override
    public void spawnOriginalMobs(RegionLimitedWorldAccess var0) {
        if (this.settings.value().disableMobGeneration()) {
            return;
        }
        ChunkCoordIntPair var1 = var0.getCenter();
        Holder<BiomeBase> var2 = var0.getBiome(var1.getWorldPosition().atY(var0.getMaxBuildHeight() - 1));
        SeededRandom var3 = new SeededRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        var3.setDecorationSeed(var0.getSeed(), var1.getMinBlockX(), var1.getMinBlockZ());
        SpawnerCreature.spawnMobsForChunkGeneration(var0, var2, var1, var3);
    }
}

