/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class VibrationListener
implements GameEventListener {
    @VisibleForTesting
    public static final Object2IntMap<GameEvent> VIBRATION_FREQUENCY_FOR_EVENT = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)SystemUtils.make(new Object2IntOpenHashMap(), var0 -> {
        var0.put((Object)GameEvent.STEP, 1);
        var0.put((Object)GameEvent.FLAP, 2);
        var0.put((Object)GameEvent.SWIM, 3);
        var0.put((Object)GameEvent.ELYTRA_GLIDE, 4);
        var0.put((Object)GameEvent.HIT_GROUND, 5);
        var0.put((Object)GameEvent.TELEPORT, 5);
        var0.put((Object)GameEvent.SPLASH, 6);
        var0.put((Object)GameEvent.ENTITY_SHAKE, 6);
        var0.put((Object)GameEvent.BLOCK_CHANGE, 6);
        var0.put((Object)GameEvent.NOTE_BLOCK_PLAY, 6);
        var0.put((Object)GameEvent.PROJECTILE_SHOOT, 7);
        var0.put((Object)GameEvent.DRINK, 7);
        var0.put((Object)GameEvent.PRIME_FUSE, 7);
        var0.put((Object)GameEvent.PROJECTILE_LAND, 8);
        var0.put((Object)GameEvent.EAT, 8);
        var0.put((Object)GameEvent.ENTITY_INTERACT, 8);
        var0.put((Object)GameEvent.ENTITY_DAMAGE, 8);
        var0.put((Object)GameEvent.EQUIP, 9);
        var0.put((Object)GameEvent.SHEAR, 9);
        var0.put((Object)GameEvent.ENTITY_ROAR, 9);
        var0.put((Object)GameEvent.BLOCK_CLOSE, 10);
        var0.put((Object)GameEvent.BLOCK_DEACTIVATE, 10);
        var0.put((Object)GameEvent.BLOCK_DETACH, 10);
        var0.put((Object)GameEvent.DISPENSE_FAIL, 10);
        var0.put((Object)GameEvent.BLOCK_OPEN, 11);
        var0.put((Object)GameEvent.BLOCK_ACTIVATE, 11);
        var0.put((Object)GameEvent.BLOCK_ATTACH, 11);
        var0.put((Object)GameEvent.ENTITY_PLACE, 12);
        var0.put((Object)GameEvent.BLOCK_PLACE, 12);
        var0.put((Object)GameEvent.FLUID_PLACE, 12);
        var0.put((Object)GameEvent.ENTITY_DIE, 13);
        var0.put((Object)GameEvent.BLOCK_DESTROY, 13);
        var0.put((Object)GameEvent.FLUID_PICKUP, 13);
        var0.put((Object)GameEvent.ITEM_INTERACT_FINISH, 14);
        var0.put((Object)GameEvent.CONTAINER_CLOSE, 14);
        var0.put((Object)GameEvent.PISTON_CONTRACT, 14);
        var0.put((Object)GameEvent.PISTON_EXTEND, 15);
        var0.put((Object)GameEvent.CONTAINER_OPEN, 15);
        var0.put((Object)GameEvent.EXPLODE, 15);
        var0.put((Object)GameEvent.LIGHTNING_STRIKE, 15);
        var0.put((Object)GameEvent.INSTRUMENT_PLAY, 15);
    })));
    protected final PositionSource listenerSource;
    protected final int listenerRange;
    protected final a config;
    @Nullable
    protected VibrationInfo currentVibration;
    protected int travelTimeInTicks;
    private final VibrationSelector selectionStrategy;

    public static Codec<VibrationListener> codec(a var0) {
        return RecordCodecBuilder.create(var12 -> var12.group((App)PositionSource.CODEC.fieldOf("source").forGetter(var0 -> var0.listenerSource), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("range").forGetter(var0 -> var0.listenerRange), (App)VibrationInfo.CODEC.optionalFieldOf("event").forGetter(var0 -> Optional.ofNullable(var0.currentVibration)), (App)VibrationSelector.CODEC.fieldOf("selector").forGetter(var0 -> var0.selectionStrategy), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("event_delay").orElse((Object)0).forGetter(var0 -> var0.travelTimeInTicks)).apply((Applicative)var12, (var1, var2, var3, var4, var5) -> new VibrationListener((PositionSource)var1, (int)var2, var0, var3.orElse(null), (VibrationSelector)var4, (int)var5)));
    }

    private VibrationListener(PositionSource var0, int var1, a var2, @Nullable VibrationInfo var3, VibrationSelector var4, int var5) {
        this.listenerSource = var0;
        this.listenerRange = var1;
        this.config = var2;
        this.currentVibration = var3;
        this.travelTimeInTicks = var5;
        this.selectionStrategy = var4;
    }

    public VibrationListener(PositionSource var0, int var1, a var2) {
        this(var0, var1, var2, null, new VibrationSelector(), 0);
    }

    public static int getGameEventFrequency(GameEvent var0) {
        return VIBRATION_FREQUENCY_FOR_EVENT.getOrDefault((Object)var0, 0);
    }

    public void tick(World var0) {
        if (var0 instanceof WorldServer) {
            WorldServer var12 = (WorldServer)var0;
            if (this.currentVibration == null) {
                this.selectionStrategy.chosenCandidate(var12.getGameTime()).ifPresent(var1 -> {
                    this.currentVibration = var1;
                    Vec3D var2 = this.currentVibration.pos();
                    this.travelTimeInTicks = MathHelper.floor(this.currentVibration.distance());
                    var12.sendParticles(new VibrationParticleOption(this.listenerSource, this.travelTimeInTicks), var2.x, var2.y, var2.z, 1, 0.0, 0.0, 0.0, 0.0);
                    this.config.onSignalSchedule();
                    this.selectionStrategy.startOver();
                });
            }
            if (this.currentVibration != null) {
                --this.travelTimeInTicks;
                if (this.travelTimeInTicks <= 0) {
                    this.travelTimeInTicks = 0;
                    this.config.onSignalReceive(var12, this, new BlockPosition(this.currentVibration.pos()), this.currentVibration.gameEvent(), this.currentVibration.getEntity(var12).orElse(null), this.currentVibration.getProjectileOwner(var12).orElse(null), this.currentVibration.distance());
                    this.currentVibration = null;
                }
            }
        }
    }

    @Override
    public PositionSource getListenerSource() {
        return this.listenerSource;
    }

    @Override
    public int getListenerRadius() {
        return this.listenerRange;
    }

    @Override
    public boolean handleGameEvent(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3) {
        if (this.currentVibration != null) {
            return false;
        }
        if (!this.config.isValidVibration(var1, var2)) {
            return false;
        }
        Optional<Vec3D> var4 = this.listenerSource.getPosition(var0);
        if (var4.isEmpty()) {
            return false;
        }
        Vec3D var5 = var4.get();
        if (!this.config.shouldListen(var0, this, new BlockPosition(var3), var1, var2)) {
            return false;
        }
        if (VibrationListener.isOccluded(var0, var3, var5)) {
            return false;
        }
        this.scheduleVibration(var0, var1, var2, var3, var5);
        return true;
    }

    public void forceGameEvent(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3) {
        this.listenerSource.getPosition(var0).ifPresent(var4 -> this.scheduleVibration(var0, var1, var2, var3, (Vec3D)var4));
    }

    public void scheduleVibration(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3, Vec3D var4) {
        this.selectionStrategy.addCandidate(new VibrationInfo(var1, (float)var3.distanceTo(var4), var3, var2.sourceEntity()), var0.getGameTime());
    }

    private static boolean isOccluded(World var02, Vec3D var1, Vec3D var2) {
        Vec3D var3 = new Vec3D((double)MathHelper.floor(var1.x) + 0.5, (double)MathHelper.floor(var1.y) + 0.5, (double)MathHelper.floor(var1.z) + 0.5);
        Vec3D var4 = new Vec3D((double)MathHelper.floor(var2.x) + 0.5, (double)MathHelper.floor(var2.y) + 0.5, (double)MathHelper.floor(var2.z) + 0.5);
        for (EnumDirection var8 : EnumDirection.values()) {
            Vec3D var9 = var3.relative(var8, 1.0E-5f);
            if (var02.isBlockInLine(new ClipBlockStateContext(var9, var4, var0 -> var0.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS))).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) continue;
            return false;
        }
        return true;
    }

    public static interface a {
        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.VIBRATIONS;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean isValidVibration(GameEvent var0, GameEvent.a var1) {
            if (!var0.is(this.getListenableEvents())) {
                return false;
            }
            Entity var2 = var1.sourceEntity();
            if (var2 != null) {
                if (var2.isSpectator()) {
                    return false;
                }
                if (var2.isSteppingCarefully() && var0.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                    if (this.canTriggerAvoidVibration() && var2 instanceof EntityPlayer) {
                        EntityPlayer var3 = (EntityPlayer)var2;
                        CriterionTriggers.AVOID_VIBRATION.trigger(var3);
                    }
                    return false;
                }
                if (var2.dampensVibrations()) {
                    return false;
                }
            }
            if (var1.affectedState() != null) {
                return !var1.affectedState().is(TagsBlock.DAMPENS_VIBRATIONS);
            }
            return true;
        }

        public boolean shouldListen(WorldServer var1, GameEventListener var2, BlockPosition var3, GameEvent var4, GameEvent.a var5);

        public void onSignalReceive(WorldServer var1, GameEventListener var2, BlockPosition var3, GameEvent var4, @Nullable Entity var5, @Nullable Entity var6, float var7);

        default public void onSignalSchedule() {
        }
    }
}

