/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;

public class DynamicGameEventListener<T extends GameEventListener> {
    private T listener;
    @Nullable
    private SectionPosition lastSection;

    public DynamicGameEventListener(T var0) {
        this.listener = var0;
    }

    public void add(WorldServer var0) {
        this.move(var0);
    }

    public void updateListener(T var0, @Nullable World var12) {
        Object var2 = this.listener;
        if (var2 == var0) {
            return;
        }
        if (var12 instanceof WorldServer) {
            WorldServer var3 = (WorldServer)var12;
            DynamicGameEventListener.ifChunkExists(var3, this.lastSection, var1 -> var1.unregister((GameEventListener)var2));
            DynamicGameEventListener.ifChunkExists(var3, this.lastSection, var1 -> var1.register((GameEventListener)var0));
        }
        this.listener = var0;
    }

    public T getListener() {
        return this.listener;
    }

    public void remove(WorldServer var02) {
        DynamicGameEventListener.ifChunkExists(var02, this.lastSection, var0 -> var0.unregister((GameEventListener)this.listener));
    }

    public void move(WorldServer var0) {
        this.listener.getListenerSource().getPosition(var0).map(SectionPosition::of).ifPresent(var1 -> {
            if (this.lastSection == null || !this.lastSection.equals(var1)) {
                DynamicGameEventListener.ifChunkExists(var0, this.lastSection, var0 -> var0.unregister((GameEventListener)this.listener));
                this.lastSection = var1;
                DynamicGameEventListener.ifChunkExists(var0, this.lastSection, var0 -> var0.register((GameEventListener)this.listener));
            }
        });
    }

    private static void ifChunkExists(IWorldReader var0, @Nullable SectionPosition var1, Consumer<GameEventListenerRegistry> var2) {
        if (var1 == null) {
            return;
        }
        IChunkAccess var3 = var0.getChunk(var1.x(), var1.z(), ChunkStatus.FULL, false);
        if (var3 != null) {
            var2.accept(var3.getListenerRegistry(var1.y()));
        }
    }
}

