/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;

public class IChunkLoader
implements AutoCloseable {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    private final IOWorker worker;
    protected final DataFixer fixerUpper;
    @Nullable
    private volatile PersistentStructureLegacy legacyStructureHandler;

    public IChunkLoader(Path var0, DataFixer var1, boolean var2) {
        this.fixerUpper = var1;
        this.worker = new IOWorker(var0, var2, "chunk");
    }

    public boolean isOldChunkAround(ChunkCoordIntPair var0, int var1) {
        return this.worker.isOldChunkAround(var0, var1);
    }

    public NBTTagCompound upgradeChunkTag(ResourceKey<World> var0, Supplier<WorldPersistentData> var1, NBTTagCompound var2, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> var3) {
        int var4 = IChunkLoader.getVersion(var2);
        if (var4 < 1493 && (var2 = GameProfileSerializer.update(this.fixerUpper, DataFixTypes.CHUNK, var2, var4, 1493)).getCompound("Level").getBoolean("hasLegacyStructureData")) {
            PersistentStructureLegacy var5 = this.getLegacyStructureHandler(var0, var1);
            var2 = var5.updateFromLegacy(var2);
        }
        IChunkLoader.injectDatafixingContext(var2, var0, var3);
        var2 = GameProfileSerializer.update(this.fixerUpper, DataFixTypes.CHUNK, var2, Math.max(1493, var4));
        if (var4 < SharedConstants.getCurrentVersion().getWorldVersion()) {
            var2.putInt("DataVersion", SharedConstants.getCurrentVersion().getWorldVersion());
        }
        var2.remove("__context");
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy getLegacyStructureHandler(ResourceKey<World> var0, Supplier<WorldPersistentData> var1) {
        PersistentStructureLegacy var2 = this.legacyStructureHandler;
        if (var2 == null) {
            IChunkLoader iChunkLoader = this;
            synchronized (iChunkLoader) {
                var2 = this.legacyStructureHandler;
                if (var2 == null) {
                    this.legacyStructureHandler = var2 = PersistentStructureLegacy.getLegacyStructureHandler(var0, var1.get());
                }
            }
        }
        return var2;
    }

    public static void injectDatafixingContext(NBTTagCompound var0, ResourceKey<World> var12, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> var2) {
        NBTTagCompound var3 = new NBTTagCompound();
        var3.putString("dimension", var12.location().toString());
        var2.ifPresent(var1 -> var3.putString("generator", var1.location().toString()));
        var0.put("__context", var3);
    }

    public static int getVersion(NBTTagCompound var0) {
        return var0.contains("DataVersion", 99) ? var0.getInt("DataVersion") : -1;
    }

    public CompletableFuture<Optional<NBTTagCompound>> read(ChunkCoordIntPair var0) {
        return this.worker.loadAsync(var0);
    }

    public void write(ChunkCoordIntPair var0, NBTTagCompound var1) {
        this.worker.store(var0, var1);
        if (this.legacyStructureHandler != null) {
            this.legacyStructureHandler.removeIndex(var0.toLong());
        }
    }

    public void flushWorker() {
        this.worker.synchronize(true).join();
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }

    public ChunkScanAccess chunkScanner() {
        return this.worker;
    }
}

