/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import java.util.Optional;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;

public class RotationSegment {
    private static final int MAX_SEGMENT_INDEX = 15;
    private static final int NORTH_0 = 0;
    private static final int EAST_90 = 4;
    private static final int SOUTH_180 = 8;
    private static final int WEST_270 = 12;

    public static int getMaxSegmentIndex() {
        return 15;
    }

    public static int convertToSegment(EnumDirection var0) {
        return var0.getAxis().isVertical() ? 0 : var0.getOpposite().get2DDataValue() * 4;
    }

    public static int convertToSegment(float var0) {
        return MathHelper.floor((double)((180.0f + var0) * 16.0f / 360.0f) + 0.5) & 0xF;
    }

    public static Optional<EnumDirection> convertToDirection(int var0) {
        EnumDirection var1 = switch (var0) {
            case 0 -> EnumDirection.NORTH;
            case 4 -> EnumDirection.EAST;
            case 8 -> EnumDirection.SOUTH;
            case 12 -> EnumDirection.WEST;
            default -> null;
        };
        return Optional.ofNullable(var1);
    }

    public static float convertToDegrees(int var0) {
        return (float)var0 * 22.5f;
    }
}

