/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] UPDATE_SHAPE_ORDER = new EnumDirection[]{EnumDirection.WEST, EnumDirection.EAST, EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.DOWN, EnumDirection.UP};
    protected final Material material;
    protected final boolean hasCollision;
    protected final float explosionResistance;
    protected final boolean isRandomlyTicking;
    protected final SoundEffectType soundType;
    protected final float friction;
    protected final float speedFactor;
    protected final float jumpFactor;
    protected final boolean dynamicShape;
    protected final FeatureFlagSet requiredFeatures;
    protected final Info properties;
    @Nullable
    protected MinecraftKey drops;

    public BlockBase(Info var0) {
        this.material = var0.material;
        this.hasCollision = var0.hasCollision;
        this.drops = var0.drops;
        this.explosionResistance = var0.explosionResistance;
        this.isRandomlyTicking = var0.isRandomlyTicking;
        this.soundType = var0.soundType;
        this.friction = var0.friction;
        this.speedFactor = var0.speedFactor;
        this.jumpFactor = var0.jumpFactor;
        this.dynamicShape = var0.dynamicShape;
        this.requiredFeatures = var0.requiredFeatures;
        this.properties = var0;
    }

    @Deprecated
    public void updateIndirectNeighbourShapes(IBlockData var0, GeneratorAccess var1, BlockPosition var2, int var3, int var4) {
    }

    @Deprecated
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        switch (var3) {
            case LAND: {
                return !var0.isCollisionShapeFullBlock(var1, var2);
            }
            case WATER: {
                return var1.getFluidState(var2).is(TagsFluid.WATER);
            }
            case AIR: {
                return !var0.isCollisionShapeFullBlock(var1, var2);
            }
        }
        return false;
    }

    @Deprecated
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        return var0;
    }

    @Deprecated
    public boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        return false;
    }

    @Deprecated
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        PacketDebug.sendNeighborsUpdatePacket(var1, var2);
    }

    @Deprecated
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
    }

    @Deprecated
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.hasBlockEntity() && !var0.is(var3.getBlock())) {
            var1.removeBlockEntity(var2);
        }
    }

    @Deprecated
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        return EnumInteractionResult.PASS;
    }

    @Deprecated
    public boolean triggerEvent(IBlockData var0, World var1, BlockPosition var2, int var3, int var4) {
        return false;
    }

    @Deprecated
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Deprecated
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return false;
    }

    @Deprecated
    public boolean isSignalSource(IBlockData var0) {
        return false;
    }

    @Deprecated
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return this.material.getPushReaction();
    }

    @Deprecated
    public Fluid getFluidState(IBlockData var0) {
        return FluidTypes.EMPTY.defaultFluidState();
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.25f;
    }

    public float getMaxVerticalOffset() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    @Deprecated
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return var0;
    }

    @Deprecated
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0;
    }

    @Deprecated
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return this.material.isReplaceable() && (var1.getItemInHand().isEmpty() || !var1.getItemInHand().is(this.asItem()));
    }

    @Deprecated
    public boolean canBeReplaced(IBlockData var0, FluidType var1) {
        return this.material.isReplaceable() || !this.material.isSolid();
    }

    @Deprecated
    public List<ItemStack> getDrops(IBlockData var0, LootTableInfo.Builder var1) {
        MinecraftKey var2 = this.getLootTable();
        if (var2 == LootTables.EMPTY) {
            return Collections.emptyList();
        }
        LootTableInfo var3 = var1.withParameter(LootContextParameters.BLOCK_STATE, var0).create(LootContextParameterSets.BLOCK);
        WorldServer var4 = var3.getLevel();
        LootTable var5 = var4.getServer().getLootTables().get(var2);
        return var5.getRandomItems(var3);
    }

    @Deprecated
    public long getSeed(IBlockData var0, BlockPosition var1) {
        return MathHelper.getSeed(var1);
    }

    @Deprecated
    public VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getShape(var1, var2);
    }

    @Deprecated
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return this.getCollisionShape(var0, var1, var2, VoxelShapeCollision.empty());
    }

    @Deprecated
    public VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Deprecated
    public int getLightBlock(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        if (var0.isSolidRender(var1, var2)) {
            return var1.getMaxLightLevel();
        }
        return var0.propagatesSkylightDown(var1, var2) ? 0 : 1;
    }

    @Nullable
    @Deprecated
    public ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var2) {
        return null;
    }

    @Deprecated
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return true;
    }

    @Deprecated
    public float getShadeBrightness(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.isCollisionShapeFullBlock(var1, var2) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return 0;
    }

    @Deprecated
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.block();
    }

    @Deprecated
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.hasCollision ? var0.getShape(var1, var2) : VoxelShapes.empty();
    }

    @Deprecated
    public boolean isCollisionShapeFullBlock(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return Block.isShapeFullBlock(var0.getCollisionShape(var1, var2));
    }

    @Deprecated
    public boolean isOcclusionShapeFullBlock(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return Block.isShapeFullBlock(var0.getOcclusionShape(var1, var2));
    }

    @Deprecated
    public VoxelShape getVisualShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getCollisionShape(var0, var1, var2, var3);
    }

    @Deprecated
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.tick(var0, var1, var2, var3);
    }

    @Deprecated
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
    }

    @Deprecated
    public float getDestroyProgress(IBlockData var0, EntityHuman var1, IBlockAccess var2, BlockPosition var3) {
        float var4 = var0.getDestroySpeed(var2, var3);
        if (var4 == -1.0f) {
            return 0.0f;
        }
        int var5 = var1.hasCorrectToolForDrops(var0) ? 30 : 100;
        return var1.getDestroySpeed(var0) / var4 / (float)var5;
    }

    @Deprecated
    public void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
    }

    @Deprecated
    public void attack(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
    }

    @Deprecated
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return 0;
    }

    @Deprecated
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
    }

    @Deprecated
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return 0;
    }

    public final MinecraftKey getLootTable() {
        if (this.drops == null) {
            MinecraftKey var0 = BuiltInRegistries.BLOCK.getKey(this.asBlock());
            this.drops = var0.withPrefix("blocks/");
        }
        return this.drops;
    }

    @Deprecated
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
    }

    public abstract Item asItem();

    protected abstract Block asBlock();

    public MaterialMapColor defaultMaterialColor() {
        return this.properties.materialColor.apply(this.asBlock().defaultBlockState());
    }

    public float defaultDestroyTime() {
        return this.properties.destroyTime;
    }

    public static class Info {
        Material material;
        Function<IBlockData, MaterialMapColor> materialColor;
        boolean hasCollision = true;
        SoundEffectType soundType = SoundEffectType.STONE;
        ToIntFunction<IBlockData> lightEmission = var0 -> 0;
        float explosionResistance;
        float destroyTime;
        boolean requiresCorrectToolForDrops;
        boolean isRandomlyTicking;
        float friction = 0.6f;
        float speedFactor = 1.0f;
        float jumpFactor = 1.0f;
        MinecraftKey drops;
        boolean canOcclude = true;
        boolean isAir;
        boolean spawnParticlesOnBreak = true;
        d<EntityTypes<?>> isValidSpawn = (var0, var1, var2, var3) -> var0.isFaceSturdy(var1, var2, EnumDirection.UP) && var0.getLightEmission() < 14;
        e isRedstoneConductor = (var0, var1, var2) -> var0.getMaterial().isSolidBlocking() && var0.isCollisionShapeFullBlock(var1, var2);
        e isSuffocating;
        e isViewBlocking = this.isSuffocating = (var0, var1, var2) -> this.material.blocksMotion() && var0.isCollisionShapeFullBlock(var1, var2);
        e hasPostProcess = (var0, var1, var2) -> false;
        e emissiveRendering = (var0, var1, var2) -> false;
        boolean dynamicShape;
        FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
        Function<IBlockData, EnumRandomOffset> offsetType = var0 -> EnumRandomOffset.NONE;

        private Info(Material var0, MaterialMapColor var12) {
            this(var0, (IBlockData var1) -> var12);
        }

        private Info(Material var02, Function<IBlockData, MaterialMapColor> var12) {
            this.material = var02;
            this.materialColor = var12;
        }

        public static Info of(Material var0) {
            return Info.of(var0, var0.getColor());
        }

        public static Info of(Material var0, EnumColor var1) {
            return Info.of(var0, var1.getMaterialColor());
        }

        public static Info of(Material var0, MaterialMapColor var1) {
            return new Info(var0, var1);
        }

        public static Info of(Material var0, Function<IBlockData, MaterialMapColor> var1) {
            return new Info(var0, var1);
        }

        public static Info copy(BlockBase var0) {
            Info var1 = new Info(var0.material, var0.properties.materialColor);
            var1.material = var0.properties.material;
            var1.destroyTime = var0.properties.destroyTime;
            var1.explosionResistance = var0.properties.explosionResistance;
            var1.hasCollision = var0.properties.hasCollision;
            var1.isRandomlyTicking = var0.properties.isRandomlyTicking;
            var1.lightEmission = var0.properties.lightEmission;
            var1.materialColor = var0.properties.materialColor;
            var1.soundType = var0.properties.soundType;
            var1.friction = var0.properties.friction;
            var1.speedFactor = var0.properties.speedFactor;
            var1.dynamicShape = var0.properties.dynamicShape;
            var1.canOcclude = var0.properties.canOcclude;
            var1.isAir = var0.properties.isAir;
            var1.requiresCorrectToolForDrops = var0.properties.requiresCorrectToolForDrops;
            var1.offsetType = var0.properties.offsetType;
            var1.spawnParticlesOnBreak = var0.properties.spawnParticlesOnBreak;
            var1.requiredFeatures = var0.properties.requiredFeatures;
            return var1;
        }

        public Info noCollission() {
            this.hasCollision = false;
            this.canOcclude = false;
            return this;
        }

        public Info noOcclusion() {
            this.canOcclude = false;
            return this;
        }

        public Info friction(float var0) {
            this.friction = var0;
            return this;
        }

        public Info speedFactor(float var0) {
            this.speedFactor = var0;
            return this;
        }

        public Info jumpFactor(float var0) {
            this.jumpFactor = var0;
            return this;
        }

        public Info sound(SoundEffectType var0) {
            this.soundType = var0;
            return this;
        }

        public Info lightLevel(ToIntFunction<IBlockData> var0) {
            this.lightEmission = var0;
            return this;
        }

        public Info strength(float var0, float var1) {
            return this.destroyTime(var0).explosionResistance(var1);
        }

        public Info instabreak() {
            return this.strength(0.0f);
        }

        public Info strength(float var0) {
            this.strength(var0, var0);
            return this;
        }

        public Info randomTicks() {
            this.isRandomlyTicking = true;
            return this;
        }

        public Info dynamicShape() {
            this.dynamicShape = true;
            return this;
        }

        public Info noLootTable() {
            this.drops = LootTables.EMPTY;
            return this;
        }

        public Info dropsLike(Block var0) {
            this.drops = var0.getLootTable();
            return this;
        }

        public Info air() {
            this.isAir = true;
            return this;
        }

        public Info isValidSpawn(d<EntityTypes<?>> var0) {
            this.isValidSpawn = var0;
            return this;
        }

        public Info isRedstoneConductor(e var0) {
            this.isRedstoneConductor = var0;
            return this;
        }

        public Info isSuffocating(e var0) {
            this.isSuffocating = var0;
            return this;
        }

        public Info isViewBlocking(e var0) {
            this.isViewBlocking = var0;
            return this;
        }

        public Info hasPostProcess(e var0) {
            this.hasPostProcess = var0;
            return this;
        }

        public Info emissiveRendering(e var0) {
            this.emissiveRendering = var0;
            return this;
        }

        public Info requiresCorrectToolForDrops() {
            this.requiresCorrectToolForDrops = true;
            return this;
        }

        public Info color(MaterialMapColor var0) {
            this.materialColor = var1 -> var0;
            return this;
        }

        public Info destroyTime(float var0) {
            this.destroyTime = var0;
            return this;
        }

        public Info explosionResistance(float var0) {
            this.explosionResistance = Math.max(0.0f, var0);
            return this;
        }

        public Info offsetType(EnumRandomOffset var0) {
            return this.offsetType((IBlockData var1) -> var0);
        }

        public Info offsetType(Function<IBlockData, EnumRandomOffset> var0) {
            this.offsetType = var0;
            return this;
        }

        public Info noParticlesOnBreak() {
            this.spawnParticlesOnBreak = false;
            return this;
        }

        public Info requiredFeatures(FeatureFlag ... var0) {
            this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
            return this;
        }
    }

    public static interface d<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }

    public static interface e {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData> {
        private final int lightEmission;
        private final boolean useShapeForLightOcclusion;
        private final boolean isAir;
        private final Material material;
        private final MaterialMapColor materialColor;
        public final float destroySpeed;
        private final boolean requiresCorrectToolForDrops;
        private final boolean canOcclude;
        private final e isRedstoneConductor;
        private final e isSuffocating;
        private final e isViewBlocking;
        private final e hasPostProcess;
        private final e emissiveRendering;
        private final EnumRandomOffset offsetType;
        private final boolean spawnParticlesOnBreak;
        @Nullable
        protected Cache cache;
        private Fluid fluidState = FluidTypes.EMPTY.defaultFluidState();
        private boolean isRandomlyTicking;

        protected BlockData(Block var0, ImmutableMap<IBlockState<?>, Comparable<?>> var1, MapCodec<IBlockData> var2) {
            super(var0, var1, var2);
            Info var3 = var0.properties;
            this.lightEmission = var3.lightEmission.applyAsInt(this.asState());
            this.useShapeForLightOcclusion = var0.useShapeForLightOcclusion(this.asState());
            this.isAir = var3.isAir;
            this.material = var3.material;
            this.materialColor = var3.materialColor.apply(this.asState());
            this.destroySpeed = var3.destroyTime;
            this.requiresCorrectToolForDrops = var3.requiresCorrectToolForDrops;
            this.canOcclude = var3.canOcclude;
            this.isRedstoneConductor = var3.isRedstoneConductor;
            this.isSuffocating = var3.isSuffocating;
            this.isViewBlocking = var3.isViewBlocking;
            this.hasPostProcess = var3.hasPostProcess;
            this.emissiveRendering = var3.emissiveRendering;
            this.offsetType = var3.offsetType.apply(this.asState());
            this.spawnParticlesOnBreak = var3.spawnParticlesOnBreak;
        }

        public void initCache() {
            this.fluidState = ((Block)this.owner).getFluidState(this.asState());
            this.isRandomlyTicking = ((Block)this.owner).isRandomlyTicking(this.asState());
            if (!this.getBlock().hasDynamicShape()) {
                this.cache = new Cache(this.asState());
            }
        }

        public Block getBlock() {
            return (Block)this.owner;
        }

        public Holder<Block> getBlockHolder() {
            return ((Block)this.owner).builtInRegistryHolder();
        }

        public Material getMaterial() {
            return this.material;
        }

        public boolean isValidSpawn(IBlockAccess var0, BlockPosition var1, EntityTypes<?> var2) {
            return this.getBlock().properties.isValidSpawn.test(this.asState(), var0, var1, var2);
        }

        public boolean propagatesSkylightDown(IBlockAccess var0, BlockPosition var1) {
            if (this.cache != null) {
                return this.cache.propagatesSkylightDown;
            }
            return this.getBlock().propagatesSkylightDown(this.asState(), var0, var1);
        }

        public int getLightBlock(IBlockAccess var0, BlockPosition var1) {
            if (this.cache != null) {
                return this.cache.lightBlock;
            }
            return this.getBlock().getLightBlock(this.asState(), var0, var1);
        }

        public VoxelShape getFaceOcclusionShape(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
            if (this.cache != null && this.cache.occlusionShapes != null) {
                return this.cache.occlusionShapes[var2.ordinal()];
            }
            return VoxelShapes.getFaceShape(this.getOcclusionShape(var0, var1), var2);
        }

        public VoxelShape getOcclusionShape(IBlockAccess var0, BlockPosition var1) {
            return this.getBlock().getOcclusionShape(this.asState(), var0, var1);
        }

        public boolean hasLargeCollisionShape() {
            return this.cache == null || this.cache.largeCollisionShape;
        }

        public boolean useShapeForLightOcclusion() {
            return this.useShapeForLightOcclusion;
        }

        public int getLightEmission() {
            return this.lightEmission;
        }

        public boolean isAir() {
            return this.isAir;
        }

        public MaterialMapColor getMapColor(IBlockAccess var0, BlockPosition var1) {
            return this.materialColor;
        }

        public IBlockData rotate(EnumBlockRotation var0) {
            return this.getBlock().rotate(this.asState(), var0);
        }

        public IBlockData mirror(EnumBlockMirror var0) {
            return this.getBlock().mirror(this.asState(), var0);
        }

        public EnumRenderType getRenderShape() {
            return this.getBlock().getRenderShape(this.asState());
        }

        public boolean emissiveRendering(IBlockAccess var0, BlockPosition var1) {
            return this.emissiveRendering.test(this.asState(), var0, var1);
        }

        public float getShadeBrightness(IBlockAccess var0, BlockPosition var1) {
            return this.getBlock().getShadeBrightness(this.asState(), var0, var1);
        }

        public boolean isRedstoneConductor(IBlockAccess var0, BlockPosition var1) {
            return this.isRedstoneConductor.test(this.asState(), var0, var1);
        }

        public boolean isSignalSource() {
            return this.getBlock().isSignalSource(this.asState());
        }

        public int getSignal(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
            return this.getBlock().getSignal(this.asState(), var0, var1, var2);
        }

        public boolean hasAnalogOutputSignal() {
            return this.getBlock().hasAnalogOutputSignal(this.asState());
        }

        public int getAnalogOutputSignal(World var0, BlockPosition var1) {
            return this.getBlock().getAnalogOutputSignal(this.asState(), var0, var1);
        }

        public float getDestroySpeed(IBlockAccess var0, BlockPosition var1) {
            return this.destroySpeed;
        }

        public float getDestroyProgress(EntityHuman var0, IBlockAccess var1, BlockPosition var2) {
            return this.getBlock().getDestroyProgress(this.asState(), var0, var1, var2);
        }

        public int getDirectSignal(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
            return this.getBlock().getDirectSignal(this.asState(), var0, var1, var2);
        }

        public EnumPistonReaction getPistonPushReaction() {
            return this.getBlock().getPistonPushReaction(this.asState());
        }

        public boolean isSolidRender(IBlockAccess var0, BlockPosition var1) {
            if (this.cache != null) {
                return this.cache.solidRender;
            }
            IBlockData var2 = this.asState();
            if (var2.canOcclude()) {
                return Block.isShapeFullBlock(var2.getOcclusionShape(var0, var1));
            }
            return false;
        }

        public boolean canOcclude() {
            return this.canOcclude;
        }

        public boolean skipRendering(IBlockData var0, EnumDirection var1) {
            return this.getBlock().skipRendering(this.asState(), var0, var1);
        }

        public VoxelShape getShape(IBlockAccess var0, BlockPosition var1) {
            return this.getShape(var0, var1, VoxelShapeCollision.empty());
        }

        public VoxelShape getShape(IBlockAccess var0, BlockPosition var1, VoxelShapeCollision var2) {
            return this.getBlock().getShape(this.asState(), var0, var1, var2);
        }

        public VoxelShape getCollisionShape(IBlockAccess var0, BlockPosition var1) {
            if (this.cache != null) {
                return this.cache.collisionShape;
            }
            return this.getCollisionShape(var0, var1, VoxelShapeCollision.empty());
        }

        public VoxelShape getCollisionShape(IBlockAccess var0, BlockPosition var1, VoxelShapeCollision var2) {
            return this.getBlock().getCollisionShape(this.asState(), var0, var1, var2);
        }

        public VoxelShape getBlockSupportShape(IBlockAccess var0, BlockPosition var1) {
            return this.getBlock().getBlockSupportShape(this.asState(), var0, var1);
        }

        public VoxelShape getVisualShape(IBlockAccess var0, BlockPosition var1, VoxelShapeCollision var2) {
            return this.getBlock().getVisualShape(this.asState(), var0, var1, var2);
        }

        public VoxelShape getInteractionShape(IBlockAccess var0, BlockPosition var1) {
            return this.getBlock().getInteractionShape(this.asState(), var0, var1);
        }

        public final boolean entityCanStandOn(IBlockAccess var0, BlockPosition var1, Entity var2) {
            return this.entityCanStandOnFace(var0, var1, var2, EnumDirection.UP);
        }

        public final boolean entityCanStandOnFace(IBlockAccess var0, BlockPosition var1, Entity var2, EnumDirection var3) {
            return Block.isFaceFull(this.getCollisionShape(var0, var1, VoxelShapeCollision.of(var2)), var3);
        }

        public Vec3D getOffset(IBlockAccess var0, BlockPosition var1) {
            if (this.offsetType == EnumRandomOffset.NONE) {
                return Vec3D.ZERO;
            }
            Block var2 = this.getBlock();
            long var3 = MathHelper.getSeed(var1.getX(), 0, var1.getZ());
            float var5 = var2.getMaxHorizontalOffset();
            double var6 = MathHelper.clamp(((double)((float)(var3 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-var5), (double)var5);
            double var8 = this.offsetType == EnumRandomOffset.XYZ ? ((double)((float)(var3 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)var2.getMaxVerticalOffset() : 0.0;
            double var10 = MathHelper.clamp(((double)((float)(var3 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-var5), (double)var5);
            return new Vec3D(var6, var8, var10);
        }

        public boolean triggerEvent(World var0, BlockPosition var1, int var2, int var3) {
            return this.getBlock().triggerEvent(this.asState(), var0, var1, var2, var3);
        }

        @Deprecated
        public void neighborChanged(World var0, BlockPosition var1, Block var2, BlockPosition var3, boolean var4) {
            this.getBlock().neighborChanged(this.asState(), var0, var1, var2, var3, var4);
        }

        public final void updateNeighbourShapes(GeneratorAccess var0, BlockPosition var1, int var2) {
            this.updateNeighbourShapes(var0, var1, var2, 512);
        }

        public final void updateNeighbourShapes(GeneratorAccess var0, BlockPosition var1, int var2, int var3) {
            this.getBlock();
            BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
            for (EnumDirection var8 : UPDATE_SHAPE_ORDER) {
                var4.setWithOffset((BaseBlockPosition)var1, var8);
                var0.neighborShapeChanged(var8.getOpposite(), this.asState(), var4, var1, var2, var3);
            }
        }

        public final void updateIndirectNeighbourShapes(GeneratorAccess var0, BlockPosition var1, int var2) {
            this.updateIndirectNeighbourShapes(var0, var1, var2, 512);
        }

        public void updateIndirectNeighbourShapes(GeneratorAccess var0, BlockPosition var1, int var2, int var3) {
            this.getBlock().updateIndirectNeighbourShapes(this.asState(), var0, var1, var2, var3);
        }

        public void onPlace(World var0, BlockPosition var1, IBlockData var2, boolean var3) {
            this.getBlock().onPlace(this.asState(), var0, var1, var2, var3);
        }

        public void onRemove(World var0, BlockPosition var1, IBlockData var2, boolean var3) {
            this.getBlock().onRemove(this.asState(), var0, var1, var2, var3);
        }

        public void tick(WorldServer var0, BlockPosition var1, RandomSource var2) {
            this.getBlock().tick(this.asState(), var0, var1, var2);
        }

        public void randomTick(WorldServer var0, BlockPosition var1, RandomSource var2) {
            this.getBlock().randomTick(this.asState(), var0, var1, var2);
        }

        public void entityInside(World var0, BlockPosition var1, Entity var2) {
            this.getBlock().entityInside(this.asState(), var0, var1, var2);
        }

        public void spawnAfterBreak(WorldServer var0, BlockPosition var1, ItemStack var2, boolean var3) {
            this.getBlock().spawnAfterBreak(this.asState(), var0, var1, var2, var3);
        }

        public List<ItemStack> getDrops(LootTableInfo.Builder var0) {
            return this.getBlock().getDrops(this.asState(), var0);
        }

        public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2, MovingObjectPositionBlock var3) {
            return this.getBlock().use(this.asState(), var0, var3.getBlockPos(), var1, var2, var3);
        }

        public void attack(World var0, BlockPosition var1, EntityHuman var2) {
            this.getBlock().attack(this.asState(), var0, var1, var2);
        }

        public boolean isSuffocating(IBlockAccess var0, BlockPosition var1) {
            return this.isSuffocating.test(this.asState(), var0, var1);
        }

        public boolean isViewBlocking(IBlockAccess var0, BlockPosition var1) {
            return this.isViewBlocking.test(this.asState(), var0, var1);
        }

        public IBlockData updateShape(EnumDirection var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3, BlockPosition var4) {
            return this.getBlock().updateShape(this.asState(), var0, var1, var2, var3, var4);
        }

        public boolean isPathfindable(IBlockAccess var0, BlockPosition var1, PathMode var2) {
            return this.getBlock().isPathfindable(this.asState(), var0, var1, var2);
        }

        public boolean canBeReplaced(BlockActionContext var0) {
            return this.getBlock().canBeReplaced(this.asState(), var0);
        }

        public boolean canBeReplaced(FluidType var0) {
            return this.getBlock().canBeReplaced(this.asState(), var0);
        }

        public boolean canBeReplaced() {
            return this.getMaterial().isReplaceable();
        }

        public boolean canSurvive(IWorldReader var0, BlockPosition var1) {
            return this.getBlock().canSurvive(this.asState(), var0, var1);
        }

        public boolean hasPostProcess(IBlockAccess var0, BlockPosition var1) {
            return this.hasPostProcess.test(this.asState(), var0, var1);
        }

        @Nullable
        public ITileInventory getMenuProvider(World var0, BlockPosition var1) {
            return this.getBlock().getMenuProvider(this.asState(), var0, var1);
        }

        public boolean is(TagKey<Block> var0) {
            return this.getBlock().builtInRegistryHolder().is(var0);
        }

        public boolean is(TagKey<Block> var0, Predicate<BlockData> var1) {
            return this.is(var0) && var1.test(this);
        }

        public boolean is(HolderSet<Block> var0) {
            return var0.contains(this.getBlock().builtInRegistryHolder());
        }

        public Stream<TagKey<Block>> getTags() {
            return this.getBlock().builtInRegistryHolder().tags();
        }

        public boolean hasBlockEntity() {
            return this.getBlock() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, TileEntityTypes<T> var1) {
            if (this.getBlock() instanceof ITileEntity) {
                return ((ITileEntity)((Object)this.getBlock())).getTicker(var0, this.asState(), var1);
            }
            return null;
        }

        public boolean is(Block var0) {
            return this.getBlock() == var0;
        }

        public Fluid getFluidState() {
            return this.fluidState;
        }

        public boolean isRandomlyTicking() {
            return this.isRandomlyTicking;
        }

        public long getSeed(BlockPosition var0) {
            return this.getBlock().getSeed(this.asState(), var0);
        }

        public SoundEffectType getSoundType() {
            return this.getBlock().getSoundType(this.asState());
        }

        public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
            this.getBlock().onProjectileHit(var0, var1, var2, var3);
        }

        public boolean isFaceSturdy(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
            return this.isFaceSturdy(var0, var1, var2, EnumBlockSupport.FULL);
        }

        public boolean isFaceSturdy(IBlockAccess var0, BlockPosition var1, EnumDirection var2, EnumBlockSupport var3) {
            if (this.cache != null) {
                return this.cache.isFaceSturdy(var2, var3);
            }
            return var3.isSupporting(this.asState(), var0, var1, var2);
        }

        public boolean isCollisionShapeFullBlock(IBlockAccess var0, BlockPosition var1) {
            if (this.cache != null) {
                return this.cache.isCollisionShapeFullBlock;
            }
            return this.getBlock().isCollisionShapeFullBlock(this.asState(), var0, var1);
        }

        protected abstract IBlockData asState();

        public boolean requiresCorrectToolForDrops() {
            return this.requiresCorrectToolForDrops;
        }

        public EnumRandomOffset getOffsetType() {
            return this.offsetType;
        }

        public boolean shouldSpawnParticlesOnBreak() {
            return this.spawnParticlesOnBreak;
        }

        static final class Cache {
            private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
            private static final int SUPPORT_TYPE_COUNT = EnumBlockSupport.values().length;
            protected final boolean solidRender;
            final boolean propagatesSkylightDown;
            final int lightBlock;
            @Nullable
            final VoxelShape[] occlusionShapes;
            protected final VoxelShape collisionShape;
            protected final boolean largeCollisionShape;
            private final boolean[] faceSturdy;
            protected final boolean isCollisionShapeFullBlock;

            Cache(IBlockData var02) {
                Block var1 = var02.getBlock();
                this.solidRender = var02.isSolidRender(BlockAccessAir.INSTANCE, BlockPosition.ZERO);
                this.propagatesSkylightDown = var1.propagatesSkylightDown(var02, BlockAccessAir.INSTANCE, BlockPosition.ZERO);
                this.lightBlock = var1.getLightBlock(var02, BlockAccessAir.INSTANCE, BlockPosition.ZERO);
                if (!var02.canOcclude()) {
                    this.occlusionShapes = null;
                } else {
                    this.occlusionShapes = new VoxelShape[DIRECTIONS.length];
                    VoxelShape var2 = var1.getOcclusionShape(var02, BlockAccessAir.INSTANCE, BlockPosition.ZERO);
                    EnumDirection[] enumDirectionArray = DIRECTIONS;
                    int n2 = enumDirectionArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        EnumDirection var6 = enumDirectionArray[i2];
                        this.occlusionShapes[var6.ordinal()] = VoxelShapes.getFaceShape(var2, var6);
                    }
                }
                this.collisionShape = var1.getCollisionShape(var02, BlockAccessAir.INSTANCE, BlockPosition.ZERO, VoxelShapeCollision.empty());
                if (!this.collisionShape.isEmpty() && var02.getOffsetType() != EnumRandomOffset.NONE) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.BLOCK.getKey(var1)));
                }
                this.largeCollisionShape = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(var0 -> this.collisionShape.min((EnumDirection.EnumAxis)var0) < 0.0 || this.collisionShape.max((EnumDirection.EnumAxis)var0) > 1.0);
                this.faceSturdy = new boolean[DIRECTIONS.length * SUPPORT_TYPE_COUNT];
                for (EnumDirection var5 : DIRECTIONS) {
                    for (EnumBlockSupport var9 : EnumBlockSupport.values()) {
                        this.faceSturdy[Cache.getFaceSupportIndex((EnumDirection)var5, (EnumBlockSupport)var9)] = var9.isSupporting(var02, BlockAccessAir.INSTANCE, BlockPosition.ZERO, var5);
                    }
                }
                this.isCollisionShapeFullBlock = Block.isShapeFullBlock(var02.getCollisionShape(BlockAccessAir.INSTANCE, BlockPosition.ZERO));
            }

            public boolean isFaceSturdy(EnumDirection var0, EnumBlockSupport var1) {
                return this.faceSturdy[Cache.getFaceSupportIndex(var0, var1)];
            }

            private static int getFaceSupportIndex(EnumDirection var0, EnumBlockSupport var1) {
                return var0.ordinal() * SUPPORT_TYPE_COUNT + var1.ordinal();
            }
        }
    }

    public static final class EnumRandomOffset
    extends Enum<EnumRandomOffset> {
        public static final /* enum */ EnumRandomOffset NONE = new EnumRandomOffset();
        public static final /* enum */ EnumRandomOffset XZ = new EnumRandomOffset();
        public static final /* enum */ EnumRandomOffset XYZ = new EnumRandomOffset();
        private static final /* synthetic */ EnumRandomOffset[] d;

        public static EnumRandomOffset[] values() {
            return (EnumRandomOffset[])d.clone();
        }

        public static EnumRandomOffset valueOf(String var0) {
            return Enum.valueOf(EnumRandomOffset.class, var0);
        }

        private static /* synthetic */ EnumRandomOffset[] a() {
            return new EnumRandomOffset[]{NONE, XZ, XYZ};
        }

        static {
            d = EnumRandomOffset.a();
        }
    }
}

