/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final BlockStateDirection TIP_DIRECTION = BlockProperties.VERTICAL_DIRECTION;
    public static final BlockStateEnum<DripstoneThickness> THICKNESS = BlockProperties.DRIPSTONE_THICKNESS;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape BASE_SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public PointedDripstoneBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(TIP_DIRECTION, EnumDirection.UP)).setValue(THICKNESS, DripstoneThickness.TIP)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(TIP_DIRECTION, THICKNESS, WATERLOGGED);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return PointedDripstoneBlock.isValidPointedDripstonePlacement(var1, var2, var0.getValue(TIP_DIRECTION));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        if (var1 != EnumDirection.UP && var1 != EnumDirection.DOWN) {
            return var0;
        }
        EnumDirection var6 = var0.getValue(TIP_DIRECTION);
        if (var6 == EnumDirection.DOWN && var3.getBlockTicks().hasScheduledTick(var4, this)) {
            return var0;
        }
        if (var1 == var6.getOpposite() && !this.canSurvive(var0, var3, var4)) {
            if (var6 == EnumDirection.DOWN) {
                var3.scheduleTick(var4, this, 2);
            } else {
                var3.scheduleTick(var4, this, 1);
            }
            return var0;
        }
        boolean var7 = var0.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness var8 = PointedDripstoneBlock.calculateDripstoneThickness(var3, var4, var6, var7);
        return (IBlockData)var0.setValue(THICKNESS, var8);
    }

    @Override
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        BlockPosition var4 = var2.getBlockPos();
        if (!var0.isClientSide && var3.mayInteract(var0, var4) && var3 instanceof EntityThrownTrident && var3.getDeltaMovement().length() > 0.6) {
            var0.destroyBlock(var4, true);
        }
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, float var4) {
        if (var1.getValue(TIP_DIRECTION) == EnumDirection.UP && var1.getValue(THICKNESS) == DripstoneThickness.TIP) {
            var3.causeFallDamage(var4 + 2.0f, 2.0f, DamageSource.STALAGMITE);
        } else {
            super.fallOn(var0, var1, var2, var3, var4);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var12, BlockPosition var2, RandomSource var32) {
        if (!PointedDripstoneBlock.canDrip(var0)) {
            return;
        }
        float var4 = var32.nextFloat();
        if (var4 > 0.12f) {
            return;
        }
        PointedDripstoneBlock.getFluidAboveStalactite(var12, var2, var0).filter(var1 -> var4 < 0.02f || PointedDripstoneBlock.canFillCauldron(var1.fluid)).ifPresent(var3 -> PointedDripstoneBlock.spawnDripParticle(var12, var2, var0, var3.fluid));
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (PointedDripstoneBlock.isStalagmite(var0) && !this.canSurvive(var0, var1, var2)) {
            var1.destroyBlock(var2, true);
        } else {
            PointedDripstoneBlock.spawnFallingStalactite(var0, var1, var2);
        }
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        PointedDripstoneBlock.maybeTransferFluid(var0, var1, var2, var3.nextFloat());
        if (var3.nextFloat() < 0.011377778f && PointedDripstoneBlock.isStalactiteStartPos(var0, var1, var2)) {
            PointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(var0, var1, var2, var3);
        }
    }

    @VisibleForTesting
    public static void maybeTransferFluid(IBlockData var0, WorldServer var1, BlockPosition var2, float var3) {
        float var6;
        if (var3 > 0.17578125f && var3 > 0.05859375f) {
            return;
        }
        if (!PointedDripstoneBlock.isStalactiteStartPos(var0, var1, var2)) {
            return;
        }
        Optional<a> var4 = PointedDripstoneBlock.getFluidAboveStalactite(var1, var2, var0);
        if (var4.isEmpty()) {
            return;
        }
        FluidType var5 = var4.get().fluid;
        if (var5 == FluidTypes.WATER) {
            var6 = 0.17578125f;
        } else if (var5 == FluidTypes.LAVA) {
            var6 = 0.05859375f;
        } else {
            return;
        }
        if (var3 >= var6) {
            return;
        }
        BlockPosition var7 = PointedDripstoneBlock.findTip(var0, var1, var2, 11, false);
        if (var7 == null) {
            return;
        }
        if (var4.get().sourceState.is(Blocks.MUD) && var5 == FluidTypes.WATER) {
            IBlockData var8 = Blocks.CLAY.defaultBlockState();
            var1.setBlockAndUpdate(var4.get().pos, var8);
            Block.pushEntitiesUp(var4.get().sourceState, var8, var1, var4.get().pos);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var4.get().pos, GameEvent.a.of(var8));
            var1.levelEvent(1504, var7, 0);
            return;
        }
        BlockPosition var8 = PointedDripstoneBlock.findFillableCauldronBelowStalactiteTip(var1, var7, var5);
        if (var8 == null) {
            return;
        }
        var1.levelEvent(1504, var7, 0);
        int var9 = var7.getY() - var8.getY();
        int var10 = 50 + var9;
        IBlockData var11 = var1.getBlockState(var8);
        var1.scheduleTick(var8, var11.getBlock(), var10);
    }

    @Override
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return EnumPistonReaction.DESTROY;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var3;
        BlockPosition var2;
        World var1 = var0.getLevel();
        EnumDirection var4 = PointedDripstoneBlock.calculateTipDirection(var1, var2 = var0.getClickedPos(), var3 = var0.getNearestLookingVerticalDirection().getOpposite());
        if (var4 == null) {
            return null;
        }
        boolean var5 = !var0.isSecondaryUseActive();
        DripstoneThickness var6 = PointedDripstoneBlock.calculateDripstoneThickness(var1, var2, var4, var5);
        if (var6 == null) {
            return null;
        }
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(TIP_DIRECTION, var4)).setValue(THICKNESS, var6)).setValue(WATERLOGGED, var1.getFluidState(var2).getType() == FluidTypes.WATER);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        DripstoneThickness var5 = var0.getValue(THICKNESS);
        VoxelShape var4 = var5 == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (var5 == DripstoneThickness.TIP ? (var0.getValue(TIP_DIRECTION) == EnumDirection.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (var5 == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (var5 == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3D var6 = var0.getOffset(var1, var2);
        return var4.move(var6.x, 0.0, var6.z);
    }

    @Override
    public boolean isCollisionShapeFullBlock(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return false;
    }

    @Override
    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    @Override
    public void onBrokenAfterFall(World var0, BlockPosition var1, EntityFallingBlock var2) {
        if (!var2.isSilent()) {
            var0.levelEvent(1045, var1, 0);
        }
    }

    @Override
    public DamageSource getFallDamageSource(Entity var0) {
        return DamageSource.fallingStalactite(var0);
    }

    @Override
    public Predicate<Entity> getHurtsEntitySelector() {
        return IEntitySelector.NO_CREATIVE_OR_SPECTATOR.and(IEntitySelector.LIVING_ENTITY_STILL_ALIVE);
    }

    private static void spawnFallingStalactite(IBlockData var0, WorldServer var1, BlockPosition var2) {
        BlockPosition.MutableBlockPosition var3 = var2.mutable();
        IBlockData var4 = var0;
        while (PointedDripstoneBlock.isStalactite(var4)) {
            EntityFallingBlock var5 = EntityFallingBlock.fall(var1, var3, var4);
            if (PointedDripstoneBlock.isTip(var4, true)) {
                int var6 = Math.max(1 + var2.getY() - var3.getY(), 6);
                float var7 = 1.0f * (float)var6;
                var5.setHurtsEntities(var7, 40);
                break;
            }
            var3.move(EnumDirection.DOWN);
            var4 = var1.getBlockState(var3);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        IBlockData var5;
        IBlockData var4 = var1.getBlockState(var2.above(1));
        if (!PointedDripstoneBlock.canGrow(var4, var5 = var1.getBlockState(var2.above(2)))) {
            return;
        }
        BlockPosition var6 = PointedDripstoneBlock.findTip(var0, var1, var2, 7, false);
        if (var6 == null) {
            return;
        }
        IBlockData var7 = var1.getBlockState(var6);
        if (!PointedDripstoneBlock.canDrip(var7) || !PointedDripstoneBlock.canTipGrow(var7, var1, var6)) {
            return;
        }
        if (var3.nextBoolean()) {
            PointedDripstoneBlock.grow(var1, var6, EnumDirection.DOWN);
        } else {
            PointedDripstoneBlock.growStalagmiteBelow(var1, var6);
        }
    }

    private static void growStalagmiteBelow(WorldServer var0, BlockPosition var1) {
        BlockPosition.MutableBlockPosition var2 = var1.mutable();
        for (int var3 = 0; var3 < 10; ++var3) {
            var2.move(EnumDirection.DOWN);
            IBlockData var4 = var0.getBlockState(var2);
            if (!var4.getFluidState().isEmpty()) {
                return;
            }
            if (PointedDripstoneBlock.isUnmergedTipWithDirection(var4, EnumDirection.UP) && PointedDripstoneBlock.canTipGrow(var4, var0, var2)) {
                PointedDripstoneBlock.grow(var0, var2, EnumDirection.UP);
                return;
            }
            if (PointedDripstoneBlock.isValidPointedDripstonePlacement(var0, var2, EnumDirection.UP) && !var0.isWaterAt((BlockPosition)var2.below())) {
                PointedDripstoneBlock.grow(var0, (BlockPosition)var2.below(), EnumDirection.UP);
                return;
            }
            if (PointedDripstoneBlock.canDripThrough(var0, var2, var4)) continue;
            return;
        }
    }

    private static void grow(WorldServer var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition var3 = var1.relative(var2);
        IBlockData var4 = var0.getBlockState(var3);
        if (PointedDripstoneBlock.isUnmergedTipWithDirection(var4, var2.getOpposite())) {
            PointedDripstoneBlock.createMergedTips(var4, var0, var3);
        } else if (var4.isAir() || var4.is(Blocks.WATER)) {
            PointedDripstoneBlock.createDripstone(var0, var3, var2, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(GeneratorAccess var0, BlockPosition var1, EnumDirection var2, DripstoneThickness var3) {
        IBlockData var4 = (IBlockData)((IBlockData)((IBlockData)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue(TIP_DIRECTION, var2)).setValue(THICKNESS, var3)).setValue(WATERLOGGED, var0.getFluidState(var1).getType() == FluidTypes.WATER);
        var0.setBlock(var1, var4, 3);
    }

    private static void createMergedTips(IBlockData var0, GeneratorAccess var1, BlockPosition var2) {
        BlockPosition var3;
        BlockPosition var4;
        if (var0.getValue(TIP_DIRECTION) == EnumDirection.UP) {
            var4 = var2;
            var3 = var2.above();
        } else {
            var3 = var2;
            var4 = var2.below();
        }
        PointedDripstoneBlock.createDripstone(var1, var3, EnumDirection.DOWN, DripstoneThickness.TIP_MERGE);
        PointedDripstoneBlock.createDripstone(var1, var4, EnumDirection.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void spawnDripParticle(World var0, BlockPosition var1, IBlockData var2) {
        PointedDripstoneBlock.getFluidAboveStalactite(var0, var1, var2).ifPresent(var3 -> PointedDripstoneBlock.spawnDripParticle(var0, var1, var2, var3.fluid));
    }

    private static void spawnDripParticle(World var0, BlockPosition var1, IBlockData var2, FluidType var3) {
        Vec3D var4 = var2.getOffset(var0, var1);
        double var5 = 0.0625;
        double var7 = (double)var1.getX() + 0.5 + var4.x;
        double var9 = (double)((float)(var1.getY() + 1) - 0.6875f) - 0.0625;
        double var11 = (double)var1.getZ() + 0.5 + var4.z;
        FluidType var13 = PointedDripstoneBlock.getDripFluid(var0, var3);
        ParticleType var14 = var13.is(TagsFluid.LAVA) ? Particles.DRIPPING_DRIPSTONE_LAVA : Particles.DRIPPING_DRIPSTONE_WATER;
        var0.addParticle(var14, var7, var9, var11, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition findTip(IBlockData var0, GeneratorAccess var12, BlockPosition var22, int var3, boolean var4) {
        if (PointedDripstoneBlock.isTip(var0, var4)) {
            return var22;
        }
        EnumDirection var5 = var0.getValue(TIP_DIRECTION);
        BiPredicate<BlockPosition, IBlockData> var6 = (var1, var2) -> var2.is(Blocks.POINTED_DRIPSTONE) && var2.getValue(TIP_DIRECTION) == var5;
        return PointedDripstoneBlock.findBlockVertical(var12, var22, var5.getAxisDirection(), var6, var1 -> PointedDripstoneBlock.isTip(var1, var4), var3).orElse(null);
    }

    @Nullable
    private static EnumDirection calculateTipDirection(IWorldReader var0, BlockPosition var1, EnumDirection var2) {
        EnumDirection var3;
        if (PointedDripstoneBlock.isValidPointedDripstonePlacement(var0, var1, var2)) {
            var3 = var2;
        } else if (PointedDripstoneBlock.isValidPointedDripstonePlacement(var0, var1, var2.getOpposite())) {
            var3 = var2.getOpposite();
        } else {
            return null;
        }
        return var3;
    }

    private static DripstoneThickness calculateDripstoneThickness(IWorldReader var0, BlockPosition var1, EnumDirection var2, boolean var3) {
        EnumDirection var4 = var2.getOpposite();
        IBlockData var5 = var0.getBlockState(var1.relative(var2));
        if (PointedDripstoneBlock.isPointedDripstoneWithDirection(var5, var4)) {
            if (var3 || var5.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE) {
                return DripstoneThickness.TIP_MERGE;
            }
            return DripstoneThickness.TIP;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneWithDirection(var5, var2)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness var6 = var5.getValue(THICKNESS);
        if (var6 == DripstoneThickness.TIP || var6 == DripstoneThickness.TIP_MERGE) {
            return DripstoneThickness.FRUSTUM;
        }
        IBlockData var7 = var0.getBlockState(var1.relative(var4));
        if (!PointedDripstoneBlock.isPointedDripstoneWithDirection(var7, var2)) {
            return DripstoneThickness.BASE;
        }
        return DripstoneThickness.MIDDLE;
    }

    public static boolean canDrip(IBlockData var0) {
        return PointedDripstoneBlock.isStalactite(var0) && var0.getValue(THICKNESS) == DripstoneThickness.TIP && var0.getValue(WATERLOGGED) == false;
    }

    private static boolean canTipGrow(IBlockData var0, WorldServer var1, BlockPosition var2) {
        EnumDirection var3 = var0.getValue(TIP_DIRECTION);
        BlockPosition var4 = var2.relative(var3);
        IBlockData var5 = var1.getBlockState(var4);
        if (!var5.getFluidState().isEmpty()) {
            return false;
        }
        if (var5.isAir()) {
            return true;
        }
        return PointedDripstoneBlock.isUnmergedTipWithDirection(var5, var3.getOpposite());
    }

    private static Optional<BlockPosition> findRootBlock(World var02, BlockPosition var12, IBlockData var22, int var3) {
        EnumDirection var4 = var22.getValue(TIP_DIRECTION);
        BiPredicate<BlockPosition, IBlockData> var5 = (var1, var2) -> var2.is(Blocks.POINTED_DRIPSTONE) && var2.getValue(TIP_DIRECTION) == var4;
        return PointedDripstoneBlock.findBlockVertical(var02, var12, var4.getOpposite().getAxisDirection(), var5, var0 -> !var0.is(Blocks.POINTED_DRIPSTONE), var3);
    }

    private static boolean isValidPointedDripstonePlacement(IWorldReader var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition var3 = var1.relative(var2.getOpposite());
        IBlockData var4 = var0.getBlockState(var3);
        return var4.isFaceSturdy(var0, var3, var2) || PointedDripstoneBlock.isPointedDripstoneWithDirection(var4, var2);
    }

    private static boolean isTip(IBlockData var0, boolean var1) {
        if (!var0.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        DripstoneThickness var2 = var0.getValue(THICKNESS);
        return var2 == DripstoneThickness.TIP || var1 && var2 == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(IBlockData var0, EnumDirection var1) {
        return PointedDripstoneBlock.isTip(var0, false) && var0.getValue(TIP_DIRECTION) == var1;
    }

    private static boolean isStalactite(IBlockData var0) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(var0, EnumDirection.DOWN);
    }

    private static boolean isStalagmite(IBlockData var0) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(var0, EnumDirection.UP);
    }

    private static boolean isStalactiteStartPos(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return PointedDripstoneBlock.isStalactite(var0) && !var1.getBlockState(var2.above()).is(Blocks.POINTED_DRIPSTONE);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(IBlockData var0, EnumDirection var1) {
        return var0.is(Blocks.POINTED_DRIPSTONE) && var0.getValue(TIP_DIRECTION) == var1;
    }

    @Nullable
    private static BlockPosition findFillableCauldronBelowStalactiteTip(World var0, BlockPosition var12, FluidType var22) {
        Predicate<IBlockData> var3 = var1 -> var1.getBlock() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)var1.getBlock()).canReceiveStalactiteDrip(var22);
        BiPredicate<BlockPosition, IBlockData> var4 = (var1, var2) -> PointedDripstoneBlock.canDripThrough(var0, var1, var2);
        return PointedDripstoneBlock.findBlockVertical(var0, var12, EnumDirection.DOWN.getAxisDirection(), var4, var3, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition findStalactiteTipAboveCauldron(World var0, BlockPosition var12) {
        BiPredicate<BlockPosition, IBlockData> var22 = (var1, var2) -> PointedDripstoneBlock.canDripThrough(var0, var1, var2);
        return PointedDripstoneBlock.findBlockVertical(var0, var12, EnumDirection.UP.getAxisDirection(), var22, PointedDripstoneBlock::canDrip, 11).orElse(null);
    }

    public static FluidType getCauldronFillFluidType(WorldServer var02, BlockPosition var1) {
        return PointedDripstoneBlock.getFluidAboveStalactite(var02, var1, var02.getBlockState(var1)).map(var0 -> var0.fluid).filter(PointedDripstoneBlock::canFillCauldron).orElse(FluidTypes.EMPTY);
    }

    private static Optional<a> getFluidAboveStalactite(World var0, BlockPosition var12, IBlockData var2) {
        if (!PointedDripstoneBlock.isStalactite(var2)) {
            return Optional.empty();
        }
        return PointedDripstoneBlock.findRootBlock(var0, var12, var2, 11).map(var1 -> {
            BlockPosition var2 = var1.above();
            IBlockData var3 = var0.getBlockState(var2);
            FluidType var4 = var3.is(Blocks.MUD) && !var0.dimensionType().ultraWarm() ? FluidTypes.WATER : var0.getFluidState(var2).getType();
            return new a(var2, var4, var3);
        });
    }

    private static boolean canFillCauldron(FluidType var0) {
        return var0 == FluidTypes.LAVA || var0 == FluidTypes.WATER;
    }

    private static boolean canGrow(IBlockData var0, IBlockData var1) {
        return var0.is(Blocks.DRIPSTONE_BLOCK) && var1.is(Blocks.WATER) && var1.getFluidState().isSource();
    }

    private static FluidType getDripFluid(World var0, FluidType var1) {
        if (var1.isSame(FluidTypes.EMPTY)) {
            return var0.dimensionType().ultraWarm() ? FluidTypes.LAVA : FluidTypes.WATER;
        }
        return var1;
    }

    private static Optional<BlockPosition> findBlockVertical(GeneratorAccess var0, BlockPosition var1, EnumDirection.EnumAxisDirection var2, BiPredicate<BlockPosition, IBlockData> var3, Predicate<IBlockData> var4, int var5) {
        EnumDirection var6 = EnumDirection.get(var2, EnumDirection.EnumAxis.Y);
        BlockPosition.MutableBlockPosition var7 = var1.mutable();
        for (int var8 = 1; var8 < var5; ++var8) {
            var7.move(var6);
            IBlockData var9 = var0.getBlockState(var7);
            if (var4.test(var9)) {
                return Optional.of(var7.immutable());
            }
            if (!var0.isOutsideBuildHeight(var7.getY()) && var3.test(var7, var9)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        if (var2.isAir()) {
            return true;
        }
        if (var2.isSolidRender(var0, var1)) {
            return false;
        }
        if (!var2.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape var3 = var2.getCollisionShape(var0, var1);
        return !VoxelShapes.joinIsNotEmpty(REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, var3, OperatorBoolean.AND);
    }

    static final class a
    extends Record {
        final BlockPosition pos;
        final FluidType fluid;
        final IBlockData sourceState;

        a(BlockPosition var0, FluidType var1, IBlockData var2) {
            this.pos = var0;
            this.fluid = var1;
            this.sourceState = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;fluid;sourceState", "pos", "fluid", "sourceState"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;fluid;sourceState", "pos", "fluid", "sourceState"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;fluid;sourceState", "pos", "fluid", "sourceState"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public FluidType fluid() {
            return this.fluid;
        }

        public IBlockData sourceState() {
            return this.sourceState;
        }
    }
}

