/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class HangingRootsBlock
extends Block
implements IBlockWaterlogged {
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box(2.0, 10.0, 2.0, 14.0, 16.0, 14.0);

    protected HangingRootsBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(WATERLOGGED);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = super.getStateForPlacement(var0);
        if (var1 != null) {
            Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
            return (IBlockData)var1.setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
        }
        return null;
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.above();
        IBlockData var4 = var1.getBlockState(var3);
        return var4.isFaceSturdy(var1, var3, EnumDirection.DOWN);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && !this.canSurvive(var0, var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }
}

