/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class CeilingHangingSignBlock
extends BlockSign {
    public static final BlockStateInteger ROTATION = BlockProperties.ROTATION_16;
    public static final BlockStateBoolean ATTACHED = BlockProperties.ATTACHED;
    protected static final float AABB_OFFSET = 5.0f;
    protected static final VoxelShape SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final Map<Integer, VoxelShape> AABBS = Maps.newHashMap((Map)ImmutableMap.of((Object)0, (Object)Block.box(1.0, 0.0, 7.0, 15.0, 10.0, 9.0), (Object)4, (Object)Block.box(7.0, 0.0, 1.0, 9.0, 10.0, 15.0), (Object)8, (Object)Block.box(1.0, 0.0, 7.0, 15.0, 10.0, 9.0), (Object)12, (Object)Block.box(7.0, 0.0, 1.0, 9.0, 10.0, 15.0)));

    public CeilingHangingSignBlock(BlockBase.Info var0, BlockPropertyWood var1) {
        super(var0, var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(ROTATION, 0)).setValue(ATTACHED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign var6 = (TileEntitySign)tileEntity;
            ItemStack var7 = var3.getItemInHand(var4);
            if (!var6.hasAnyClickCommands(var3) && var7.getItem() instanceof ItemBlock) {
                return EnumInteractionResult.PASS;
            }
        }
        return super.use(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.above()).isFaceSturdy(var1, var2.above(), EnumDirection.DOWN, EnumBlockSupport.CENTER);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        boolean var7;
        World var1 = var0.getLevel();
        Fluid var2 = var1.getFluidState(var0.getClickedPos());
        BlockPosition var3 = var0.getClickedPos().above();
        IBlockData var4 = var1.getBlockState(var3);
        boolean var5 = var4.is(TagsBlock.ALL_HANGING_SIGNS);
        EnumDirection var6 = EnumDirection.fromYRot(var0.getRotation());
        boolean bl = var7 = !Block.isFaceFull(var4.getCollisionShape(var1, var3), EnumDirection.DOWN) || var0.isSecondaryUseActive();
        if (var5 && !var0.isSecondaryUseActive()) {
            Object var8;
            if (var4.hasProperty(WallHangingSignBlock.FACING)) {
                var8 = var4.getValue(WallHangingSignBlock.FACING);
                if (((EnumDirection)var8).getAxis().test(var6)) {
                    var7 = false;
                }
            } else if (var4.hasProperty(ROTATION) && ((Optional)(var8 = RotationSegment.convertToDirection(var4.getValue(ROTATION)))).isPresent() && ((EnumDirection)((Optional)var8).get()).getAxis().test(var6)) {
                var7 = false;
            }
        }
        int var8 = !var7 ? RotationSegment.convertToSegment(var6) : RotationSegment.convertToSegment(var0.getRotation());
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(ATTACHED, var7)).setValue(ROTATION, var8)).setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        VoxelShape var4 = AABBS.get(var0.getValue(ROTATION));
        return var4 == null ? SHAPE : var4;
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return this.getShape(var0, var1, var2, VoxelShapeCollision.empty());
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && !this.canSurvive(var0, var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.rotate(var0.getValue(ROTATION), 16));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.mirror(var0.getValue(ROTATION), 16));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(ROTATION, ATTACHED, WATERLOGGED);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new HangingSignBlockEntity(var0, var1);
    }
}

