/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockWaterLily
extends BlockPlant {
    protected static final VoxelShape AABB = Block.box(1.0, 0.0, 1.0, 15.0, 1.5, 15.0);

    protected BlockWaterLily(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        super.entityInside(var0, var1, var2, var3);
        if (var1 instanceof WorldServer && var3 instanceof EntityBoat) {
            var1.destroyBlock(new BlockPosition(var2), true, var3);
        }
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return AABB;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        Fluid var3 = var1.getFluidState(var2);
        Fluid var4 = var1.getFluidState(var2.above());
        return (var3.getType() == FluidTypes.WATER || var0.getMaterial() == Material.ICE) && var4.getType() == FluidTypes.EMPTY;
    }
}

