/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockSkull
extends BlockSkullAbstract {
    public static final int MAX = RotationSegment.getMaxSegmentIndex();
    private static final int ROTATIONS = MAX + 1;
    public static final BlockStateInteger ROTATION = BlockProperties.ROTATION_16;
    protected static final VoxelShape SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 8.0, 12.0);
    protected static final VoxelShape PIGLIN_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);

    protected BlockSkull(a var0, BlockBase.Info var1) {
        super(var0, var1);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(ROTATION, 0));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (this.getType() == Type.PIGLIN) {
            return PIGLIN_SHAPE;
        }
        return SHAPE;
    }

    @Override
    public VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(ROTATION, RotationSegment.convertToSegment(var0.getRotation() + 180.0f));
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.rotate(var0.getValue(ROTATION), ROTATIONS));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.mirror(var0.getValue(ROTATION), ROTATIONS));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(ROTATION);
    }

    public static interface a {
    }

    public static final class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type SKELETON = new Type();
        public static final /* enum */ Type WITHER_SKELETON = new Type();
        public static final /* enum */ Type PLAYER = new Type();
        public static final /* enum */ Type ZOMBIE = new Type();
        public static final /* enum */ Type CREEPER = new Type();
        public static final /* enum */ Type PIGLIN = new Type();
        public static final /* enum */ Type DRAGON = new Type();
        private static final /* synthetic */ Type[] h;

        public static Type[] values() {
            return (Type[])h.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{SKELETON, WITHER_SKELETON, PLAYER, ZOMBIE, CREEPER, PIGLIN, DRAGON};
        }

        static {
            h = Type.a();
        }
    }
}

