/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Iterator;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockScaffolding
extends Block
implements IBlockWaterlogged {
    private static final int TICK_DELAY = 1;
    private static final VoxelShape STABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE_BOTTOM;
    private static final VoxelShape BELOW_BLOCK;
    public static final int STABILITY_MAX_DISTANCE = 7;
    public static final BlockStateInteger DISTANCE;
    public static final BlockStateBoolean WATERLOGGED;
    public static final BlockStateBoolean BOTTOM;

    protected BlockScaffolding(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(WATERLOGGED, false)).setValue(BOTTOM, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(DISTANCE, WATERLOGGED, BOTTOM);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (!var3.isHoldingItem(var0.getBlock().asItem())) {
            return var0.getValue(BOTTOM) != false ? UNSTABLE_SHAPE : STABLE_SHAPE;
        }
        return VoxelShapes.block();
    }

    @Override
    public VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.block();
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return var1.getItemInHand().is(this.asItem());
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        int var3 = BlockScaffolding.getDistance(var2, var1);
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var2.getFluidState(var1).getType() == FluidTypes.WATER)).setValue(DISTANCE, var3)).setValue(BOTTOM, this.isBottom(var2, var1, var3));
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (!var1.isClientSide) {
            var1.scheduleTick(var2, this, 1);
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        if (!var3.isClientSide()) {
            var3.scheduleTick(var4, this, 1);
        }
        return var0;
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = BlockScaffolding.getDistance(var1, var2);
        IBlockData var5 = (IBlockData)((IBlockData)var0.setValue(DISTANCE, var4)).setValue(BOTTOM, this.isBottom(var1, var2, var4));
        if (var5.getValue(DISTANCE) == 7) {
            if (var0.getValue(DISTANCE) == 7) {
                EntityFallingBlock.fall(var1, var2, var5);
            } else {
                var1.destroyBlock(var2, true);
            }
        } else if (var0 != var5) {
            var1.setBlock(var2, var5, 3);
        }
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockScaffolding.getDistance(var1, var2) < 7;
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (!var3.isAbove(VoxelShapes.block(), var2, true) || var3.isDescending()) {
            if (var0.getValue(DISTANCE) != 0 && var0.getValue(BOTTOM).booleanValue() && var3.isAbove(BELOW_BLOCK, var2, true)) {
                return UNSTABLE_SHAPE_BOTTOM;
            }
            return VoxelShapes.empty();
        }
        return STABLE_SHAPE;
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    private boolean isBottom(IBlockAccess var0, BlockPosition var1, int var2) {
        return var2 > 0 && !var0.getBlockState(var1.below()).is(this);
    }

    public static int getDistance(IBlockAccess var0, BlockPosition var1) {
        EnumDirection var6;
        IBlockData var7;
        BlockPosition.MutableBlockPosition var2 = var1.mutable().move(EnumDirection.DOWN);
        IBlockData var3 = var0.getBlockState(var2);
        int var4 = 7;
        if (var3.is(Blocks.SCAFFOLDING)) {
            var4 = var3.getValue(DISTANCE);
        } else if (var3.isFaceSturdy(var0, var2, EnumDirection.UP)) {
            return 0;
        }
        Iterator<EnumDirection> iterator = EnumDirection.EnumDirectionLimit.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(var7 = var0.getBlockState(var2.setWithOffset((BaseBlockPosition)var1, var6 = iterator.next()))).is(Blocks.SCAFFOLDING) || (var4 = Math.min(var4, var7.getValue(DISTANCE) + 1)) != 1)) {
        }
        return var4;
    }

    static {
        UNSTABLE_SHAPE_BOTTOM = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        BELOW_BLOCK = VoxelShapes.block().move(0.0, -1.0, 0.0);
        DISTANCE = BlockProperties.STABILITY_DISTANCE;
        WATERLOGGED = BlockProperties.WATERLOGGED;
        BOTTOM = BlockProperties.BOTTOM;
        VoxelShape var0 = Block.box(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
        VoxelShape var1 = Block.box(0.0, 0.0, 0.0, 2.0, 16.0, 2.0);
        VoxelShape var2 = Block.box(14.0, 0.0, 0.0, 16.0, 16.0, 2.0);
        VoxelShape var3 = Block.box(0.0, 0.0, 14.0, 2.0, 16.0, 16.0);
        VoxelShape var4 = Block.box(14.0, 0.0, 14.0, 16.0, 16.0, 16.0);
        STABLE_SHAPE = VoxelShapes.or(var0, var1, var2, var3, var4);
        VoxelShape var5 = Block.box(0.0, 0.0, 0.0, 2.0, 2.0, 16.0);
        VoxelShape var6 = Block.box(14.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        VoxelShape var7 = Block.box(0.0, 0.0, 14.0, 16.0, 2.0, 16.0);
        VoxelShape var8 = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 2.0);
        UNSTABLE_SHAPE = VoxelShapes.or(UNSTABLE_SHAPE_BOTTOM, STABLE_SHAPE, var6, var5, var8, var7);
    }
}

