/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockRedstoneOre
extends Block {
    public static final BlockStateBoolean LIT = BlockRedstoneTorch.LIT;

    public BlockRedstoneOre(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(LIT, false));
    }

    @Override
    public void attack(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        BlockRedstoneOre.interact(var0, var1, var2);
        super.attack(var0, var1, var2, var3);
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
        if (!var3.isSteppingCarefully()) {
            BlockRedstoneOre.interact(var2, var0, var1);
        }
        super.stepOn(var0, var1, var2, var3);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            BlockRedstoneOre.spawnParticles(var1, var2);
        } else {
            BlockRedstoneOre.interact(var0, var1, var2);
        }
        ItemStack var6 = var3.getItemInHand(var4);
        if (var6.getItem() instanceof ItemBlock && new BlockActionContext(var3, var4, var6, var5).canPlace()) {
            return EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.SUCCESS;
    }

    private static void interact(IBlockData var0, World var1, BlockPosition var2) {
        BlockRedstoneOre.spawnParticles(var1, var2);
        if (!var0.getValue(LIT).booleanValue()) {
            var1.setBlock(var2, (IBlockData)var0.setValue(LIT, true), 3);
        }
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(LIT);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(LIT).booleanValue()) {
            var1.setBlock(var2, (IBlockData)var0.setValue(LIT, false), 3);
        }
    }

    @Override
    public void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
        super.spawnAfterBreak(var0, var1, var2, var3, var4);
        if (var4 && EnchantmentManager.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, var3) == 0) {
            int var5 = 1 + var1.random.nextInt(5);
            this.popExperience(var1, var2, var5);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(LIT).booleanValue()) {
            BlockRedstoneOre.spawnParticles(var1, var2);
        }
    }

    private static void spawnParticles(World var0, BlockPosition var1) {
        double var2 = 0.5625;
        RandomSource var4 = var0.random;
        for (EnumDirection var8 : EnumDirection.values()) {
            BlockPosition var9 = var1.relative(var8);
            if (var0.getBlockState(var9).isSolidRender(var0, var9)) continue;
            EnumDirection.EnumAxis var10 = var8.getAxis();
            double var11 = var10 == EnumDirection.EnumAxis.X ? 0.5 + 0.5625 * (double)var8.getStepX() : (double)var4.nextFloat();
            double var13 = var10 == EnumDirection.EnumAxis.Y ? 0.5 + 0.5625 * (double)var8.getStepY() : (double)var4.nextFloat();
            double var15 = var10 == EnumDirection.EnumAxis.Z ? 0.5 + 0.5625 * (double)var8.getStepZ() : (double)var4.nextFloat();
            var0.addParticle(ParticleParamRedstone.REDSTONE, (double)var1.getX() + var11, (double)var1.getY() + var13, (double)var1.getZ() + var15, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LIT);
    }
}

