/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.AxisAlignedBB;

public class BlockPressurePlateBinary
extends BlockPressurePlateAbstract {
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private final EnumMobType sensitivity;
    private final SoundEffect soundOff;
    private final SoundEffect soundOn;

    protected BlockPressurePlateBinary(EnumMobType var0, BlockBase.Info var1, SoundEffect var2, SoundEffect var3) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false));
        this.sensitivity = var0;
        this.soundOff = var2;
        this.soundOn = var3;
    }

    @Override
    protected int getSignalForState(IBlockData var0) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected IBlockData setSignalForState(IBlockData var0, int var1) {
        return (IBlockData)var0.setValue(POWERED, var1 > 0);
    }

    @Override
    protected void playOnSound(GeneratorAccess var0, BlockPosition var1) {
        var0.playSound(null, var1, this.soundOn, SoundCategory.BLOCKS);
    }

    @Override
    protected void playOffSound(GeneratorAccess var0, BlockPosition var1) {
        var0.playSound(null, var1, this.soundOff, SoundCategory.BLOCKS);
    }

    @Override
    protected int getSignalStrength(World var0, BlockPosition var1) {
        List<Entity> var3;
        AxisAlignedBB var2 = TOUCH_AABB.move(var1);
        switch (this.sensitivity) {
            case EVERYTHING: {
                var3 = var0.getEntities(null, var2);
                break;
            }
            case MOBS: {
                var3 = var0.getEntitiesOfClass(EntityLiving.class, var2);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!var3.isEmpty()) {
            for (Entity var5 : var3) {
                if (var5.isIgnoringBlockTriggers()) continue;
                return 15;
            }
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWERED);
    }

    public static final class EnumMobType
    extends Enum<EnumMobType> {
        public static final /* enum */ EnumMobType EVERYTHING = new EnumMobType();
        public static final /* enum */ EnumMobType MOBS = new EnumMobType();
        private static final /* synthetic */ EnumMobType[] c;

        public static EnumMobType[] values() {
            return (EnumMobType[])c.clone();
        }

        public static EnumMobType valueOf(String var0) {
            return Enum.valueOf(EnumMobType.class, var0);
        }

        private static /* synthetic */ EnumMobType[] a() {
            return new EnumMobType[]{EVERYTHING, MOBS};
        }

        static {
            c = EnumMobType.a();
        }
    }
}

