/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockNote
extends Block {
    public static final BlockStateEnum<BlockPropertyInstrument> INSTRUMENT = BlockProperties.NOTEBLOCK_INSTRUMENT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateInteger NOTE = BlockProperties.NOTE;
    public static final int NOTE_VOLUME = 3;

    public BlockNote(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(INSTRUMENT, BlockPropertyInstrument.HARP)).setValue(NOTE, 0)).setValue(POWERED, false));
    }

    private static boolean isFeatureFlagEnabled(GeneratorAccess var0) {
        return var0.enabledFeatures().contains(FeatureFlags.UPDATE_1_20);
    }

    private IBlockData setInstrument(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        if (BlockNote.isFeatureFlagEnabled(var0)) {
            IBlockData var3 = var0.getBlockState(var1.above());
            return (IBlockData)var2.setValue(INSTRUMENT, BlockPropertyInstrument.byStateAbove(var3).orElseGet(() -> BlockPropertyInstrument.byStateBelow(var0.getBlockState(var1.below()))));
        }
        return (IBlockData)var2.setValue(INSTRUMENT, BlockPropertyInstrument.byStateBelow(var0.getBlockState(var1.below())));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.setInstrument(var0.getLevel(), var0.getClickedPos(), this.defaultBlockState());
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        boolean var6;
        boolean bl = BlockNote.isFeatureFlagEnabled(var3) ? var1.getAxis() == EnumDirection.EnumAxis.Y : (var6 = var1 == EnumDirection.DOWN);
        if (var6) {
            return this.setInstrument(var3, var4, var0);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            if (var6) {
                this.playNote(null, var0, var1, var2);
            }
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 3);
        }
    }

    private void playNote(@Nullable Entity var0, IBlockData var1, World var2, BlockPosition var3) {
        if (!var1.getValue(INSTRUMENT).requiresAirAbove() || var2.getBlockState(var3.above()).isAir()) {
            var2.blockEvent(var3, this, 0, 0);
            var2.gameEvent(var0, GameEvent.NOTE_BLOCK_PLAY, var3);
        }
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        var0 = (IBlockData)var0.cycle(NOTE);
        var1.setBlock(var2, var0, 3);
        this.playNote(var3, var0, var1, var2);
        var3.awardStat(StatisticList.TUNE_NOTEBLOCK);
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public void attack(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        if (var1.isClientSide) {
            return;
        }
        this.playNote(var3, var0, var1, var2);
        var3.awardStat(StatisticList.PLAY_NOTEBLOCK);
    }

    @Override
    public boolean triggerEvent(IBlockData var0, World var1, BlockPosition var2, int var3, int var4) {
        Holder<SoundEffect> var7;
        float var5;
        BlockPropertyInstrument var6 = var0.getValue(INSTRUMENT);
        if (var6.isTunable()) {
            int var72 = var0.getValue(NOTE);
            var5 = (float)Math.pow(2.0, (double)(var72 - 12) / 12.0);
            var1.addParticle(Particles.NOTE, (double)var2.getX() + 0.5, (double)var2.getY() + 1.2, (double)var2.getZ() + 0.5, (double)var72 / 24.0, 0.0, 0.0);
        } else {
            var5 = 1.0f;
        }
        if (var6.hasCustomSound()) {
            MinecraftKey var8 = this.getCustomSoundId(var1, var2);
            if (var8 == null) {
                return false;
            }
            var7 = Holder.direct(SoundEffect.createVariableRangeEvent(var8));
        } else {
            var7 = var6.getSoundEvent();
        }
        var1.playSeededSound(null, (double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, var7, SoundCategory.RECORDS, 3.0f, var5, var1.random.nextLong());
        return true;
    }

    @Nullable
    private MinecraftKey getCustomSoundId(World var0, BlockPosition var1) {
        TileEntity tileEntity = var0.getBlockEntity(var1.above());
        if (tileEntity instanceof TileEntitySkull) {
            TileEntitySkull var2 = (TileEntitySkull)tileEntity;
            return var2.getNoteBlockSound();
        }
        return null;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(INSTRUMENT, POWERED, NOTE);
    }
}

