/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockMobSpawner
extends BlockTileEntity {
    protected BlockMobSpawner(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityMobSpawner(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockMobSpawner.createTickerHelper(var2, TileEntityTypes.MOB_SPAWNER, var0.isClientSide ? TileEntityMobSpawner::clientTick : TileEntityMobSpawner::serverTick);
    }

    @Override
    public void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
        super.spawnAfterBreak(var0, var1, var2, var3, var4);
        if (var4) {
            int var5 = 15 + var1.random.nextInt(15) + var1.random.nextInt(15);
            this.popExperience(var1, var2, var5);
        }
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable IBlockAccess var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        Optional<IChatBaseComponent> var4 = this.getSpawnEntityDisplayName(var0);
        if (var4.isPresent()) {
            var2.add(var4.get());
        } else {
            var2.add(CommonComponents.EMPTY);
            var2.add(IChatBaseComponent.translatable("block.minecraft.spawner.desc1").withStyle(EnumChatFormat.GRAY));
            var2.add(IChatBaseComponent.literal(" ").append(IChatBaseComponent.translatable("block.minecraft.spawner.desc2").withStyle(EnumChatFormat.BLUE)));
        }
    }

    private Optional<IChatBaseComponent> getSpawnEntityDisplayName(ItemStack var02) {
        String var2;
        MinecraftKey var3;
        NBTTagCompound var1 = ItemBlock.getBlockEntityData(var02);
        if (var1 != null && var1.contains("SpawnData", 10) && (var3 = MinecraftKey.tryParse(var2 = var1.getCompound("SpawnData").getCompound("entity").getString("id"))) != null) {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(var3).map(var0 -> IChatBaseComponent.translatable(var0.getDescriptionId()).withStyle(EnumChatFormat.GRAY));
        }
        return Optional.empty();
    }
}

