/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockDropper
extends BlockDispenser {
    private static final IDispenseBehavior DISPENSE_BEHAVIOUR = new DispenseBehaviorItem();

    public BlockDropper(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected IDispenseBehavior getDispenseMethod(ItemStack var0) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityDropper(var0, var1);
    }

    @Override
    public void dispenseFrom(WorldServer var0, BlockPosition var1) {
        ItemStack var8;
        SourceBlock var2 = new SourceBlock(var0, var1);
        TileEntityDispenser var3 = (TileEntityDispenser)var2.getEntity();
        int var4 = var3.getRandomSlot(var0.random);
        if (var4 < 0) {
            var0.levelEvent(1001, var1, 0);
            return;
        }
        ItemStack var5 = var3.getItem(var4);
        if (var5.isEmpty()) {
            return;
        }
        EnumDirection var6 = var0.getBlockState(var1).getValue(FACING);
        IInventory var7 = TileEntityHopper.getContainerAt(var0, var1.relative(var6));
        if (var7 == null) {
            var8 = DISPENSE_BEHAVIOUR.dispense(var2, var5);
        } else {
            var8 = TileEntityHopper.addItem(var3, var7, var5.copy().split(1), var6.getOpposite());
            if (var8.isEmpty()) {
                var8 = var5.copy();
                var8.shrink(1);
            } else {
                var8 = var5.copy();
            }
        }
        var3.setItem(var4, var8);
    }
}

