/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockCake
extends Block {
    public static final int MAX_BITES = 6;
    public static final BlockStateInteger BITES = BlockProperties.BITES;
    public static final int FULL_CAKE_SIGNAL = BlockCake.getOutputSignal(0);
    protected static final float AABB_OFFSET = 1.0f;
    protected static final float AABB_SIZE_PER_BITE = 2.0f;
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box(1.0, 0.0, 1.0, 15.0, 8.0, 15.0), Block.box(3.0, 0.0, 1.0, 15.0, 8.0, 15.0), Block.box(5.0, 0.0, 1.0, 15.0, 8.0, 15.0), Block.box(7.0, 0.0, 1.0, 15.0, 8.0, 15.0), Block.box(9.0, 0.0, 1.0, 15.0, 8.0, 15.0), Block.box(11.0, 0.0, 1.0, 15.0, 8.0, 15.0), Block.box(13.0, 0.0, 1.0, 15.0, 8.0, 15.0)};

    protected BlockCake(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(BITES, 0));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE_BY_BITE[var0.getValue(BITES)];
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        Block var8;
        ItemStack var6 = var3.getItemInHand(var4);
        Item var7 = var6.getItem();
        if (var6.is(TagsItem.CANDLES) && var0.getValue(BITES) == 0 && (var8 = Block.byItem(var7)) instanceof CandleBlock) {
            if (!var3.isCreative()) {
                var6.shrink(1);
            }
            var1.playSound(null, var2, SoundEffects.CAKE_ADD_CANDLE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var1.setBlockAndUpdate(var2, CandleCakeBlock.byCandle(var8));
            var1.gameEvent((Entity)var3, GameEvent.BLOCK_CHANGE, var2);
            var3.awardStat(StatisticList.ITEM_USED.get(var7));
            return EnumInteractionResult.SUCCESS;
        }
        if (var1.isClientSide) {
            if (BlockCake.eat(var1, var2, var0, var3).consumesAction()) {
                return EnumInteractionResult.SUCCESS;
            }
            if (var6.isEmpty()) {
                return EnumInteractionResult.CONSUME;
            }
        }
        return BlockCake.eat(var1, var2, var0, var3);
    }

    protected static EnumInteractionResult eat(GeneratorAccess var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var3.canEat(false)) {
            return EnumInteractionResult.PASS;
        }
        var3.awardStat(StatisticList.EAT_CAKE_SLICE);
        var3.getFoodData().eat(2, 0.1f);
        int var4 = var2.getValue(BITES);
        var0.gameEvent((Entity)var3, GameEvent.EAT, var1);
        if (var4 < 6) {
            var0.setBlock(var1, (IBlockData)var2.setValue(BITES, var4 + 1), 3);
        } else {
            var0.removeBlock(var1, false);
            var0.gameEvent((Entity)var3, GameEvent.BLOCK_DESTROY, var1);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.below()).getMaterial().isSolid();
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(BITES);
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return BlockCake.getOutputSignal(var0.getValue(BITES));
    }

    public static int getOutputSignal(int var0) {
        return (7 - var0) * 2;
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

