/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class WorldChunkManagerMultiNoise
extends WorldChunkManager {
    public static final MapCodec<WorldChunkManagerMultiNoise> DIRECT_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.nonEmptyList(RecordCodecBuilder.create(var0 -> var0.group((App)Climate.d.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)BiomeBase.CODEC.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)var0, Pair::of)).listOf()).xmap(Climate.c::new, Climate.c::values).fieldOf("biomes").forGetter(var0 -> var0.parameters)).apply((Applicative)var02, WorldChunkManagerMultiNoise::new));
    public static final Codec<WorldChunkManagerMultiNoise> CODEC = Codec.mapEither(b.CODEC, DIRECT_CODEC).xmap(var0 -> (WorldChunkManagerMultiNoise)var0.map(b::biomeSource, Function.identity()), var0 -> var0.preset().map(Either::left).orElseGet(() -> Either.right((Object)var0))).codec();
    private final Climate.c<Holder<BiomeBase>> parameters;
    private final Optional<b> preset;

    private WorldChunkManagerMultiNoise(Climate.c<Holder<BiomeBase>> var0) {
        this(var0, Optional.empty());
    }

    WorldChunkManagerMultiNoise(Climate.c<Holder<BiomeBase>> var0, Optional<b> var1) {
        super(var0.values().stream().map(Pair::getSecond));
        this.preset = var1;
        this.parameters = var0;
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    private Optional<b> preset() {
        return this.preset;
    }

    public boolean stable(a var0) {
        return this.preset.isPresent() && Objects.equals(this.preset.get().preset(), var0);
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.getNoiseBiome(var3.sample(var0, var1, var2));
    }

    @VisibleForDebug
    public Holder<BiomeBase> getNoiseBiome(Climate.h var0) {
        return this.parameters.findValue(var0);
    }

    @Override
    public void addDebugInfo(List<String> var0, BlockPosition var1, Climate.Sampler var2) {
        int var3 = QuartPos.fromBlock(var1.getX());
        int var4 = QuartPos.fromBlock(var1.getY());
        int var5 = QuartPos.fromBlock(var1.getZ());
        Climate.h var6 = var2.sample(var3, var4, var5);
        float var7 = Climate.unquantizeCoord(var6.continentalness());
        float var8 = Climate.unquantizeCoord(var6.erosion());
        float var9 = Climate.unquantizeCoord(var6.temperature());
        float var10 = Climate.unquantizeCoord(var6.humidity());
        float var11 = Climate.unquantizeCoord(var6.weirdness());
        double var12 = NoiseRouterData.peaksAndValleys(var11);
        OverworldBiomeBuilder var14 = new OverworldBiomeBuilder();
        var0.add("Biome builder PV: " + OverworldBiomeBuilder.getDebugStringForPeaksAndValleys(var12) + " C: " + var14.getDebugStringForContinentalness(var7) + " E: " + var14.getDebugStringForErosion(var8) + " T: " + var14.getDebugStringForTemperature(var9) + " H: " + var14.getDebugStringForHumidity(var10));
    }

    record b(a preset, HolderGetter<BiomeBase> biomes) {
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)MinecraftKey.CODEC.flatXmap(var0 -> Optional.ofNullable(a.BY_NAME.get(var0)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + var0))), var0 -> DataResult.success((Object)var0.name)).fieldOf("preset").stable().forGetter(b::preset), RegistryOps.retrieveGetter(Registries.BIOME)).apply((Applicative)var02, var02.stable(b::new)));

        public WorldChunkManagerMultiNoise biomeSource() {
            return this.preset.biomeSource(this, true);
        }
    }

    public static class a {
        static final Map<MinecraftKey, a> BY_NAME = Maps.newHashMap();
        public static final a NETHER = new a(new MinecraftKey("nether"), var0 -> new Climate.c(ImmutableList.of((Object)Pair.of((Object)Climate.parameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.getOrThrow(Biomes.NETHER_WASTES)), (Object)Pair.of((Object)Climate.parameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.getOrThrow(Biomes.SOUL_SAND_VALLEY)), (Object)Pair.of((Object)Climate.parameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.getOrThrow(Biomes.CRIMSON_FOREST)), (Object)Pair.of((Object)Climate.parameters(0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.375f), var0.getOrThrow(Biomes.WARPED_FOREST)), (Object)Pair.of((Object)Climate.parameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.175f), var0.getOrThrow(Biomes.BASALT_DELTAS)))));
        public static final a OVERWORLD = new a(new MinecraftKey("overworld"), var0 -> {
            ImmutableList.Builder var1 = ImmutableList.builder();
            new OverworldBiomeBuilder().addBiomes(var2 -> var1.add((Object)var2.mapSecond(var0::getOrThrow)));
            return new Climate.c(var1.build());
        });
        final MinecraftKey name;
        private final Function<HolderGetter<BiomeBase>, Climate.c<Holder<BiomeBase>>> parameterSource;

        public a(MinecraftKey var0, Function<HolderGetter<BiomeBase>, Climate.c<Holder<BiomeBase>>> var1) {
            this.name = var0;
            this.parameterSource = var1;
            BY_NAME.put(var0, this);
        }

        @VisibleForDebug
        public static Stream<Pair<MinecraftKey, a>> getPresets() {
            return BY_NAME.entrySet().stream().map(var0 -> Pair.of((Object)((MinecraftKey)var0.getKey()), (Object)((a)var0.getValue())));
        }

        WorldChunkManagerMultiNoise biomeSource(b var0, boolean var1) {
            Climate.c<Holder<BiomeBase>> var2 = this.parameterSource.apply(var0.biomes());
            return new WorldChunkManagerMultiNoise(var2, var1 ? Optional.of(var0) : Optional.empty());
        }

        public WorldChunkManagerMultiNoise biomeSource(HolderGetter<BiomeBase> var0, boolean var1) {
            return this.biomeSource(new b(this, var0), var1);
        }

        public WorldChunkManagerMultiNoise biomeSource(HolderGetter<BiomeBase> var0) {
            return this.biomeSource(var0, true);
        }

        public Stream<ResourceKey<BiomeBase>> possibleBiomes(HolderGetter<BiomeBase> var02) {
            return this.biomeSource(var02).possibleBiomes().stream().flatMap(var0 -> var0.unwrapKey().stream());
        }
    }
}

