/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    public int spawnDelay = 20;
    public SimpleWeightedRandomList<MobSpawnerData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    public MobSpawnerData nextSpawnData;
    private double spin;
    private double oSpin;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;

    public void setEntityId(EntityTypes<?> var0, @Nullable World var1, RandomSource var2, BlockPosition var3) {
        this.getOrCreateNextSpawnData(var1, var2, var3).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(var0).toString());
    }

    private boolean isNearPlayer(World var0, BlockPosition var1) {
        return var0.hasNearbyAlivePlayer((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(World var0, BlockPosition var1) {
        if (!this.isNearPlayer(var0, var1)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource var2 = var0.getRandom();
            double var3 = (double)var1.getX() + var2.nextDouble();
            double var5 = (double)var1.getY() + var2.nextDouble();
            double var7 = (double)var1.getZ() + var2.nextDouble();
            var0.addParticle(Particles.SMOKE, var3, var5, var7, 0.0, 0.0, 0.0);
            var0.addParticle(Particles.FLAME, var3, var5, var7, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(WorldServer var0, BlockPosition var1) {
        if (!this.isNearPlayer(var0, var1)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay(var0, var1);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean var2 = false;
        RandomSource var3 = var0.getRandom();
        MobSpawnerData var4 = this.getOrCreateNextSpawnData(var0, var3, var1);
        for (int var5 = 0; var5 < this.spawnCount; ++var5) {
            Object var17;
            double var14;
            NBTTagCompound var62 = var4.getEntityToSpawn();
            Optional<EntityTypes<?>> var7 = EntityTypes.by(var62);
            if (var7.isEmpty()) {
                this.delay(var0, var1);
                return;
            }
            NBTTagList var8 = var62.getList("Pos", 6);
            int var9 = var8.size();
            double var10 = var9 >= 1 ? var8.getDouble(0) : (double)var1.getX() + (var3.nextDouble() - var3.nextDouble()) * (double)this.spawnRange + 0.5;
            double var12 = var9 >= 2 ? var8.getDouble(1) : (double)(var1.getY() + var3.nextInt(3) - 1);
            double d2 = var14 = var9 >= 3 ? var8.getDouble(2) : (double)var1.getZ() + (var3.nextDouble() - var3.nextDouble()) * (double)this.spawnRange + 0.5;
            if (!var0.noCollision(var7.get().getAABB(var10, var12, var14))) continue;
            BlockPosition var16 = new BlockPosition(var10, var12, var14);
            if (!var4.getCustomSpawnRules().isPresent() ? !EntityPositionTypes.checkSpawnRules(var7.get(), var0, EnumMobSpawn.SPAWNER, var16, var0.getRandom()) : !var7.get().getCategory().isFriendly() && var0.getDifficulty() == EnumDifficulty.PEACEFUL || !((MobSpawnerData.a)(var17 = var4.getCustomSpawnRules().get())).blockLightLimit().isValueInRange(var0.getBrightness(EnumSkyBlock.BLOCK, var16)) || !((MobSpawnerData.a)var17).skyLightLimit().isValueInRange(var0.getBrightness(EnumSkyBlock.SKY, var16))) continue;
            var17 = EntityTypes.loadEntityRecursive(var62, var0, var6 -> {
                var6.moveTo(var10, var12, var14, var6.getYRot(), var6.getXRot());
                return var6;
            });
            if (var17 == null) {
                this.delay(var0, var1);
                return;
            }
            int var18 = var0.getEntitiesOfClass(var17.getClass(), new AxisAlignedBB(var1.getX(), var1.getY(), var1.getZ(), var1.getX() + 1, var1.getY() + 1, var1.getZ() + 1).inflate(this.spawnRange)).size();
            if (var18 >= this.maxNearbyEntities) {
                this.delay(var0, var1);
                return;
            }
            ((Entity)var17).moveTo(((Entity)var17).getX(), ((Entity)var17).getY(), ((Entity)var17).getZ(), var3.nextFloat() * 360.0f, 0.0f);
            if (var17 instanceof EntityInsentient) {
                EntityInsentient var19 = (EntityInsentient)var17;
                if (var4.getCustomSpawnRules().isEmpty() && !var19.checkSpawnRules(var0, EnumMobSpawn.SPAWNER) || !var19.checkSpawnObstruction(var0)) continue;
                if (var4.getEntityToSpawn().size() == 1 && var4.getEntityToSpawn().contains("id", 8)) {
                    ((EntityInsentient)var17).finalizeSpawn(var0, var0.getCurrentDifficultyAt(((Entity)var17).blockPosition()), EnumMobSpawn.SPAWNER, null, null);
                }
            }
            if (!var0.tryAddFreshEntityWithPassengers((Entity)var17)) {
                this.delay(var0, var1);
                return;
            }
            var0.levelEvent(2004, var1, 0);
            var0.gameEvent((Entity)var17, GameEvent.ENTITY_PLACE, var16);
            if (var17 instanceof EntityInsentient) {
                ((EntityInsentient)var17).spawnAnim();
            }
            var2 = true;
        }
        if (var2) {
            this.delay(var0, var1);
        }
    }

    private void delay(World var0, BlockPosition var1) {
        RandomSource var22 = var0.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + var22.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(var22).ifPresent(var2 -> this.setNextSpawnData(var0, var1, (MobSpawnerData)var2.getData()));
        this.broadcastEvent(var0, var1, 1);
    }

    public void load(@Nullable World var02, BlockPosition var1, NBTTagCompound var2) {
        boolean var4;
        this.spawnDelay = var2.getShort("Delay");
        boolean var3 = var2.contains(SPAWN_DATA_TAG, 10);
        if (var3) {
            MobSpawnerData var42 = MobSpawnerData.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var2.getCompound(SPAWN_DATA_TAG)).resultOrPartial(var0 -> LOGGER.warn("Invalid SpawnData: {}", var0)).orElseGet(MobSpawnerData::new);
            this.setNextSpawnData(var02, var1, var42);
        }
        if (var4 = var2.contains("SpawnPotentials", 9)) {
            NBTTagList var5 = var2.getList("SpawnPotentials", 10);
            this.spawnPotentials = MobSpawnerData.LIST_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var5).resultOrPartial(var0 -> LOGGER.warn("Invalid SpawnPotentials list: {}", var0)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single(this.nextSpawnData != null ? this.nextSpawnData : new MobSpawnerData());
        }
        if (var2.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = var2.getShort("MinSpawnDelay");
            this.maxSpawnDelay = var2.getShort("MaxSpawnDelay");
            this.spawnCount = var2.getShort("SpawnCount");
        }
        if (var2.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = var2.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = var2.getShort("RequiredPlayerRange");
        }
        if (var2.contains("SpawnRange", 99)) {
            this.spawnRange = var2.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putShort("Delay", (short)this.spawnDelay);
        var0.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        var0.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        var0.putShort("SpawnCount", (short)this.spawnCount);
        var0.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        var0.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        var0.putShort("SpawnRange", (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            var0.put(SPAWN_DATA_TAG, (NBTBase)MobSpawnerData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        var0.put("SpawnPotentials", (NBTBase)MobSpawnerData.LIST_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.spawnPotentials).result().orElseThrow());
        return var0;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(World var0, RandomSource var1, BlockPosition var2) {
        if (this.displayEntity == null) {
            NBTTagCompound var3 = this.getOrCreateNextSpawnData(var0, var1, var2).getEntityToSpawn();
            if (!var3.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityTypes.loadEntityRecursive(var3, var0, Function.identity());
            if (var3.size() != 1 || this.displayEntity instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(World var0, int var1) {
        if (var1 == 1) {
            if (var0.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable World var0, BlockPosition var1, MobSpawnerData var2) {
        this.nextSpawnData = var2;
    }

    private MobSpawnerData getOrCreateNextSpawnData(@Nullable World var0, RandomSource var1, BlockPosition var2) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(var0, var2, this.spawnPotentials.getRandom(var1).map(WeightedEntry.b::getData).orElseGet(MobSpawnerData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(World var1, BlockPosition var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

