/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;

public interface IWorldReader
extends IBlockLightAccess,
ICollisionAccess,
BiomeManager.Provider {
    @Nullable
    public IChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean hasChunk(int var1, int var2);

    public int getHeight(HeightMap.Type var1, int var2, int var3);

    public int getSkyDarken();

    public BiomeManager getBiomeManager();

    default public Holder<BiomeBase> getBiome(BlockPosition var0) {
        return this.getBiomeManager().getBiome(var0);
    }

    default public Stream<IBlockData> getBlockStatesIfLoaded(AxisAlignedBB var0) {
        int var6;
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.floor(var0.maxX);
        int var3 = MathHelper.floor(var0.minY);
        int var4 = MathHelper.floor(var0.maxY);
        int var5 = MathHelper.floor(var0.minZ);
        if (this.hasChunksAt(var1, var3, var5, var2, var4, var6 = MathHelper.floor(var0.maxZ))) {
            return this.getBlockStates(var0);
        }
        return Stream.empty();
    }

    @Override
    default public int getBlockTint(BlockPosition var0, ColorResolver var1) {
        return var1.getColor(this.getBiome(var0).value(), var0.getX(), var0.getZ());
    }

    @Override
    default public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        IChunkAccess var3 = this.getChunk(QuartPos.toSection(var0), QuartPos.toSection(var2), ChunkStatus.BIOMES, false);
        if (var3 != null) {
            return var3.getNoiseBiome(var0, var1, var2);
        }
        return this.getUncachedNoiseBiome(var0, var1, var2);
    }

    public Holder<BiomeBase> getUncachedNoiseBiome(int var1, int var2, int var3);

    public boolean isClientSide();

    @Deprecated
    public int getSeaLevel();

    public DimensionManager dimensionType();

    @Override
    default public int getMinBuildHeight() {
        return this.dimensionType().minY();
    }

    @Override
    default public int getHeight() {
        return this.dimensionType().height();
    }

    default public BlockPosition getHeightmapPos(HeightMap.Type var0, BlockPosition var1) {
        return new BlockPosition(var1.getX(), this.getHeight(var0, var1.getX(), var1.getZ()), var1.getZ());
    }

    default public boolean isEmptyBlock(BlockPosition var0) {
        return this.getBlockState(var0).isAir();
    }

    default public boolean canSeeSkyFromBelowWater(BlockPosition var0) {
        if (var0.getY() >= this.getSeaLevel()) {
            return this.canSeeSky(var0);
        }
        BlockPosition var1 = new BlockPosition(var0.getX(), this.getSeaLevel(), var0.getZ());
        if (!this.canSeeSky(var1)) {
            return false;
        }
        var1 = var1.below();
        while (var1.getY() > var0.getY()) {
            IBlockData var2 = this.getBlockState(var1);
            if (var2.getLightBlock(this, var1) > 0 && !var2.getMaterial().isLiquid()) {
                return false;
            }
            var1 = var1.below();
        }
        return true;
    }

    default public float getPathfindingCostFromLightLevels(BlockPosition var0) {
        return this.getLightLevelDependentMagicValue(var0) - 0.5f;
    }

    @Deprecated
    default public float getLightLevelDependentMagicValue(BlockPosition var0) {
        float var1 = (float)this.getMaxLocalRawBrightness(var0) / 15.0f;
        float var2 = var1 / (4.0f - 3.0f * var1);
        return MathHelper.lerp(this.dimensionType().ambientLight(), var2, 1.0f);
    }

    default public int getDirectSignal(BlockPosition var0, EnumDirection var1) {
        return this.getBlockState(var0).getDirectSignal(this, var0, var1);
    }

    default public IChunkAccess getChunk(BlockPosition var0) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    default public IChunkAccess getChunk(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, true);
    }

    default public IChunkAccess getChunk(int var0, int var1, ChunkStatus var2) {
        return this.getChunk(var0, var1, var2, true);
    }

    @Override
    @Nullable
    default public IBlockAccess getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.EMPTY, false);
    }

    default public boolean isWaterAt(BlockPosition var0) {
        return this.getFluidState(var0).is(TagsFluid.WATER);
    }

    default public boolean containsAnyLiquid(AxisAlignedBB var0) {
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.ceil(var0.maxX);
        int var3 = MathHelper.floor(var0.minY);
        int var4 = MathHelper.ceil(var0.maxY);
        int var5 = MathHelper.floor(var0.minZ);
        int var6 = MathHelper.ceil(var0.maxZ);
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (int var8 = var1; var8 < var2; ++var8) {
            for (int var9 = var3; var9 < var4; ++var9) {
                for (int var10 = var5; var10 < var6; ++var10) {
                    IBlockData var11 = this.getBlockState(var7.set(var8, var9, var10));
                    if (var11.getFluidState().isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int getMaxLocalRawBrightness(BlockPosition var0) {
        return this.getMaxLocalRawBrightness(var0, this.getSkyDarken());
    }

    default public int getMaxLocalRawBrightness(BlockPosition var0, int var1) {
        if (var0.getX() < -30000000 || var0.getZ() < -30000000 || var0.getX() >= 30000000 || var0.getZ() >= 30000000) {
            return 15;
        }
        return this.getRawBrightness(var0, var1);
    }

    @Deprecated
    default public boolean hasChunkAt(int var0, int var1) {
        return this.hasChunk(SectionPosition.blockToSectionCoord(var0), SectionPosition.blockToSectionCoord(var1));
    }

    @Deprecated
    default public boolean hasChunkAt(BlockPosition var0) {
        return this.hasChunkAt(var0.getX(), var0.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(BlockPosition var0, BlockPosition var1) {
        return this.hasChunksAt(var0.getX(), var0.getY(), var0.getZ(), var1.getX(), var1.getY(), var1.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(int var0, int var1, int var2, int var3, int var4, int var5) {
        if (var4 < this.getMinBuildHeight() || var1 >= this.getMaxBuildHeight()) {
            return false;
        }
        return this.hasChunksAt(var0, var2, var3, var5);
    }

    @Deprecated
    default public boolean hasChunksAt(int var0, int var1, int var2, int var3) {
        int var4 = SectionPosition.blockToSectionCoord(var0);
        int var5 = SectionPosition.blockToSectionCoord(var2);
        int var6 = SectionPosition.blockToSectionCoord(var1);
        int var7 = SectionPosition.blockToSectionCoord(var3);
        for (int var8 = var4; var8 <= var5; ++var8) {
            for (int var9 = var6; var9 <= var7; ++var9) {
                if (this.hasChunk(var8, var9)) continue;
                return false;
            }
        }
        return true;
    }

    public IRegistryCustom registryAccess();

    public FeatureFlagSet enabledFeatures();

    default public <T> HolderLookup<T> holderLookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
        IRegistry var1 = this.registryAccess().registryOrThrow(var0);
        return var1.asLookup().filterFeatures(this.enabledFeatures());
    }
}

