/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentArrowDamage;
import net.minecraft.world.item.enchantment.EnchantmentArrowKnockback;
import net.minecraft.world.item.enchantment.EnchantmentBinding;
import net.minecraft.world.item.enchantment.EnchantmentDepthStrider;
import net.minecraft.world.item.enchantment.EnchantmentDigging;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentFire;
import net.minecraft.world.item.enchantment.EnchantmentFlameArrows;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentInfiniteArrows;
import net.minecraft.world.item.enchantment.EnchantmentKnockback;
import net.minecraft.world.item.enchantment.EnchantmentLootBonus;
import net.minecraft.world.item.enchantment.EnchantmentLure;
import net.minecraft.world.item.enchantment.EnchantmentMending;
import net.minecraft.world.item.enchantment.EnchantmentMultishot;
import net.minecraft.world.item.enchantment.EnchantmentOxygen;
import net.minecraft.world.item.enchantment.EnchantmentPiercing;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.item.enchantment.EnchantmentQuickCharge;
import net.minecraft.world.item.enchantment.EnchantmentSilkTouch;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;
import net.minecraft.world.item.enchantment.EnchantmentSoulSpeed;
import net.minecraft.world.item.enchantment.EnchantmentSweeping;
import net.minecraft.world.item.enchantment.EnchantmentThorns;
import net.minecraft.world.item.enchantment.EnchantmentTridentChanneling;
import net.minecraft.world.item.enchantment.EnchantmentTridentImpaling;
import net.minecraft.world.item.enchantment.EnchantmentTridentLoyalty;
import net.minecraft.world.item.enchantment.EnchantmentTridentRiptide;
import net.minecraft.world.item.enchantment.EnchantmentVanishing;
import net.minecraft.world.item.enchantment.EnchantmentWaterWorker;
import net.minecraft.world.item.enchantment.EnchantmentWeaponDamage;
import net.minecraft.world.item.enchantment.SwiftSneakEnchantment;

public class Enchantments {
    private static final EnumItemSlot[] ARMOR_SLOTS = new EnumItemSlot[]{EnumItemSlot.HEAD, EnumItemSlot.CHEST, EnumItemSlot.LEGS, EnumItemSlot.FEET};
    public static final Enchantment ALL_DAMAGE_PROTECTION = Enchantments.register("protection", new EnchantmentProtection(Enchantment.Rarity.COMMON, EnchantmentProtection.DamageType.ALL, ARMOR_SLOTS));
    public static final Enchantment FIRE_PROTECTION = Enchantments.register("fire_protection", new EnchantmentProtection(Enchantment.Rarity.UNCOMMON, EnchantmentProtection.DamageType.FIRE, ARMOR_SLOTS));
    public static final Enchantment FALL_PROTECTION = Enchantments.register("feather_falling", new EnchantmentProtection(Enchantment.Rarity.UNCOMMON, EnchantmentProtection.DamageType.FALL, ARMOR_SLOTS));
    public static final Enchantment BLAST_PROTECTION = Enchantments.register("blast_protection", new EnchantmentProtection(Enchantment.Rarity.RARE, EnchantmentProtection.DamageType.EXPLOSION, ARMOR_SLOTS));
    public static final Enchantment PROJECTILE_PROTECTION = Enchantments.register("projectile_protection", new EnchantmentProtection(Enchantment.Rarity.UNCOMMON, EnchantmentProtection.DamageType.PROJECTILE, ARMOR_SLOTS));
    public static final Enchantment RESPIRATION = Enchantments.register("respiration", new EnchantmentOxygen(Enchantment.Rarity.RARE, ARMOR_SLOTS));
    public static final Enchantment AQUA_AFFINITY = Enchantments.register("aqua_affinity", new EnchantmentWaterWorker(Enchantment.Rarity.RARE, ARMOR_SLOTS));
    public static final Enchantment THORNS = Enchantments.register("thorns", new EnchantmentThorns(Enchantment.Rarity.VERY_RARE, ARMOR_SLOTS));
    public static final Enchantment DEPTH_STRIDER = Enchantments.register("depth_strider", new EnchantmentDepthStrider(Enchantment.Rarity.RARE, ARMOR_SLOTS));
    public static final Enchantment FROST_WALKER = Enchantments.register("frost_walker", new EnchantmentFrostWalker(Enchantment.Rarity.RARE, EnumItemSlot.FEET));
    public static final Enchantment BINDING_CURSE = Enchantments.register("binding_curse", new EnchantmentBinding(Enchantment.Rarity.VERY_RARE, ARMOR_SLOTS));
    public static final Enchantment SOUL_SPEED = Enchantments.register("soul_speed", new EnchantmentSoulSpeed(Enchantment.Rarity.VERY_RARE, EnumItemSlot.FEET));
    public static final Enchantment SWIFT_SNEAK = Enchantments.register("swift_sneak", new SwiftSneakEnchantment(Enchantment.Rarity.VERY_RARE, EnumItemSlot.LEGS));
    public static final Enchantment SHARPNESS = Enchantments.register("sharpness", new EnchantmentWeaponDamage(Enchantment.Rarity.COMMON, 0, EnumItemSlot.MAINHAND));
    public static final Enchantment SMITE = Enchantments.register("smite", new EnchantmentWeaponDamage(Enchantment.Rarity.UNCOMMON, 1, EnumItemSlot.MAINHAND));
    public static final Enchantment BANE_OF_ARTHROPODS = Enchantments.register("bane_of_arthropods", new EnchantmentWeaponDamage(Enchantment.Rarity.UNCOMMON, 2, EnumItemSlot.MAINHAND));
    public static final Enchantment KNOCKBACK = Enchantments.register("knockback", new EnchantmentKnockback(Enchantment.Rarity.UNCOMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment FIRE_ASPECT = Enchantments.register("fire_aspect", new EnchantmentFire(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment MOB_LOOTING = Enchantments.register("looting", new EnchantmentLootBonus(Enchantment.Rarity.RARE, EnchantmentSlotType.WEAPON, EnumItemSlot.MAINHAND));
    public static final Enchantment SWEEPING_EDGE = Enchantments.register("sweeping", new EnchantmentSweeping(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment BLOCK_EFFICIENCY = Enchantments.register("efficiency", new EnchantmentDigging(Enchantment.Rarity.COMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment SILK_TOUCH = Enchantments.register("silk_touch", new EnchantmentSilkTouch(Enchantment.Rarity.VERY_RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment UNBREAKING = Enchantments.register("unbreaking", new EnchantmentDurability(Enchantment.Rarity.UNCOMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment BLOCK_FORTUNE = Enchantments.register("fortune", new EnchantmentLootBonus(Enchantment.Rarity.RARE, EnchantmentSlotType.DIGGER, EnumItemSlot.MAINHAND));
    public static final Enchantment POWER_ARROWS = Enchantments.register("power", new EnchantmentArrowDamage(Enchantment.Rarity.COMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment PUNCH_ARROWS = Enchantments.register("punch", new EnchantmentArrowKnockback(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment FLAMING_ARROWS = Enchantments.register("flame", new EnchantmentFlameArrows(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment INFINITY_ARROWS = Enchantments.register("infinity", new EnchantmentInfiniteArrows(Enchantment.Rarity.VERY_RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment FISHING_LUCK = Enchantments.register("luck_of_the_sea", new EnchantmentLootBonus(Enchantment.Rarity.RARE, EnchantmentSlotType.FISHING_ROD, EnumItemSlot.MAINHAND));
    public static final Enchantment FISHING_SPEED = Enchantments.register("lure", new EnchantmentLure(Enchantment.Rarity.RARE, EnchantmentSlotType.FISHING_ROD, EnumItemSlot.MAINHAND));
    public static final Enchantment LOYALTY = Enchantments.register("loyalty", new EnchantmentTridentLoyalty(Enchantment.Rarity.UNCOMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment IMPALING = Enchantments.register("impaling", new EnchantmentTridentImpaling(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment RIPTIDE = Enchantments.register("riptide", new EnchantmentTridentRiptide(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment CHANNELING = Enchantments.register("channeling", new EnchantmentTridentChanneling(Enchantment.Rarity.VERY_RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment MULTISHOT = Enchantments.register("multishot", new EnchantmentMultishot(Enchantment.Rarity.RARE, EnumItemSlot.MAINHAND));
    public static final Enchantment QUICK_CHARGE = Enchantments.register("quick_charge", new EnchantmentQuickCharge(Enchantment.Rarity.UNCOMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment PIERCING = Enchantments.register("piercing", new EnchantmentPiercing(Enchantment.Rarity.COMMON, EnumItemSlot.MAINHAND));
    public static final Enchantment MENDING = Enchantments.register("mending", new EnchantmentMending(Enchantment.Rarity.RARE, EnumItemSlot.values()));
    public static final Enchantment VANISHING_CURSE = Enchantments.register("vanishing_curse", new EnchantmentVanishing(Enchantment.Rarity.VERY_RARE, EnumItemSlot.values()));

    private static Enchantment register(String var0, Enchantment var1) {
        return IRegistry.register(BuiltInRegistries.ENCHANTMENT, var0, var1);
    }
}

